/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.intl;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.intl.DisplayNamesPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.intl.JSDisplayNames;
import com.oracle.truffle.js.runtime.builtins.intl.JSDisplayNamesObject;

public final class DisplayNamesPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<DisplayNamesPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new DisplayNamesPrototypeBuiltins();

    protected DisplayNamesPrototypeBuiltins() {
        super(JSDisplayNames.PROTOTYPE_NAME, DisplayNamesPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context2, JSBuiltin builtin, boolean construct, boolean newTarget, DisplayNamesPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return DisplayNamesPrototypeBuiltinsFactory.JSDisplayNamesResolvedOptionsNodeGen.create(context2, builtin, DisplayNamesPrototypeBuiltins.args().withThis().createArgumentNodes(context2));
            }
            case 1: {
                return DisplayNamesPrototypeBuiltinsFactory.JSDisplayNamesOfNodeGen.create(context2, builtin, DisplayNamesPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
        }
        return null;
    }

    public static enum DisplayNamesPrototype implements BuiltinEnum<DisplayNamesPrototype>
    {
        resolvedOptions(0),
        of(1);

        private final int length;

        private DisplayNamesPrototype(int length2) {
            this.length = length2;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class JSDisplayNamesResolvedOptionsNode
    extends JSBuiltinNode {
        public JSDisplayNamesResolvedOptionsNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        public Object doDisplayNames(JSDisplayNamesObject displayNames) {
            return JSDisplayNames.resolvedOptions(this.getContext(), this.getRealm(), displayNames);
        }

        @Specialization(guards={"!isJSDisplayNames(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorDisplayNamesExpected();
        }
    }

    public static abstract class JSDisplayNamesOfNode
    extends JSBuiltinNode {
        @Node.Child
        JSToStringNode toStringNode = JSToStringNode.create();

        public JSDisplayNamesOfNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        public Object doDisplayNames(JSDisplayNamesObject displayNames, Object code) {
            TruffleString codeString = this.toStringNode.executeString(code);
            return JSDisplayNames.of(displayNames, Strings.toJavaString(codeString));
        }

        @Specialization(guards={"!isJSDisplayNames(bummer)"})
        public Object doOther(Object bummer, Object code) {
            throw Errors.createTypeErrorDisplayNamesExpected();
        }
    }
}

