/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.Index;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.run.ui.DataAccessType;
import java.util.function.IntUnaryOperator;
import org.jetbrains.annotations.NotNull;

public abstract class ModelIndex<S>
extends Index {
    public static <RowType> ModelIndex<RowType> forRow(CoreGrid<RowType, ?> grid, int row) {
        return ModelIndex.forRow(grid.getDataModel(DataAccessType.DATABASE_DATA), row);
    }

    public static <RowType> ModelIndex<RowType> forRow(GridModel<RowType, ?> model, int row) {
        return new Row(row);
    }

    public static <ColumnType> ModelIndex<ColumnType> forColumn(CoreGrid<?, ColumnType> grid, int column) {
        return ModelIndex.forColumn(grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS), column);
    }

    public static <ColumnType> ModelIndex<ColumnType> forColumn(GridModel<?, ColumnType> model, int column) {
        return new Column(column);
    }

    private ModelIndex(int value) {
        super(value);
    }

    @NotNull
    public abstract ViewIndex<S> toView(@NotNull CoreGrid<?, ?> var1);

    public abstract boolean isValid(@NotNull GridModel<?, ?> var1);

    public boolean isValid(@NotNull CoreGrid<?, ?> grid) {
        if (grid == null) {
            ModelIndex.$$$reportNull$$$0(0);
        }
        return this.isValid(grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS));
    }

    public String toString() {
        return "Model" + this.getClass().getSimpleName() + "{" + this.value + "}";
    }

    static IntUnaryOperator row2View(CoreGrid<?, ?> grid) {
        return grid.getRawIndexConverter().row2View();
    }

    static IntUnaryOperator col2View(CoreGrid<?, ?> grid) {
        return grid.getRawIndexConverter().column2View();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/ModelIndex", "isValid"));
    }

    private static class Row<RowType>
    extends ModelIndex<RowType> {
        Row(int value) {
            super(value);
        }

        @Override
        @NotNull
        public ViewIndex<RowType> toView(@NotNull CoreGrid<?, ?> grid) {
            if (grid == null) {
                Row.$$$reportNull$$$0(0);
            }
            ViewIndex<?> viewIndex = ViewIndex.forRow(grid, Row.row2View(grid).applyAsInt(this.value));
            if (viewIndex == null) {
                Row.$$$reportNull$$$0(1);
            }
            return viewIndex;
        }

        @Override
        public boolean isValid(@NotNull GridModel<?, ?> model) {
            if (model == null) {
                Row.$$$reportNull$$$0(2);
            }
            return model.isValidRowIdx(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/ModelIndex$Row";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/ModelIndex$Row";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toView";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "toView";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isValid";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class Column<ColumnType>
    extends ModelIndex<ColumnType> {
        Column(int value) {
            super(value);
        }

        @Override
        @NotNull
        public ViewIndex<ColumnType> toView(@NotNull CoreGrid<?, ?> grid) {
            if (grid == null) {
                Column.$$$reportNull$$$0(0);
            }
            ViewIndex<?> viewIndex = ViewIndex.forColumn(grid, Column.col2View(grid).applyAsInt(this.value));
            if (viewIndex == null) {
                Column.$$$reportNull$$$0(1);
            }
            return viewIndex;
        }

        @Override
        public boolean isValid(@NotNull GridModel<?, ?> model) {
            if (model == null) {
                Column.$$$reportNull$$$0(2);
            }
            return model.isValidColumnIdx(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/ModelIndex$Column";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/ModelIndex$Column";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toView";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "toView";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isValid";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

