/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.session;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.client.VisibleDatabaseSessionClient;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.util.DataSourceUtilKt;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableConvertor;
import icons.DatabaseIcons;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u009c\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u001aB\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u0003\"\b\b\u0002\u0010\u0004*\u00020\u00052\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00040\u0007\u001a6\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\t0\u0001\"\u0004\b\u0000\u0010\u0002\"\b\b\u0001\u0010\u0004*\u00020\u00052\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\n\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007\u001a$\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0007\u001a\u0016\u0010\u001b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u001cH\u0086@\u00a2\u0006\u0002\u0010\u001d\u001a\u0016\u0010\u001e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u001cH\u0080@\u00a2\u0006\u0002\u0010\u001d\u001a\u0018\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!H\u0000\u001a\u0018\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#H\u0000\u001a\u001a\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a \u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\f\u001a\u0010\u0010$\u001a\u00020%2\u0006\u0010)\u001a\u00020\fH\u0000\u001a\u001a\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007\u001a\u0012\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007\u001a\u000e\u0010.\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u000e\u0010/\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u000e\u00100\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0018\u00105\u001a\u00020-2\u0006\u00106\u001a\u00020\f2\u0006\u00107\u001a\u000202H\u0003\u001a\u0012\u00108\u001a\u0004\u0018\u00010-2\u0006\u0010\u0013\u001a\u00020\u0014H\u0003\u001a\u000e\u00109\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u000e\u0010:\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u000e\u0010;\u001a\u00020\f2\u0006\u0010 \u001a\u00020<\u001a\u000e\u0010=\u001a\u00020\t2\u0006\u0010 \u001a\u00020<\u001a\u0010\u0010>\u001a\u00020-2\u0006\u0010\"\u001a\u00020#H\u0007\u001a\u0010\u0010?\u001a\u00020-2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007\u001a\u0010\u0010@\u001a\u00020-2\u0006\u0010\"\u001a\u00020#H\u0007\u001a\"\u0010A\u001a\u00020-2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010B2\u0006\u0010\"\u001a\u00020#H\u0007\u001a\u0010\u0010A\u001a\u00020-2\u0006\u0010 \u001a\u00020!H\u0007\u001a\u0018\u0010C\u001a\u00020-2\u0006\u0010\"\u001a\u00020#2\u0006\u0010D\u001a\u00020\fH\u0003\u001a(\u0010E\u001a\u00020-*\u00020-2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010B2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0003\"\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u00101\u001a\u000202X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u00103\u001a\u000204X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"function", "Lkotlin/Function1;", "T", "R", "E", "", "func", "Lcom/intellij/util/ThrowableConvertor;", "consumer", "", "Lcom/intellij/util/ThrowableConsumer;", "isInternalOwner", "", "owner", "Lcom/intellij/database/datagrid/DataRequest$Owner;", "isInternalDepartment", "department", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "deactivateDataSourceAsync", "session", "Lcom/intellij/database/console/session/DatabaseSession;", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "configuration", "Lcom/intellij/database/run/ConsoleRunConfiguration;", "cancel", "Lcom/intellij/database/datagrid/DataRequest$OwnerEx;", "(Lcom/intellij/database/datagrid/DataRequest$OwnerEx;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "disconnect", "needToSaveSessionName", "client", "Lcom/intellij/database/console/client/DatabaseSessionClientWithFile;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getProgressIcon", "Ljavax/swing/Icon;", "work", "Lcom/intellij/database/console/session/DatabaseSession$State$Work;", "idleIcon", "cancelled", "cancelledProgressIcon", "Lcom/intellij/ui/LayeredIcon;", "getTimeSpent", "", "needToShowProgress", "hasAnyNonFinishedWork", "needToShowTimeSpent", "SECOND", "", "progressTimeout", "", "formatDuration", "inProgress", "time", "getIdleMessage", "canClose", "close", "canDetach", "Lcom/intellij/database/console/client/VisibleDatabaseSessionClient;", "detach", "getSessionTitle", "getQualifiedSessionTitle", "getClientTitle", "getQualifiedClientTitle", "Lcom/intellij/database/model/DasDataSource;", "getTitle", "trimExtension", "qualify", "intellij.database.connectivity"})
@JvmName(name="SessionsUtil")
@SourceDebugExtension(value={"SMAP\nSessionsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionsUtil.kt\ncom/intellij/database/console/session/SessionsUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,224:1\n1755#2,3:225\n1#3:228\n*S KotlinDebug\n*F\n+ 1 SessionsUtil.kt\ncom/intellij/database/console/session/SessionsUtil\n*L\n159#1:225,3\n*E\n"})
public final class SessionsUtil {
    @NotNull
    private static final LayeredIcon cancelledProgressIcon = LayeredIcon.Companion.layeredIcon(SessionsUtil::cancelledProgressIcon$lambda$4);
    private static final long SECOND = 1000L;
    public static final int progressTimeout = 1000;

    @NotNull
    public static final <T, R, E extends Throwable> Function1<T, R> function(@NotNull ThrowableConvertor<T, R, E> func) {
        Intrinsics.checkNotNullParameter(func, (String)"func");
        return arg_0 -> SessionsUtil.function$lambda$0(func, arg_0);
    }

    @NotNull
    public static final <T, E extends Throwable> Function1<T, Unit> consumer(@NotNull ThrowableConsumer<T, E> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        return arg_0 -> SessionsUtil.consumer$lambda$1(consumer, arg_0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInternalOwner(@NotNull DataRequest.Owner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        if (!(owner instanceof DatabaseSessionClient)) return false;
        DatabaseDepartment databaseDepartment = ((DatabaseSessionClient)owner).getDepartment();
        Intrinsics.checkNotNullExpressionValue((Object)databaseDepartment, (String)"getDepartment(...)");
        if (!SessionsUtil.isInternalDepartment(databaseDepartment)) return false;
        return true;
    }

    public static final boolean isInternalDepartment(@NotNull DatabaseDepartment department) {
        Intrinsics.checkNotNullParameter((Object)department, (String)"department");
        return !ApplicationManager.getApplication().isUnitTestMode() && department.isInternal() && !department.isService();
    }

    @Deprecated(message="Do not break structured concurrency, await completion", replaceWith=@ReplaceWith(expression="deactivate", imports={}))
    public static final void deactivateDataSourceAsync(@NotNull DatabaseSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Project project = session.getProject();
        LocalDataSource localDataSource = session.getConnectionPoint().getDataSource();
        Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
        SessionsUtil.deactivateDataSourceAsync(project, localDataSource, session.getConfiguration());
    }

    @Deprecated(message="Do not break structured concurrency, await completion", replaceWith=@ReplaceWith(expression="deactivate", imports={}))
    public static final void deactivateDataSourceAsync(@NotNull Project project, @NotNull LocalDataSource dataSource, @Nullable ConsoleRunConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.childScope$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (String)"Deactivate data source", null, (boolean)false, (int)6, null), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, dataSource, configuration, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ LocalDataSource $dataSource;
            final /* synthetic */ ConsoleRunConfiguration $configuration;
            {
                this.$project = $project;
                this.$dataSource = $dataSource;
                this.$configuration = $configuration;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = DataSourceUtilKt.deactivate(this.$project, this.$dataSource, this.$configuration, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static /* synthetic */ void deactivateDataSourceAsync$default(Project project, LocalDataSource localDataSource, ConsoleRunConfiguration consoleRunConfiguration, int n, Object object) {
        if ((n & 4) != 0) {
            consoleRunConfiguration = null;
        }
        SessionsUtil.deactivateDataSourceAsync(project, localDataSource, consoleRunConfiguration);
    }

    @Nullable
    public static final Object cancel(@NotNull DataRequest.OwnerEx owner, @NotNull Continuation<? super Unit> $completion) {
        DataRequest.Cancel cancel;
        DataRequest.Cancel it = cancel = new DataRequest.Cancel(owner);
        boolean bl = false;
        owner.getMessageBus().getDataProducer().processRequest((GridDataRequest)it);
        AsyncPromise<Void> asyncPromise = cancel.getPromise();
        Intrinsics.checkNotNullExpressionValue(asyncPromise, (String)"getPromise(...)");
        Object object = Promises.await((Promise)((Promise)asyncPromise), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public static final Object disconnect(@NotNull DataRequest.OwnerEx owner, @NotNull Continuation<? super Unit> $completion) {
        DataRequest.Disconnect disconnect;
        DataRequest.Disconnect it = disconnect = new DataRequest.Disconnect(owner);
        boolean bl = false;
        owner.getMessageBus().getDataProducer().processRequest((GridDataRequest)it);
        AsyncPromise<Void> asyncPromise = disconnect.getPromise();
        Intrinsics.checkNotNullExpressionValue(asyncPromise, (String)"getPromise(...)");
        Object object = Promises.await((Promise)((Promise)asyncPromise), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static final boolean needToSaveSessionName(@NotNull DatabaseSession session, @NotNull DatabaseSessionClientWithFile client) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return SessionsUtil.needToSaveSessionName(session, client.getVirtualFile());
    }

    public static final boolean needToSaveSessionName(@NotNull DatabaseSession session, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return !session.isService() && !Intrinsics.areEqual((Object)session.getTitle(), (Object)SessionsUtil.getSessionTitle(file));
    }

    @Nullable
    public static final Icon getProgressIcon(@NotNull DatabaseSession.State.Work work, @NotNull DatabaseSession session) {
        Intrinsics.checkNotNullParameter((Object)work, (String)"work");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return SessionsUtil.getProgressIcon(work, session, false);
    }

    @Nullable
    public static final Icon getProgressIcon(@NotNull DatabaseSession.State.Work work, @NotNull DatabaseSession session, boolean idleIcon) {
        Intrinsics.checkNotNullParameter((Object)work, (String)"work");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return work.getState() != DatabaseSession.State.WorkState.FINISHED && SessionsUtil.needToShowProgress(session) ? (idleIcon && work.getState() == DatabaseSession.State.WorkState.SUBMITTED ? AllIcons.RunConfigurations.TestNotRan : SessionsUtil.getProgressIcon(work.getState() == DatabaseSession.State.WorkState.CANCELLING)) : null;
    }

    @NotNull
    public static final Icon getProgressIcon(boolean cancelled) {
        Icon icon;
        if (cancelled) {
            icon = (Icon)cancelledProgressIcon;
        } else {
            AnimatedIcon animatedIcon = AnimatedIcon.Default.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)animatedIcon, (String)"INSTANCE");
            icon = (Icon)animatedIcon;
        }
        return icon;
    }

    @NlsContexts.Tooltip
    @Nullable
    public static final String getTimeSpent(@NotNull DatabaseSession.State.Work work, @NotNull DatabaseSession session) {
        Intrinsics.checkNotNullParameter((Object)work, (String)"work");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (!SessionsUtil.needToShowTimeSpent(session)) {
            return null;
        }
        long time = work.getTimeSpentMs();
        if (time <= 0L) {
            return null;
        }
        DatabaseSession.State.WorkState workState = work.getState();
        return workState != DatabaseSession.State.WorkState.SUBMITTED ? SessionsUtil.formatDuration(workState.getInProgress(), time) : SessionsUtil.getIdleMessage(session);
    }

    @NlsSafe
    @Nullable
    public static final String getTimeSpent(@NotNull DatabaseSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (!SessionsUtil.needToShowTimeSpent(session)) {
            return null;
        }
        DatabaseSession.State state = session.getState();
        long time = state.getTimeSpentMs();
        return time <= 0L ? null : SessionsUtil.formatDuration(!state.isIdle(), time);
    }

    public static final boolean needToShowProgress(@NotNull DatabaseSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        DatabaseSession.State state = session.getState();
        return SessionsUtil.hasAnyNonFinishedWork(session) && System.currentTimeMillis() - state.getStartTime() >= 1000L;
    }

    public static final boolean hasAnyNonFinishedWork(@NotNull DatabaseSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        DatabaseSession.State state = session.getState();
        return !state.isIdle() && state.getStartTime() != 0L;
    }

    public static final boolean needToShowTimeSpent(@NotNull DatabaseSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        DatabaseSession.State state = session.getState();
        return !state.isEmpty() && (state.isIdle() || state.getTimeSpentMs() >= 1000L);
    }

    @NlsSafe
    private static final String formatDuration(boolean inProgress, long time) {
        long timeToFormat = inProgress && time > 3000L ? time / 1000L * 1000L : time;
        String string = StringUtil.formatDuration((long)timeToFormat);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatDuration(...)");
        return string;
    }

    @NlsContexts.Tooltip
    private static final String getIdleMessage(DatabaseSession session) {
        boolean bl;
        block3: {
            DatabaseSession.State state = session.getState();
            List<DatabaseSession.State.Work> work = state.getWork();
            Iterable $this$any$iv = work;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DatabaseSession.State.Work w = (DatabaseSession.State.Work)element$iv;
                    boolean bl2 = false;
                    if (!w.getState().getInProgress()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl ? DatabaseBundle.message("tooltip.waiting", new Object[0]) : null;
    }

    public static final boolean canClose(@NotNull DatabaseSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return session.isIdle();
    }

    public static final void close(@NotNull DatabaseSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        for (DatabaseSessionClient client : session.getClients()) {
            session.detach(client);
        }
        Disposer.dispose((Disposable)session);
    }

    public static final boolean canDetach(@NotNull VisibleDatabaseSessionClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return ((DatabaseSession)client.getSession()).isIdle();
    }

    public static final void detach(@NotNull VisibleDatabaseSessionClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        ((DatabaseSession)client.getSession()).detach(client);
    }

    @Nls
    @NotNull
    public static final String getSessionTitle(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return SessionsUtil.getTitle(file, true);
    }

    @Nls
    @NotNull
    public static final String getQualifiedSessionTitle(@NotNull DatabaseSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return SessionsUtil.qualify(session.getTitle(), session.getProject(), session.getConnectionPoint().getDataSource(), null);
    }

    @Nls
    @NotNull
    public static final String getClientTitle(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return SessionsUtil.getTitle(file, false);
    }

    @Nls
    @NotNull
    public static final String getQualifiedClientTitle(@NotNull Project project, @Nullable DasDataSource dataSource, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return SessionsUtil.qualify(SessionsUtil.getClientTitle(file), project, dataSource, file);
    }

    @Nls
    @NotNull
    public static final String getQualifiedClientTitle(@NotNull DatabaseSessionClientWithFile client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return SessionsUtil.qualify(client.getTitle(), ((DatabaseSession)client.getSession()).getProject(), ((DatabaseSession)client.getSession()).getConnectionPoint().getDataSource(), client.getVirtualFile());
    }

    @Nls
    private static final String getTitle(VirtualFile file, boolean trimExtension) {
        String string = DbVFSUtils.isConsoleFile(file) ? file.getNameWithoutExtension() : (DbSrcUtils.isDbSrcFile(file) ? file.getNameWithoutExtension() : (file instanceof DatabaseElementVirtualFileImpl ? ((DatabaseElementVirtualFileImpl)file).getName() : (trimExtension ? file.getNameWithoutExtension() : file.getName())));
        Intrinsics.checkNotNull((Object)string);
        String name2 = string;
        String string2 = StringUtil.unescapeXmlEntities((String)name2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"unescapeXmlEntities(...)");
        return string2;
    }

    @Nls
    private static final String qualify(String $this$qualify, Project project, DasDataSource dataSource, VirtualFile file) {
        boolean bl;
        if (dataSource == null) {
            return $this$qualify;
        }
        if (DataSourceStorage.getProjectStorage(project).getDataSourcesImpl().skip(1).isEmpty()) {
            return $this$qualify;
        }
        VirtualFile virtualFile = file;
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl2 = false;
            bl = !DbVFSUtils.isAssociatedWithDataSource(file);
        } else {
            bl = false;
        }
        if (bl) {
            return $this$qualify;
        }
        return $this$qualify + " [" + dataSource.getName() + "]";
    }

    private static final Object function$lambda$0(ThrowableConvertor $func, Object t) {
        return $func.convert(t);
    }

    private static final Unit consumer$lambda$1(ThrowableConsumer $consumer, Object t) {
        $consumer.consume(t);
        return Unit.INSTANCE;
    }

    private static final Icon[] cancelledProgressIcon$lambda$4() {
        Icon[] iconArray = new Icon[]{AnimatedIcon.Default.INSTANCE, DatabaseIcons.SuspendScaled};
        return iconArray;
    }
}

