/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.editor;

import com.intellij.database.Dbms;
import com.intellij.database.actions.ImportAction;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGridListModel;
import com.intellij.database.datagrid.JdbcColumnDescriptor;
import com.intellij.database.datagrid.JdbcGridColumn;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.AbstractDataSourceType;
import com.intellij.database.dbimport.CachedDataSourceType;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dbimport.csv.CsvSourceType;
import com.intellij.database.dbimport.editor.DbImportCachedDataManager;
import com.intellij.database.dbimport.editor.DbImportDialog;
import com.intellij.database.dbimport.editor.DbImportDialogPanel;
import com.intellij.database.dbimport.editor.data.CsvSourceData;
import com.intellij.database.dbimport.editor.data.DataSourceData;
import com.intellij.database.dbimport.editor.data.DbQuerySourceData;
import com.intellij.database.dbimport.editor.data.DbTableSourceData;
import com.intellij.database.dbimport.editor.data.MappingData;
import com.intellij.database.dbimport.editor.data.ScriptedSourceData;
import com.intellij.database.dbimport.editor.model.state.DbAutoDefinitionState;
import com.intellij.database.dbimport.scripted.ScriptedSourceType;
import com.intellij.database.loaders.DataLoader;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.WrapperElement;
import com.intellij.database.model.basic.WrapperElementFactory;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbTable;
import com.intellij.database.run.ui.grid.editors.GridCellEditorHelper;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.applier.DbReferenceModelApplier;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.DbContextDataSourceElements;
import com.intellij.database.view.DbContextElementsKt;
import com.intellij.grid.scripting.impl.DataLoaderManager;
import com.intellij.grid.scripting.impl.ScriptedGridDataHookUp;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbImportAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            DbImportAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DbImportAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabledAndVisible(DbImportAction.getSelection(e).isNotEmpty());
    }

    @NotNull
    private static JBIterable<DbContextDataSourceElements<?>> getSelection(@NotNull AnActionEvent e) {
        if (e == null) {
            DbImportAction.$$$reportNull$$$0(2);
        }
        JBIterable jBIterable = DbContextElementsKt.getContextDataSourceElements(e).map(c2 -> c2.parentsForGroups().asDbElements().replace(s -> s.asIterable().filter(ImportUtil::canBeConsumer))).filter(s -> s.asIterable().isNotEmpty()).collect();
        if (jBIterable == null) {
            DbImportAction.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        JBIterable<DbContextDataSourceElements<?>> selection;
        DbContextDataSourceElements any;
        if (e == null) {
            DbImportAction.$$$reportNull$$$0(4);
        }
        if ((any = (DbContextDataSourceElements)(selection = DbImportAction.getSelection(e)).first()) == null) {
            return;
        }
        Project project = any.getProject();
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(true, false, true, true, true, true);
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)project, null, files2 -> DbImportAction.showDialog(project, selection, files2, (Iterable<DbContextDataSourceElements<BasicTable>>)JBIterable.empty(), DbImportDialog.InvocationType.IMPORT_ACTION_ON_DATABASE_OBJECT));
    }

    public static void showDialog(@NotNull Project project, @Nullable DbElement element, @NotNull List<VirtualFile> files2, @NotNull DbImportDialog.InvocationType invocation) {
        if (project == null) {
            DbImportAction.$$$reportNull$$$0(5);
        }
        if (files2 == null) {
            DbImportAction.$$$reportNull$$$0(6);
        }
        if (invocation == null) {
            DbImportAction.$$$reportNull$$$0(7);
        }
        DbImportAction.showDialog(project, element == null ? Collections.emptyList() : DbImportAction.createTarget(project, element), files2, (Iterable<DbContextDataSourceElements<BasicTable>>)JBIterable.empty(), invocation);
    }

    @NotNull
    private static JBIterable<DbContextDataSourceElements<?>> createTarget(@NotNull Project project, @NotNull DbElement element) {
        if (project == null) {
            DbImportAction.$$$reportNull$$$0(8);
        }
        if (element == null) {
            DbImportAction.$$$reportNull$$$0(9);
        }
        JBIterable jBIterable = JBIterable.of(new DbContextDataSourceElements(project, element.getDataSource().getDelegateDataSource(), JBIterable.of((Object)element)));
        if (jBIterable == null) {
            DbImportAction.$$$reportNull$$$0(10);
        }
        return jBIterable;
    }

    public static void showDialog(final @NotNull Project project, final @NotNull List<Pair<ImportAction.SourceType, ImportInfo.Builder>> sources, final @Nullable DbElement element, @NotNull Dbms dbms, @NotNull DbImportDialog.InvocationType invocation) {
        if (project == null) {
            DbImportAction.$$$reportNull$$$0(11);
        }
        if (sources == null) {
            DbImportAction.$$$reportNull$$$0(12);
        }
        if (dbms == null) {
            DbImportAction.$$$reportNull$$$0(13);
        }
        if (invocation == null) {
            DbImportAction.$$$reportNull$$$0(14);
        }
        DbImportDialog.showDialog(new DbImportDialogPanel.ImportDialogBootstrapper(project, invocation){

            @Override
            @NotNull
            public ElementIdentity<?> prepareTargetIdentity(@NotNull DbEditorModelController controller, @NotNull ElementOwner targetOwner) {
                if (controller == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (targetOwner == null) {
                    1.$$$reportNull$$$0(1);
                }
                ElementIdentity<?> rootId2 = super.prepareTargetIdentity(controller, targetOwner);
                for (Pair source : sources) {
                    ElementIdentity<WrapperElement<Cloneable>> sourceId = null;
                    Object object = source.first;
                    if (object instanceof CsvSourceType) {
                        CsvSourceType csv = (CsvSourceType)object;
                        sourceId = DbImportAction.createCsvSource(controller, targetOwner, rootId2, csv.getFile());
                    } else {
                        object = source.first;
                        if (object instanceof ScriptedSourceType) {
                            ScriptedSourceType scripted = (ScriptedSourceType)object;
                            sourceId = DbImportAction.createScriptedSource(controller, targetOwner, rootId2, scripted.getInputFile(), scripted.getLoader(), scripted.getFirstRowIsHeader());
                        } else {
                            object = source.first;
                            if (object instanceof AbstractDataSourceType) {
                                List<Object[]> cachedData;
                                AbstractDataSourceType db = (AbstractDataSourceType)object;
                                DbTable table = db.getTable();
                                List<Object[]> list = cachedData = db instanceof CachedDataSourceType ? ((CachedDataSourceType)db).getRows() : null;
                                if (db.isDefaultQuery() && table != null) {
                                    sourceId = DbImportAction.createDbTableSource(controller, targetOwner, rootId2, table, cachedData != null);
                                } else {
                                    BasicElement nsp;
                                    ObjectPath path = SearchPath.getCurrent(db.getSearchPath());
                                    DbDataSource dbDs = DbPsiFacade.getInstance(project).findDataSource(db.getProducerSystem().getUniqueId());
                                    LocalDataSource lds = DbImplUtilCore.getMaybeLocalDataSource(dbDs);
                                    BasicElement basicElement = dbDs == null ? null : (nsp = DbImplUtilCore.getMaybeBasicElement(path == null ? null : dbDs.findElement(path)));
                                    ElementIdentity<WrapperElement<Cloneable>> elementIdentity = lds == null ? null : (sourceId = DbImportAction.createDbQuerySource(targetOwner, rootId2, lds, (BasicNamespace)ObjectUtils.tryCast((Object)nsp, BasicNamespace.class), StringUtil.nullize((String)db.getProducerName()), db.getQueryText(), cachedData != null));
                                }
                                if (sourceId != null && cachedData != null) {
                                    DataGridListModel data = DbImportAction.composeModel(cachedData, ((ImportInfo.Builder)source.second).getProducers());
                                    DbImportCachedDataManager.getInstance(controller).setCachedData(sourceId, data);
                                }
                            }
                        }
                    }
                    if (sourceId == null) continue;
                    DbImportAction.createMapping(controller, targetOwner, sourceId, element);
                }
                ElementIdentity<?> elementIdentity = rootId2;
                if (elementIdentity == null) {
                    1.$$$reportNull$$$0(2);
                }
                return elementIdentity;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "controller";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "targetOwner";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dbimport/editor/DbImportAction$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dbimport/editor/DbImportAction$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "prepareTargetIdentity";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "prepareTargetIdentity";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        });
    }

    private static DataGridListModel composeModel(List<Object[]> rows, List<? extends ColumnDescriptor> columns) {
        DataGridListModel res2 = new DataGridListModel(GridCellEditorHelper::areValuesEqual);
        for (int i2 = 0; i2 < rows.size(); ++i2) {
            res2.addRow((Object)DataConsumer.Row.create((int)i2, (Object[])rows.get(i2)));
        }
        ArrayList<DataConsumer.Column> modelColumns = new ArrayList<DataConsumer.Column>(columns.size());
        for (int i3 = 0; i3 < columns.size(); ++i3) {
            modelColumns.add(DbImportAction.asConsumerColumn(i3, columns.get(i3)));
        }
        res2.setColumns(modelColumns);
        return res2;
    }

    @NotNull
    private static DataConsumer.Column asConsumerColumn(int i2, ColumnDescriptor column2) {
        JdbcColumnDescriptor jDesc = (JdbcColumnDescriptor)ObjectUtils.tryCast((Object)column2, JdbcColumnDescriptor.class);
        SizeProvider sp = (SizeProvider)ObjectUtils.tryCast((Object)column2, SizeProvider.class);
        JdbcGridColumn gc = (JdbcGridColumn)ObjectUtils.tryCast((Object)column2, JdbcGridColumn.class);
        return new DataConsumer.Column(i2, column2.getName(), column2.getType(), column2.getTypeName(), jDesc == null ? null : jDesc.getJavaClassName(), sp == null ? -1 : sp.getSize(), sp == null ? -1 : sp.getScale(), gc == null ? null : gc.getCatalog(), gc == null ? null : gc.getSchema(), gc == null ? null : gc.getTable(), column2.getAttributes());
    }

    private static void showDialog(@NotNull Project project, final @NotNull Iterable<DbContextDataSourceElements<?>> targetSelection, final @NotNull Iterable<VirtualFile> sourceFiles, final @NotNull Iterable<DbContextDataSourceElements<BasicTable>> sourceSelection, @NotNull DbImportDialog.InvocationType invocation) {
        if (project == null) {
            DbImportAction.$$$reportNull$$$0(15);
        }
        if (targetSelection == null) {
            DbImportAction.$$$reportNull$$$0(16);
        }
        if (sourceFiles == null) {
            DbImportAction.$$$reportNull$$$0(17);
        }
        if (sourceSelection == null) {
            DbImportAction.$$$reportNull$$$0(18);
        }
        if (invocation == null) {
            DbImportAction.$$$reportNull$$$0(19);
        }
        DbImportDialog.showDialog(new DbImportDialogPanel.ImportDialogBootstrapper(project, invocation){

            @Override
            @NotNull
            public ElementIdentity<?> prepareTargetIdentity(@NotNull DbEditorModelController controller, @NotNull ElementOwner targetOwner) {
                if (controller == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (targetOwner == null) {
                    2.$$$reportNull$$$0(1);
                }
                ElementIdentity<?> rootId2 = super.prepareTargetIdentity(controller, targetOwner);
                controller.createStructureNodeModel(rootId2);
                for (VirtualFile file : sourceFiles) {
                    ElementIdentity<?> fileSourceId = DbImportAction.createFileSource(controller, targetOwner, rootId2, file);
                    DbImportAction.createMappings(controller, targetOwner, fileSourceId, targetSelection);
                }
                for (DbContextDataSourceElements dsElements : sourceSelection) {
                    for (BasicTable table : dsElements.asIterable()) {
                        ElementIdentity<WrapperElement<DbTableSourceData>> dbId = DbImportAction.createDbTableSource(controller, targetOwner, rootId2, dsElements.getDataSource(), table, false);
                        DbImportAction.createMappings(controller, targetOwner, dbId, targetSelection);
                    }
                }
                ElementIdentity<?> elementIdentity = rootId2;
                if (elementIdentity == null) {
                    2.$$$reportNull$$$0(2);
                }
                return elementIdentity;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "controller";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "targetOwner";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dbimport/editor/DbImportAction$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dbimport/editor/DbImportAction$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "prepareTargetIdentity";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "prepareTargetIdentity";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        });
    }

    private static void createMappings(@NotNull DbEditorModelController controller, @NotNull ElementOwner owner, @NotNull ElementIdentity<?> sourceId, @NotNull Iterable<DbContextDataSourceElements<?>> selection) {
        if (controller == null) {
            DbImportAction.$$$reportNull$$$0(20);
        }
        if (owner == null) {
            DbImportAction.$$$reportNull$$$0(21);
        }
        if (sourceId == null) {
            DbImportAction.$$$reportNull$$$0(22);
        }
        if (selection == null) {
            DbImportAction.$$$reportNull$$$0(23);
        }
        boolean created = false;
        for (DbContextDataSourceElements<?> dsElements : selection) {
            for (BasicElement element : dsElements.asNodes().asIterable().filter(BasicElement.class)) {
                DbImportAction.createMapping(controller, owner, sourceId, dsElements.getDataSource(), element);
                created = true;
            }
        }
        if (!created) {
            DbImportAction.createMapping(controller, owner, sourceId, null, null);
        }
    }

    @NotNull
    private static ElementIdentity<?> createFileSource(@NotNull DbEditorModelController controller, @NotNull ElementOwner owner, @NotNull ElementIdentity<?> rootId2, @NotNull VirtualFile file) {
        ElementIdentity<WrapperElement<ScriptedSourceData>> scriptedId;
        if (controller == null) {
            DbImportAction.$$$reportNull$$$0(24);
        }
        if (owner == null) {
            DbImportAction.$$$reportNull$$$0(25);
        }
        if (rootId2 == null) {
            DbImportAction.$$$reportNull$$$0(26);
        }
        if (file == null) {
            DbImportAction.$$$reportNull$$$0(27);
        }
        if ((scriptedId = DbImportAction.createScriptedSource(controller, owner, rootId2, file, ScriptedGridDataHookUp.ScriptedLoaderFileConfig.Companion.get(file).getFirstRowIsHeader())) != null) {
            ElementIdentity<WrapperElement<ScriptedSourceData>> elementIdentity = scriptedId;
            if (elementIdentity == null) {
                DbImportAction.$$$reportNull$$$0(28);
            }
            return elementIdentity;
        }
        return DbImportAction.createCsvSource(controller, owner, rootId2, file);
    }

    @NotNull
    private static ElementIdentity<WrapperElement<CsvSourceData>> createCsvSource(@NotNull DbEditorModelController controller, @NotNull ElementOwner owner, @NotNull ElementIdentity<?> rootId2, @NotNull VirtualFile file) {
        if (controller == null) {
            DbImportAction.$$$reportNull$$$0(29);
        }
        if (owner == null) {
            DbImportAction.$$$reportNull$$$0(30);
        }
        if (rootId2 == null) {
            DbImportAction.$$$reportNull$$$0(31);
        }
        if (file == null) {
            DbImportAction.$$$reportNull$$$0(32);
        }
        BasicMetaObject<WrapperElement<CsvSourceData>> csvMeta = CsvSourceData.META.get(rootId2.getMetaObject());
        ElementIdentity<WrapperElement<CsvSourceData>> csvId = owner.create(rootId2, csvMeta);
        controller.createStructureNodeModel(csvId);
        CsvSourceData csv = WrapperElementFactory.getDelegate(owner.findOrCreate(csvId));
        if (csv != null) {
            csv.setPath(file.getPath());
        }
        ElementIdentity<WrapperElement<CsvSourceData>> elementIdentity = csvId;
        if (elementIdentity == null) {
            DbImportAction.$$$reportNull$$$0(33);
        }
        return elementIdentity;
    }

    @Nullable
    private static ElementIdentity<WrapperElement<ScriptedSourceData>> createScriptedSource(@NotNull DbEditorModelController controller, @NotNull ElementOwner owner, @NotNull ElementIdentity<?> rootId2, @NotNull VirtualFile file, @Nullable Boolean firstRowIsHeader) {
        DataLoader loader;
        if (controller == null) {
            DbImportAction.$$$reportNull$$$0(34);
        }
        if (owner == null) {
            DbImportAction.$$$reportNull$$$0(35);
        }
        if (rootId2 == null) {
            DbImportAction.$$$reportNull$$$0(36);
        }
        if (file == null) {
            DbImportAction.$$$reportNull$$$0(37);
        }
        if ((loader = DataLoaderManager.getInstance().findDataLoader(file, false)) == null) {
            return null;
        }
        return DbImportAction.createScriptedSource(controller, owner, rootId2, file, loader, firstRowIsHeader);
    }

    @NotNull
    private static ElementIdentity<WrapperElement<ScriptedSourceData>> createScriptedSource(@NotNull DbEditorModelController controller, @NotNull ElementOwner owner, @NotNull ElementIdentity<?> rootId2, @NotNull VirtualFile file, @NotNull DataLoader loader, @Nullable Boolean firstRowIsHeader) {
        if (controller == null) {
            DbImportAction.$$$reportNull$$$0(38);
        }
        if (owner == null) {
            DbImportAction.$$$reportNull$$$0(39);
        }
        if (rootId2 == null) {
            DbImportAction.$$$reportNull$$$0(40);
        }
        if (file == null) {
            DbImportAction.$$$reportNull$$$0(41);
        }
        if (loader == null) {
            DbImportAction.$$$reportNull$$$0(42);
        }
        BasicMetaObject<WrapperElement<ScriptedSourceData>> scriptedMeta = ScriptedSourceData.META.get(rootId2.getMetaObject());
        ElementIdentity<WrapperElement<ScriptedSourceData>> scriptedId = owner.create(rootId2, scriptedMeta);
        controller.createStructureNodeModel(scriptedId);
        ScriptedSourceData scripted = WrapperElementFactory.getDelegate(owner.findOrCreate(scriptedId));
        if (scripted != null) {
            scripted.setPath(file.getPath());
            scripted.setLoader(loader.getId());
            scripted.setFirstRowIsHeader(firstRowIsHeader);
        }
        ElementIdentity<WrapperElement<ScriptedSourceData>> elementIdentity = scriptedId;
        if (elementIdentity == null) {
            DbImportAction.$$$reportNull$$$0(43);
        }
        return elementIdentity;
    }

    @Nullable
    private static ElementIdentity<WrapperElement<DbTableSourceData>> createDbTableSource(@NotNull DbEditorModelController controller, @NotNull ElementOwner owner, @NotNull ElementIdentity<?> rootId2, @NotNull DbElement element, boolean useCachedData) {
        BasicLikeTable e;
        if (controller == null) {
            DbImportAction.$$$reportNull$$$0(44);
        }
        if (owner == null) {
            DbImportAction.$$$reportNull$$$0(45);
        }
        if (rootId2 == null) {
            DbImportAction.$$$reportNull$$$0(46);
        }
        if (element == null) {
            DbImportAction.$$$reportNull$$$0(47);
        }
        if ((e = (BasicLikeTable)ObjectUtils.tryCast((Object)element.getDelegate(), BasicLikeTable.class)) != null) {
            return DbImportAction.createDbTableSource(controller, owner, rootId2, element.getDataSource().getDelegateDataSource(), e, useCachedData);
        }
        return null;
    }

    @NotNull
    private static ElementIdentity<WrapperElement<DbTableSourceData>> createDbTableSource(@NotNull DbEditorModelController controller, @NotNull ElementOwner owner, @NotNull ElementIdentity<?> rootId2, @NotNull RawDataSource dataSource, @NotNull BasicLikeTable element, boolean useCachedData) {
        if (controller == null) {
            DbImportAction.$$$reportNull$$$0(48);
        }
        if (owner == null) {
            DbImportAction.$$$reportNull$$$0(49);
        }
        if (rootId2 == null) {
            DbImportAction.$$$reportNull$$$0(50);
        }
        if (dataSource == null) {
            DbImportAction.$$$reportNull$$$0(51);
        }
        if (element == null) {
            DbImportAction.$$$reportNull$$$0(52);
        }
        DataSourceData.Companion.registerDataSourceRoot(owner.getOriginal(), rootId2, dataSource);
        BasicMetaObject<WrapperElement<DbTableSourceData>> dbMeta = DbTableSourceData.META.get(rootId2.getMetaObject());
        ElementIdentity<WrapperElement<DbTableSourceData>> dbId = owner.create(rootId2, dbMeta);
        controller.createStructureNodeModel(dbId);
        WrapperElement<DbTableSourceData> dbElement = owner.findOrCreate(dbId);
        DbTableSourceData db = WrapperElementFactory.getDelegate(dbElement);
        if (db != null) {
            db.setDataSourceRef(BasicNameReference.create(dataSource.getUniqueId()));
            db.setTableRef(BasicMetaUtils.createPortableReference(dbElement, element, DbTableSourceData.TABLE_REF, owner.getResolveAssistant()));
            db.setUseCached(useCachedData);
        }
        ElementIdentity<WrapperElement<DbTableSourceData>> elementIdentity = dbId;
        if (elementIdentity == null) {
            DbImportAction.$$$reportNull$$$0(53);
        }
        return elementIdentity;
    }

    @NotNull
    private static ElementIdentity<WrapperElement<DbQuerySourceData>> createDbQuerySource(@NotNull ElementOwner owner, @NotNull ElementIdentity<?> rootId2, @NotNull RawDataSource dataSource, @Nullable BasicNamespace namespace, @Nullable String queryName, @NotNull String query, boolean useCachedData) {
        if (owner == null) {
            DbImportAction.$$$reportNull$$$0(54);
        }
        if (rootId2 == null) {
            DbImportAction.$$$reportNull$$$0(55);
        }
        if (dataSource == null) {
            DbImportAction.$$$reportNull$$$0(56);
        }
        if (query == null) {
            DbImportAction.$$$reportNull$$$0(57);
        }
        DataSourceData.Companion.registerDataSourceRoot(owner.getOriginal(), rootId2, dataSource);
        BasicMetaObject<WrapperElement<DbQuerySourceData>> dbMeta = DbQuerySourceData.META.get(rootId2.getMetaObject());
        ElementIdentity<WrapperElement<DbQuerySourceData>> dbId = owner.create(rootId2, dbMeta);
        WrapperElement<DbQuerySourceData> dbElement = owner.findOrCreate(dbId);
        DbQuerySourceData db = WrapperElementFactory.getDelegate(dbElement);
        if (db != null) {
            db.setQueryName(queryName);
            db.setDataSourceRef(BasicNameReference.create(dataSource.getUniqueId()));
            db.setNamespaceRef(namespace == null ? null : BasicMetaUtils.createPortableReference(dbElement, namespace, DbQuerySourceData.TARGET_REF, owner.getResolveAssistant()));
            db.setQuery(query);
            db.setUseCached(useCachedData);
        }
        ElementIdentity<WrapperElement<DbQuerySourceData>> elementIdentity = dbId;
        if (elementIdentity == null) {
            DbImportAction.$$$reportNull$$$0(58);
        }
        return elementIdentity;
    }

    private static void createMapping(@NotNull DbEditorModelController controller, @NotNull ElementOwner owner, @NotNull ElementIdentity<?> sourceId, @Nullable DbElement element) {
        if (controller == null) {
            DbImportAction.$$$reportNull$$$0(59);
        }
        if (owner == null) {
            DbImportAction.$$$reportNull$$$0(60);
        }
        if (sourceId == null) {
            DbImportAction.$$$reportNull$$$0(61);
        }
        BasicElement e = element == null ? null : (BasicElement)ObjectUtils.tryCast((Object)element.getDelegate(), BasicElement.class);
        DbImportAction.createMapping(controller, owner, sourceId, element != null ? element.getDataSource().getDelegateDataSource() : null, e);
    }

    private static void createMapping(@NotNull DbEditorModelController controller, @NotNull ElementOwner owner, @NotNull ElementIdentity<?> sourceId, @Nullable RawDataSource dataSource, @Nullable BasicElement element) {
        if (controller == null) {
            DbImportAction.$$$reportNull$$$0(62);
        }
        if (owner == null) {
            DbImportAction.$$$reportNull$$$0(63);
        }
        if (sourceId == null) {
            DbImportAction.$$$reportNull$$$0(64);
        }
        if (dataSource != null) {
            DataSourceData.Companion.registerDataSourceRoot(owner.getOriginal(), sourceId, dataSource);
        }
        BasicMetaObject<WrapperElement<MappingData>> mappingMeta = MappingData.META.get(sourceId.getMetaObject());
        ElementIdentity<BasicElement> id = dataSource == null || element == null ? null : owner.getOriginal().identify(element);
        ElementIdentity<BasicTable> tableId = id == null ? null : DbImportAction.createMappingTarget(controller, owner, id);
        ElementIdentity<WrapperElement<MappingData>> mappingId = owner.create(sourceId, mappingMeta);
        controller.createStructureNodeModel(mappingId);
        WrapperElement<MappingData> mappingElement = owner.findOrCreate(mappingId);
        MappingData mapping = WrapperElementFactory.getDelegate(mappingElement);
        if (mapping == null) {
            return;
        }
        BasicTable tgt = tableId == null ? null : owner.findOrCreate(tableId);
        mapping.setDataSourceRef(dataSource == null ? null : BasicNameReference.create(dataSource.getUniqueId()));
        mapping.setSchemaRef(tgt == null ? null : DbReferenceModelApplier.asEditorRef(owner, mappingElement, tgt.getSchema(), MappingData.SCHEMA_REF));
        mapping.setTableRef(tgt == null ? null : DbReferenceModelApplier.asEditorRef(owner, mappingElement, tgt, MappingData.TABLE_REF));
        boolean existing2 = tableId != null && tableId.equals(id);
        mapping.setDefinesTable(!existing2);
        mapping.setAutoName(!existing2);
    }

    @Nullable
    private static ElementIdentity<BasicTable> createMappingTarget(@NotNull DbEditorModelController controller, @NotNull ElementOwner owner, @NotNull ElementIdentity<?> id) {
        DbAutoDefinitionState autoState;
        ElementIdentity<BasicTable> tableId;
        if (controller == null) {
            DbImportAction.$$$reportNull$$$0(65);
        }
        if (owner == null) {
            DbImportAction.$$$reportNull$$$0(66);
        }
        if (id == null) {
            DbImportAction.$$$reportNull$$$0(67);
        }
        if ((tableId = ElementIdentity.tryCast(id, BasicTable.class)) == null) {
            BasicMetaObject tableMeta = BasicMetaUtils.findChild(id.getMetaObject(), ObjectKind.TABLE);
            if (tableMeta == null) {
                return null;
            }
            tableId = owner.create(id, tableMeta);
        }
        controller.createStructureNodeModel(tableId);
        if (tableId != id && (autoState = DbAutoDefinitionState.resolve(controller, tableId)) != null) {
            autoState.setInManualMode(false);
        }
        return tableId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 29, 30, 31, 32, 34, 35, 36, 37, 38, 39, 40, 41, 42, 44, 45, 46, 47, 48, 49, 50, 51, 52, 54, 55, 56, 57, 59, 60, 61, 62, 63, 64, 65, 66, 67 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/editor/DbImportAction";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 7: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invocation";
                break;
            }
            case 9: 
            case 47: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetSelection";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFiles";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSelection";
                break;
            }
            case 20: 
            case 24: 
            case 29: 
            case 34: 
            case 38: 
            case 44: 
            case 48: 
            case 59: 
            case 62: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 21: 
            case 25: 
            case 30: 
            case 35: 
            case 39: 
            case 45: 
            case 49: 
            case 54: 
            case 60: 
            case 63: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 22: 
            case 61: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceId";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 26: 
            case 31: 
            case 36: 
            case 40: 
            case 46: 
            case 50: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootId";
                break;
            }
            case 27: 
            case 32: 
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 51: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/editor/DbImportAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelection";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createTarget";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileSource";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createCsvSource";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createScriptedSource";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "createDbTableSource";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "createDbQuerySource";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSelection";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTarget";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createMappings";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createFileSource";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createCsvSource";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createScriptedSource";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createDbTableSource";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "createDbQuerySource";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "createMapping";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "createMappingTarget";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 29, 30, 31, 32, 34, 35, 36, 37, 38, 39, 40, 41, 42, 44, 45, 46, 47, 48, 49, 50, 51, 52, 54, 55, 56, 57, 59, 60, 61, 62, 63, 64, 65, 66, 67 -> new IllegalArgumentException(string);
        };
    }
}

