/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra.types;

import com.intellij.database.dialects.cassandra.types.CassBaseGenericType;
import com.intellij.database.types.DasMapType;
import com.intellij.database.types.DasSimpleTypeClass;
import com.intellij.database.types.DasType;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0001\u0010B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\r\u001a\u00020\u00042\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000fH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dialects/cassandra/types/CassMapType;", "Lcom/intellij/database/dialects/cassandra/types/CassBaseGenericType;", "Lcom/intellij/database/types/DasMapType;", "keyType", "Lcom/intellij/database/types/DasType;", "valueType", "<init>", "(Lcom/intellij/database/types/DasType;Lcom/intellij/database/types/DasType;)V", "getTypeClass", "Lcom/intellij/database/types/DasSimpleTypeClass;", "getKeyType", "()Lcom/intellij/database/types/DasType;", "getValueType", "transform", "transformer", "Ljava/util/function/Function;", "Companion", "intellij.database.dialects.cassandra"})
public final class CassMapType
extends CassBaseGenericType
implements DasMapType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final DasSimpleTypeClass TYPE_CLASS = new DasSimpleTypeClass("map");

    public CassMapType(@NotNull DasType keyType, @NotNull DasType valueType) {
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
        Object[] objectArray = new DasType[]{keyType, valueType};
        super(CollectionsKt.listOf((Object[])objectArray));
    }

    @Override
    @NotNull
    public DasSimpleTypeClass getTypeClass() {
        return TYPE_CLASS;
    }

    @Override
    @NotNull
    public DasType getKeyType() {
        return this.getArguments().get(0);
    }

    @Override
    @NotNull
    public DasType getValueType() {
        return this.getArguments().get(1);
    }

    @Override
    @NotNull
    public DasType transform(@NotNull Function<DasType, DasType> transformer) {
        Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
        DasType dasType = transformer.apply(this.getKeyType());
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"apply(...)");
        DasType dasType2 = transformer.apply(this.getValueType());
        Intrinsics.checkNotNullExpressionValue((Object)dasType2, (String)"apply(...)");
        return new CassMapType(dasType, dasType2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dialects/cassandra/types/CassMapType$Companion;", "", "<init>", "()V", "TYPE_CLASS", "Lcom/intellij/database/types/DasSimpleTypeClass;", "getTYPE_CLASS", "()Lcom/intellij/database/types/DasSimpleTypeClass;", "intellij.database.dialects.cassandra"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DasSimpleTypeClass getTYPE_CLASS() {
            return TYPE_CLASS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

