/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.db2;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.base.BaseDmlHelper;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J:\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0007H\u0016J\u001a\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0012\u0010\u0018\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u001a\u0010\u001b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/dialects/db2/Db2BaseDmlHelper;", "Lcom/intellij/database/dialects/base/BaseDmlHelper;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "needAliasInDeleteStatement", "", "getNeedAliasInDeleteStatement", "()Z", "appendLimit", "Lcom/intellij/database/util/DdlBuilder;", "table", "Lcom/intellij/database/model/DasObject;", "builder", "dialect", "Lcom/intellij/database/dialects/DatabaseDialectEx;", "limit", "", "offset", "atBeginning", "appendRowId", "alias", "", "isEditableTable", "kind", "Lcom/intellij/database/model/ObjectKind;", "hasRowId", "Lcom/intellij/database/model/DasTable;", "version", "Lcom/intellij/database/util/Version;", "intellij.database.dialects.db2"})
public final class Db2BaseDmlHelper
extends BaseDmlHelper {
    public Db2BaseDmlHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    @Override
    public boolean getNeedAliasInDeleteStatement() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder appendLimit(@Nullable DasObject table, @NotNull DdlBuilder builder, @NotNull DatabaseDialectEx dialect, int limit, int offset, boolean atBeginning) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        return GridUtilCore.isPageSizeUnlimited((int)limit) ? builder : this.fetchFirst(builder, limit);
    }

    @Override
    @NotNull
    public DdlBuilder appendRowId(@NotNull DdlBuilder builder, @Nullable String alias) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.symbol(",").space().identifier("RID");
        if (alias != null) {
            builder.symbol("(").plain(alias).symbol(")");
        }
        String string = alias;
        builder.space().keyword("as").space().identifier("RID" + (String)(string != null ? "(" + string + ")" : ""));
        return builder;
    }

    @Override
    public boolean isEditableTable(@Nullable ObjectKind kind) {
        return Intrinsics.areEqual((Object)kind, (Object)ObjectKind.VIEW) ? true : super.isEditableTable(kind);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasRowId(@NotNull DasTable table, @Nullable Version version) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        if (version == null) return true;
        int[] nArray = new int[]{9, 4};
        if (!version.isOrGreater(nArray)) return false;
        return true;
    }
}

