/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.diagnostic.DiagnosticMonitor;
import com.intellij.database.introspection.IntrospectionTask;
import com.intellij.database.model.serialization.ModelSerializationFun;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/database/introspection/IntrospectionTaskInnerHelper;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "recordCreation", "", "task", "Lcom/intellij/database/introspection/IntrospectionTask;", "recordCreation$intellij_database_core_impl", "intellij.database.core.impl"})
public final class IntrospectionTaskInnerHelper {
    @NotNull
    public static final IntrospectionTaskInnerHelper INSTANCE = new IntrospectionTaskInnerHelper();
    @NotNull
    private static final Logger log;

    private IntrospectionTaskInnerHelper() {
    }

    public final void recordCreation$intellij_database_core_impl(@NotNull IntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        String dsId = task.getDataSourceId();
        if (ModelSerializationFun.startsWith(dsId, '?')) {
            log.error("An introspection task " + task.getClass().getSimpleName() + " is created without data source id. The task:\n" + task);
        } else if (log.isDebugEnabled()) {
            log.debug("An introspection task is created:\n" + task);
        }
        DiagnosticMonitor.INSTANCE.record(dsId, true, (Function0<? extends CharSequence>)((Function0)() -> IntrospectionTaskInnerHelper.recordCreation$lambda$0(task)));
    }

    private static final CharSequence recordCreation$lambda$0(IntrospectionTask $task) {
        return $task.toString();
    }

    static {
        Logger logger2 = Logger.getInstance(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        log = logger2;
    }
}

