/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.psi.stubs.StubElement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSynonymDefinition;
import com.intellij.sql.psi.stubs.SqlAlterStatementStubElementType;
import com.intellij.sql.psi.stubs.SqlNamedElementStub;
import com.intellij.sql.psi.stubs.SqlSynonymDefinitionElementType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlSynonymStub
extends SqlNamedElementStub<SqlSynonymDefinition> {
    private final StringRef myTargetName;
    private SqlReferenceExpression myTargetReference;
    private final boolean myPublic;

    protected SqlSynonymStub(StubElement parent, @NotNull SqlSynonymDefinitionElementType type, StringRef name2, StringRef targetName, boolean aPublic) {
        if (type == null) {
            SqlSynonymStub.$$$reportNull$$$0(0);
        }
        super(parent, type, name2);
        this.myTargetName = targetName;
        this.myPublic = aPublic;
    }

    public String getTargetName() {
        return this.myTargetName == null ? null : this.myTargetName.getString();
    }

    public SqlReferenceExpression getTargetReference() {
        if (this.myTargetReference == null) {
            SqlNamedElementStub<?> stub = this.getAlterStatementStub();
            if (this.myTargetName == null && stub != null) {
                this.myTargetReference = stub.getNameReference(this.getReferenceTypeInner(stub));
            } else {
                String targetName = this.getTargetName();
                this.myTargetReference = this.createReference(this.getReferenceTypeInner(stub), targetName);
            }
        }
        return this.myTargetReference;
    }

    public SqlNameElement getNameReference() {
        return super.getNameReference(this.getReferenceType());
    }

    public SqlReferenceElementType getReferenceType() {
        return this.getReferenceTypeInner(this.getAlterStatementStub());
    }

    @NotNull
    protected SqlReferenceElementType getReferenceTypeInner(@Nullable SqlNamedElementStub<?> stub) {
        String statementTarget;
        SqlAlterStatementStubElementType type = stub == null ? null : (SqlAlterStatementStubElementType)stub.getStubType();
        String string = statementTarget = stub == null ? null : stub.getName();
        if (type == null) {
            SqlReferenceElementType sqlReferenceElementType = SqlCompositeElementTypes.SQL_REFERENCE;
            if (sqlReferenceElementType == null) {
                SqlSynonymStub.$$$reportNull$$$0(1);
            }
            return sqlReferenceElementType;
        }
        if (this.myTargetName == null || statementTarget == null) {
            SqlReferenceElementType sqlReferenceElementType = (SqlReferenceElementType)ObjectUtils.notNull((Object)type.getTargetReferenceType(), (Object)SqlCompositeElementTypes.SQL_REFERENCE);
            if (sqlReferenceElementType == null) {
                SqlSynonymStub.$$$reportNull$$$0(2);
            }
            return sqlReferenceElementType;
        }
        if (type.getTargetReferenceType() == SqlCompositeElementTypes.SQL_TABLE_REFERENCE) {
            SqlReferenceElementType sqlReferenceElementType = SqlCompositeElementTypes.SQL_COLUMN_SHORT_REFERENCE;
            if (sqlReferenceElementType == null) {
                SqlSynonymStub.$$$reportNull$$$0(3);
            }
            return sqlReferenceElementType;
        }
        SqlReferenceElementType sqlReferenceElementType = SqlCompositeElementTypes.SQL_REFERENCE;
        if (sqlReferenceElementType == null) {
            SqlSynonymStub.$$$reportNull$$$0(4);
        }
        return sqlReferenceElementType;
    }

    @Nullable
    public SqlNamedElementStub<?> getAlterStatementStub() {
        for (StubElement stub = this.getParentStub(); stub != null; stub = stub.getParentStub()) {
            if (!(stub instanceof SqlNamedElementStub) || !(stub.getStubType() instanceof SqlAlterStatementStubElementType)) continue;
            return (SqlNamedElementStub)stub;
        }
        return null;
    }

    public boolean isPublic() {
        return this.myPublic;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/stubs/SqlSynonymStub";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/stubs/SqlSynonymStub";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceTypeInner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

