/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.math.MathUtil;
import org.locationtech.jts.util.IntArrayList;

public class VertexSequencePackedRtree {
    private static final int NODE_CAPACITY = 16;
    private Coordinate[] items;
    private int[] levelOffset;
    private int nodeCapacity = 16;
    private Envelope[] bounds;
    private boolean[] isRemoved;

    public VertexSequencePackedRtree(Coordinate[] pts) {
        this.items = pts;
        this.isRemoved = new boolean[pts.length];
        this.build();
    }

    public Envelope[] getBounds() {
        return (Envelope[])this.bounds.clone();
    }

    private void build() {
        this.levelOffset = this.computeLevelOffsets();
        this.bounds = this.createBounds();
    }

    private int[] computeLevelOffsets() {
        IntArrayList offsets = new IntArrayList();
        offsets.add(0);
        int levelSize = this.items.length;
        int currOffset = 0;
        do {
            levelSize = this.levelNodeCount(levelSize);
            offsets.add(currOffset += levelSize);
        } while (levelSize > 1);
        return offsets.toArray();
    }

    private int levelNodeCount(int numNodes) {
        return MathUtil.ceil(numNodes, this.nodeCapacity);
    }

    private Envelope[] createBounds() {
        int boundsSize = this.levelOffset[this.levelOffset.length - 1] + 1;
        Envelope[] bounds = new Envelope[boundsSize];
        this.fillItemBounds(bounds);
        for (int lvl = 1; lvl < this.levelOffset.length; ++lvl) {
            this.fillLevelBounds(lvl, bounds);
        }
        return bounds;
    }

    private void fillLevelBounds(int lvl, Envelope[] bounds) {
        int nodeEnd;
        int levelStart = this.levelOffset[lvl - 1];
        int levelEnd = this.levelOffset[lvl];
        int nodeStart = levelStart;
        int levelBoundIndex = this.levelOffset[lvl];
        do {
            nodeEnd = MathUtil.clampMax(nodeStart + this.nodeCapacity, levelEnd);
            bounds[levelBoundIndex++] = VertexSequencePackedRtree.computeNodeEnvelope(bounds, nodeStart, nodeEnd);
        } while ((nodeStart = nodeEnd) < levelEnd);
    }

    private void fillItemBounds(Envelope[] bounds) {
        int nodeEnd;
        int nodeStart = 0;
        int boundIndex = 0;
        do {
            nodeEnd = MathUtil.clampMax(nodeStart + this.nodeCapacity, this.items.length);
            bounds[boundIndex++] = VertexSequencePackedRtree.computeItemEnvelope(this.items, nodeStart, nodeEnd);
        } while ((nodeStart = nodeEnd) < this.items.length);
    }

    private static Envelope computeNodeEnvelope(Envelope[] bounds, int start2, int end) {
        Envelope env = new Envelope();
        for (int i2 = start2; i2 < end; ++i2) {
            env.expandToInclude(bounds[i2]);
        }
        return env;
    }

    private static Envelope computeItemEnvelope(Coordinate[] items, int start2, int end) {
        Envelope env = new Envelope();
        for (int i2 = start2; i2 < end; ++i2) {
            env.expandToInclude(items[i2]);
        }
        return env;
    }

    public int[] query(Envelope queryEnv) {
        IntArrayList resultList = new IntArrayList();
        int level = this.levelOffset.length - 1;
        this.queryNode(queryEnv, level, 0, resultList);
        int[] result2 = resultList.toArray();
        return result2;
    }

    private void queryNode(Envelope queryEnv, int level, int nodeIndex, IntArrayList resultList) {
        int boundsIndex = this.levelOffset[level] + nodeIndex;
        Envelope nodeEnv = this.bounds[boundsIndex];
        if (nodeEnv == null) {
            return;
        }
        if (!queryEnv.intersects(nodeEnv)) {
            return;
        }
        int childNodeIndex = nodeIndex * this.nodeCapacity;
        if (level == 0) {
            this.queryItemRange(queryEnv, childNodeIndex, resultList);
        } else {
            this.queryNodeRange(queryEnv, level - 1, childNodeIndex, resultList);
        }
    }

    private void queryNodeRange(Envelope queryEnv, int level, int nodeStartIndex, IntArrayList resultList) {
        int levelMax = this.levelSize(level);
        for (int i2 = 0; i2 < this.nodeCapacity; ++i2) {
            int index = nodeStartIndex + i2;
            if (index >= levelMax) {
                return;
            }
            this.queryNode(queryEnv, level, index, resultList);
        }
    }

    private int levelSize(int level) {
        return this.levelOffset[level + 1] - this.levelOffset[level];
    }

    private void queryItemRange(Envelope queryEnv, int itemIndex, IntArrayList resultList) {
        for (int i2 = 0; i2 < this.nodeCapacity; ++i2) {
            int index = itemIndex + i2;
            if (index >= this.items.length) {
                return;
            }
            Coordinate p2 = this.items[index];
            if (this.isRemoved[index] || !queryEnv.contains(p2)) continue;
            resultList.add(index);
        }
    }

    public void remove(int index) {
        this.isRemoved[index] = true;
        int nodeIndex = index / this.nodeCapacity;
        if (!this.isItemsNodeEmpty(nodeIndex)) {
            return;
        }
        this.bounds[nodeIndex] = null;
        if (this.levelOffset.length <= 2) {
            return;
        }
        int nodeLevelIndex = nodeIndex / this.nodeCapacity;
        if (!this.isNodeEmpty(1, nodeLevelIndex)) {
            return;
        }
        int nodeIndex1 = this.levelOffset[1] + nodeLevelIndex;
        this.bounds[nodeIndex1] = null;
    }

    private boolean isNodeEmpty(int level, int index) {
        int start2 = index * this.nodeCapacity;
        int end = MathUtil.clampMax(start2 + this.nodeCapacity, this.levelOffset[level]);
        for (int i2 = start2; i2 < end; ++i2) {
            if (this.bounds[i2] == null) continue;
            return false;
        }
        return true;
    }

    private boolean isItemsNodeEmpty(int nodeIndex) {
        int start2 = nodeIndex * this.nodeCapacity;
        int end = MathUtil.clampMax(start2 + this.nodeCapacity, this.items.length);
        for (int i2 = start2; i2 < end; ++i2) {
            if (this.isRemoved[i2]) continue;
            return false;
        }
        return true;
    }
}

