/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.util;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.locationtech.proj4j.CRSFactory;
import org.locationtech.proj4j.CoordinateReferenceSystem;
import org.locationtech.proj4j.InvalidValueException;
import org.locationtech.proj4j.UnknownAuthorityCodeException;
import org.locationtech.proj4j.UnsupportedParameterException;

public class CRSCache {
    private static CRSFactory crsFactory = new CRSFactory();
    private ConcurrentHashMap<String, CoordinateReferenceSystem> crsCache;
    private ConcurrentHashMap<String, String> epsgCache;

    public CRSCache() {
        this.crsCache = new ConcurrentHashMap();
        this.epsgCache = new ConcurrentHashMap();
    }

    public CRSCache(ConcurrentHashMap<String, CoordinateReferenceSystem> crsCache, ConcurrentHashMap<String, String> epsgCache) {
        this.crsCache = crsCache;
        this.epsgCache = epsgCache;
    }

    public CoordinateReferenceSystem createFromName(String name2) throws UnsupportedParameterException, InvalidValueException, UnknownAuthorityCodeException {
        CoordinateReferenceSystem res2 = this.crsCache.get(name2);
        if (res2 != null) {
            return res2;
        }
        return this.crsCache.computeIfAbsent(name2, k -> crsFactory.createFromName(name2));
    }

    public CoordinateReferenceSystem createFromParameters(String name2, String paramStr2) throws UnsupportedParameterException, InvalidValueException {
        String nonNullName = name2 == null ? "" : name2;
        String key2 = nonNullName + paramStr2;
        CoordinateReferenceSystem res2 = this.crsCache.get(key2);
        if (res2 != null) {
            return res2;
        }
        return this.crsCache.computeIfAbsent(key2, k -> crsFactory.createFromParameters(name2, paramStr2));
    }

    public CoordinateReferenceSystem createFromParameters(String name2, String[] params) throws UnsupportedParameterException, InvalidValueException {
        String nonNullName = name2 == null ? "" : name2;
        String key2 = nonNullName + String.join((CharSequence)" ", params);
        CoordinateReferenceSystem res2 = this.crsCache.get(key2);
        if (res2 != null) {
            return res2;
        }
        return this.crsCache.computeIfAbsent(key2, k -> crsFactory.createFromParameters(name2, params));
    }

    public String readEpsgFromParameters(String paramStr2) {
        String res2 = this.epsgCache.get(paramStr2);
        if (res2 != null) {
            return res2;
        }
        return this.epsgCache.computeIfAbsent(paramStr2, k -> {
            try {
                return crsFactory.readEpsgFromParameters(paramStr2);
            }
            catch (IOException e) {
                return null;
            }
        });
    }

    public String readEpsgFromParameters(String[] params) {
        String paramStr2 = String.join((CharSequence)" ", params);
        String res2 = this.epsgCache.get(paramStr2);
        if (res2 != null) {
            return res2;
        }
        return this.epsgCache.computeIfAbsent(paramStr2, k -> {
            try {
                return crsFactory.readEpsgFromParameters(params);
            }
            catch (IOException e) {
                return null;
            }
        });
    }
}

