/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.predicates;

import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchUtil;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.MatchResultImpl;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class RegExpPredicate
extends MatchPredicate {
    private Pattern pattern;
    private final String baseHandlerName;
    private boolean simpleString;
    private final boolean couldBeOptimized;
    @NotNull
    private final String regexp;
    private final boolean caseSensitive;
    private boolean multiline;
    private final boolean wholeWords;
    private final boolean target;
    private NodeTextGenerator myNodeTextGenerator;

    public RegExpPredicate(@NotNull String regexp, boolean caseSensitive, String _baseHandlerName, boolean _wholeWords, boolean _target) {
        if (regexp == null) {
            RegExpPredicate.$$$reportNull$$$0(0);
        }
        boolean bl = this.couldBeOptimized = !MatchUtil.containsRegExpMetaChar(regexp);
        if (!_wholeWords) {
            this.simpleString = this.couldBeOptimized;
        }
        this.regexp = regexp;
        this.caseSensitive = caseSensitive;
        this.wholeWords = _wholeWords;
        this.baseHandlerName = _baseHandlerName;
        if (!this.simpleString) {
            this.compilePattern();
        }
        this.target = _target;
    }

    private void compilePattern() {
        try {
            @NonNls Object realRegexp = this.regexp;
            if (this.wholeWords) {
                realRegexp = ".*?\\b(?:" + (String)realRegexp + ")\\b.*?";
            }
            this.pattern = Pattern.compile((String)realRegexp, (this.caseSensitive ? 0 : 2) | (this.multiline ? 32 : 0));
        }
        catch (PatternSyntaxException ex) {
            throw new MalformedPatternException(SSRBundle.message("error.incorrect.regexp.constraint", this.regexp, this.baseHandlerName));
        }
    }

    public boolean couldBeOptimized() {
        return this.couldBeOptimized;
    }

    @NotNull
    public String getRegExp() {
        String string = this.regexp;
        if (string == null) {
            RegExpPredicate.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean match(@NotNull PsiElement matchedNode, int start2, int end, @NotNull MatchContext context) {
        String alternativeText;
        String text;
        boolean result2;
        if (matchedNode == null) {
            RegExpPredicate.$$$reportNull$$$0(2);
        }
        if (context == null) {
            RegExpPredicate.$$$reportNull$$$0(3);
        }
        if (!(result2 = this.doMatch(text = this.myNodeTextGenerator != null ? this.myNodeTextGenerator.getText(matchedNode) : StructuralSearchUtil.getMeaningfulText(matchedNode), start2, end, context, matchedNode)) && (alternativeText = StructuralSearchUtil.getAlternativeText(matchedNode = StructuralSearchUtil.getParentIfIdentifier(matchedNode), text)) != null) {
            result2 = this.doMatch(alternativeText, start2, end, context, matchedNode);
        }
        return result2;
    }

    public boolean doMatch(@NotNull String text, @NotNull MatchContext context, @NotNull PsiElement matchedElement) {
        if (text == null) {
            RegExpPredicate.$$$reportNull$$$0(4);
        }
        if (context == null) {
            RegExpPredicate.$$$reportNull$$$0(5);
        }
        if (matchedElement == null) {
            RegExpPredicate.$$$reportNull$$$0(6);
        }
        return this.doMatch(text, 0, -1, context, matchedElement);
    }

    private boolean doMatch(@NotNull String text, int from, int end, @NotNull MatchContext context, @NotNull PsiElement matchedElement) {
        if (text == null) {
            RegExpPredicate.$$$reportNull$$$0(7);
        }
        if (context == null) {
            RegExpPredicate.$$$reportNull$$$0(8);
        }
        if (matchedElement == null) {
            RegExpPredicate.$$$reportNull$$$0(9);
        }
        if (from > 0 || end != -1) {
            text = text.substring(from, end == -1 || end >= text.length() ? text.length() : end);
        }
        if (this.simpleString) {
            return this.matchesSimpleString(text);
        }
        this.setMultilineIfApplicable(text);
        Matcher matcher = this.pattern.matcher(text);
        if (!matcher.matches()) {
            return false;
        }
        for (int i = 1; i <= matcher.groupCount(); ++i) {
            context.getResult().addChild(new MatchResultImpl(this.baseHandlerName + "_" + i, matcher.group(i), matchedElement, matcher.start(i), matcher.end(i), this.target));
        }
        return true;
    }

    public boolean match(@NotNull String text) {
        if (text == null) {
            RegExpPredicate.$$$reportNull$$$0(10);
        }
        if (this.simpleString) {
            return this.matchesSimpleString(text);
        }
        this.setMultilineIfApplicable(text);
        return this.pattern.matcher(text).matches();
    }

    private boolean matchesSimpleString(@NotNull String text) {
        if (text == null) {
            RegExpPredicate.$$$reportNull$$$0(11);
        }
        return this.caseSensitive ? text.equals(this.regexp) : text.equalsIgnoreCase(this.regexp);
    }

    private void setMultilineIfApplicable(@NotNull String text) {
        if (text == null) {
            RegExpPredicate.$$$reportNull$$$0(12);
        }
        if (!this.multiline && text.contains("\n")) {
            this.setMultiline(true);
        }
    }

    public void setNodeTextGenerator(NodeTextGenerator nodeTextGenerator) {
        this.myNodeTextGenerator = nodeTextGenerator;
    }

    public void setMultiline(boolean b) {
        this.multiline = b;
        this.compilePattern();
    }

    public boolean isWholeWords() {
        return this.wholeWords;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regexp";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/impl/matcher/predicates/RegExpPredicate";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchedNode";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchedElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/predicates/RegExpPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegExp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doMatch";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "matchesSimpleString";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setMultilineIfApplicable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static interface NodeTextGenerator {
        public String getText(PsiElement var1);
    }
}

