/*
 * Copyright (c) 2002, 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ST_THREAD_H
#define _ST_THREAD_H

#include <stdarg.h>
#include <glib.h>
#include "st-handler-api.h"

typedef void (*STThreadCallback)		(gpointer	data);
typedef void (*STThreadPrintCallback)		(const char	*str,
						 gpointer	data);
typedef void (*STThreadProgressCallback)	(double		progress,
						 gpointer	data);
typedef void (*STThreadCleanupCallback)		(gpointer	data);

typedef struct _STThreadPrivate STThreadPrivate;

typedef struct
{
  STHandler				*handler;

  STThreadCallback			thread;
  STThreadPrintCallback			print;
  STThreadProgressCallback		set_progress;
  STThreadCleanupCallback		cleanup;

  gpointer				data;
  GDestroyNotify			data_destroy;

  STThreadPrivate			*priv;
} STThread;

void		st_thread_init			(void);
STThread	*st_thread_new			(STHandler	*handler);
void		st_thread_run			(STThread	*thread);
STThread	*st_thread_get			(void);
void		st_thread_printf		(STThread	*thread,
						 gboolean	force,
						 const char	*format,
						 ...) G_GNUC_PRINTF(3, 4);
void		st_thread_set_progress		(STThread	*thread,
						 gboolean	force,
						 double		progress);
void		st_thread_forget		(STThread	*thread);
void		st_thread_abort			(STThread	*thread);
gboolean	st_thread_is_aborted		(STThread	*thread);
void		st_thread_cleanup		(STThread	*thread);
void		st_thread_validate_callback_return (STThread	*thread,
						    gboolean	status,
						    GError	*err);

#endif /* _ST_THREAD_H */
