/***************************************************************************
*   Copyright (C) 2004 by karye                                           *
*   karye@users.sourceforge.net                                           *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/

#ifndef GLOBAL_H
#define GLOBAL_H

#include <QRegularExpression>
#include <QStringList>
#include <QtCore/qglobal.h>      // for QGlobalStatic, Q_GLOBAL_STATIC_WITH_...
#include <qregularexpression.h>  // for QRegularExpression
#include <qstring.h>             // for QString
#include <qstringlist.h>         // for QStringList
#include <qstringliteral.h>

// 2024-02-24 what does vv this comment vv mean?
//TODO: dispatch in relevant module
inline static const QString kurooDir = QStringLiteral("/var/cache/kuroo/"); //->KConfig

class KurooGlobal {
public:
	// This regex parses the output of 'emerge --pretend' and is used in a few places
	static QRegularExpression* rxEmerge;
};

/**
* Parse out category, package name and version parts from package.
* @param sring to parse out cpv from
* @returns { "${C}" or "", "${PN}", "${V}", "${R}" } or {} if not ${P} ${V}
*/
const QStringList 		parsePackage( const QString& packageString );

/**
* Return duration in seconds formated as "d hh.mm.ss".
*/
const QString 			formatTime( long ); //->Queue

#endif
