/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pycharm.ds.jupyter.customCells.data.input;

import com.intellij.jupyter.core.editor.handlers.DataframeVariableNameSuggester;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.project.Project;
import com.jetbrains.python.PythonLanguage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/pycharm/ds/jupyter/customCells/data/input/PythonDataframeVariableNameSuggester;", "Lcom/intellij/jupyter/core/editor/handlers/DataframeVariableNameSuggester;", "<init>", "()V", "DELIMITERS_REGEX", "Lkotlin/text/Regex;", "suggestVariableName", "", "fileNameWithoutExtension", "namesValidator", "Lcom/intellij/lang/refactoring/NamesValidator;", "isValidIdentifier", "", "name", "project", "Lcom/intellij/openapi/project/Project;", "intellij.pycharm.ds.jupyter.customCells"})
public final class PythonDataframeVariableNameSuggester
implements DataframeVariableNameSuggester {
    @NotNull
    public static final PythonDataframeVariableNameSuggester INSTANCE = new PythonDataframeVariableNameSuggester();
    @NotNull
    private static final Regex DELIMITERS_REGEX = new Regex("[\\s-]");
    @NotNull
    private static final NamesValidator namesValidator;

    private PythonDataframeVariableNameSuggester() {
    }

    @NotNull
    public String suggestVariableName(@NotNull String fileNameWithoutExtension) {
        Intrinsics.checkNotNullParameter((Object)fileNameWithoutExtension, (String)"fileNameWithoutExtension");
        CharSequence charSequence = fileNameWithoutExtension;
        Regex regex = DELIMITERS_REGEX;
        String string = "_";
        return regex.replace(charSequence, string);
    }

    public boolean isValidIdentifier(@NotNull String name, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return namesValidator.isIdentifier(name, project);
    }

    static {
        NamesValidator namesValidator = LanguageNamesValidation.INSTANCE.forLanguage((Language)PythonLanguage.getInstance());
        Intrinsics.checkNotNullExpressionValue((Object)namesValidator, (String)"forLanguage(...)");
        PythonDataframeVariableNameSuggester.namesValidator = namesValidator;
    }
}

