/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.CipherType;
import io.ktor.network.tls.SecretExchangeType;
import io.ktor.network.tls.extensions.HashAlgorithm;
import io.ktor.network.tls.extensions.SignatureAlgorithm;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\u000b\n\u0002\b\u001e\b\u0086\b\u0018\u00002\u00020\u0001By\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0004\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\n\u0012\u0006\u0010\u000e\u001a\u00020\n\u0012\u0006\u0010\u000f\u001a\u00020\u0004\u0012\u0006\u0010\u0010\u001a\u00020\n\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u0012\u0006\u0010\u0014\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u001d\u0010\u001cJ\u0010\u0010\u001e\u001a\u00020\u0007H\u00c6\u0003\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0010\u0010 \u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b \u0010\u001cJ\u0010\u0010!\u001a\u00020\nH\u00c6\u0003\u00a2\u0006\u0004\b!\u0010\"J\u0010\u0010#\u001a\u00020\nH\u00c6\u0003\u00a2\u0006\u0004\b#\u0010\"J\u0010\u0010$\u001a\u00020\nH\u00c6\u0003\u00a2\u0006\u0004\b$\u0010\"J\u0010\u0010%\u001a\u00020\nH\u00c6\u0003\u00a2\u0006\u0004\b%\u0010\"J\u0010\u0010&\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b&\u0010\u001cJ\u0010\u0010'\u001a\u00020\nH\u00c6\u0003\u00a2\u0006\u0004\b'\u0010\"J\u0010\u0010(\u001a\u00020\u0011H\u00c6\u0003\u00a2\u0006\u0004\b(\u0010)J\u0010\u0010*\u001a\u00020\u0013H\u00c6\u0003\u00a2\u0006\u0004\b*\u0010+J\u0010\u0010,\u001a\u00020\u0015H\u00c6\u0003\u00a2\u0006\u0004\b,\u0010-J\u009c\u0001\u0010.\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\n2\b\b\u0002\u0010\r\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\n2\b\b\u0002\u0010\u000f\u001a\u00020\u00042\b\b\u0002\u0010\u0010\u001a\u00020\n2\b\b\u0002\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0014\u001a\u00020\u00132\b\b\u0002\u0010\u0016\u001a\u00020\u0015H\u00c6\u0001\u00a2\u0006\u0004\b.\u0010/J\u001a\u00102\u001a\u0002012\b\u00100\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b2\u00103J\u0010\u00104\u001a\u00020\nH\u00d6\u0001\u00a2\u0006\u0004\b4\u0010\"J\u0010\u00105\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b5\u0010\u001cR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u00106\u001a\u0004\b7\u0010\u001aR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u00108\u001a\u0004\b9\u0010\u001cR\u0017\u0010\u0006\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u00108\u001a\u0004\b:\u0010\u001cR\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010;\u001a\u0004\b<\u0010\u001fR\u0017\u0010\t\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\t\u00108\u001a\u0004\b=\u0010\u001cR\u0017\u0010\u000b\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010>\u001a\u0004\b?\u0010\"R\u0017\u0010\f\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010>\u001a\u0004\b@\u0010\"R\u0017\u0010\r\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010>\u001a\u0004\bA\u0010\"R\u0017\u0010\u000e\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010>\u001a\u0004\bB\u0010\"R\u0017\u0010\u000f\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u000f\u00108\u001a\u0004\bC\u0010\u001cR\u0017\u0010\u0010\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010>\u001a\u0004\bD\u0010\"R\u0017\u0010\u0012\u001a\u00020\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010E\u001a\u0004\bF\u0010)R\u0017\u0010\u0014\u001a\u00020\u00138\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010G\u001a\u0004\bH\u0010+R\u0017\u0010\u0016\u001a\u00020\u00158\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010I\u001a\u0004\bJ\u0010-R\u0017\u0010K\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\bK\u0010>\u001a\u0004\bL\u0010\"R\u0017\u0010M\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\bM\u0010>\u001a\u0004\bN\u0010\"\u00a8\u0006O"}, d2={"Lio/ktor/network/tls/CipherSuite;", "", "", "code", "", "name", "openSSLName", "Lio/ktor/network/tls/SecretExchangeType;", "exchangeType", "jdkCipherName", "", "keyStrength", "fixedIvLength", "ivLength", "cipherTagSizeInBytes", "macName", "macStrength", "Lio/ktor/network/tls/extensions/HashAlgorithm;", "hash", "Lio/ktor/network/tls/extensions/SignatureAlgorithm;", "signatureAlgorithm", "Lio/ktor/network/tls/CipherType;", "cipherType", "<init>", "(SLjava/lang/String;Ljava/lang/String;Lio/ktor/network/tls/SecretExchangeType;Ljava/lang/String;IIIILjava/lang/String;ILio/ktor/network/tls/extensions/HashAlgorithm;Lio/ktor/network/tls/extensions/SignatureAlgorithm;Lio/ktor/network/tls/CipherType;)V", "component1", "()S", "component2", "()Ljava/lang/String;", "component3", "component4", "()Lio/ktor/network/tls/SecretExchangeType;", "component5", "component6", "()I", "component7", "component8", "component9", "component10", "component11", "component12", "()Lio/ktor/network/tls/extensions/HashAlgorithm;", "component13", "()Lio/ktor/network/tls/extensions/SignatureAlgorithm;", "component14", "()Lio/ktor/network/tls/CipherType;", "copy", "(SLjava/lang/String;Ljava/lang/String;Lio/ktor/network/tls/SecretExchangeType;Ljava/lang/String;IIIILjava/lang/String;ILio/ktor/network/tls/extensions/HashAlgorithm;Lio/ktor/network/tls/extensions/SignatureAlgorithm;Lio/ktor/network/tls/CipherType;)Lio/ktor/network/tls/CipherSuite;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "S", "getCode", "Ljava/lang/String;", "getName", "getOpenSSLName", "Lio/ktor/network/tls/SecretExchangeType;", "getExchangeType", "getJdkCipherName", "I", "getKeyStrength", "getFixedIvLength", "getIvLength", "getCipherTagSizeInBytes", "getMacName", "getMacStrength", "Lio/ktor/network/tls/extensions/HashAlgorithm;", "getHash", "Lio/ktor/network/tls/extensions/SignatureAlgorithm;", "getSignatureAlgorithm", "Lio/ktor/network/tls/CipherType;", "getCipherType", "keyStrengthInBytes", "getKeyStrengthInBytes", "macStrengthInBytes", "getMacStrengthInBytes", "ktor-network-tls"})
public final class CipherSuite {
    private final short code;
    @NotNull
    private final String name;
    @NotNull
    private final String openSSLName;
    @NotNull
    private final SecretExchangeType exchangeType;
    @NotNull
    private final String jdkCipherName;
    private final int keyStrength;
    private final int fixedIvLength;
    private final int ivLength;
    private final int cipherTagSizeInBytes;
    @NotNull
    private final String macName;
    private final int macStrength;
    @NotNull
    private final HashAlgorithm hash;
    @NotNull
    private final SignatureAlgorithm signatureAlgorithm;
    @NotNull
    private final CipherType cipherType;
    private final int keyStrengthInBytes;
    private final int macStrengthInBytes;

    public CipherSuite(short code, @NotNull String name, @NotNull String openSSLName, @NotNull SecretExchangeType exchangeType, @NotNull String jdkCipherName, int keyStrength, int fixedIvLength, int ivLength, int cipherTagSizeInBytes, @NotNull String macName, int macStrength, @NotNull HashAlgorithm hash, @NotNull SignatureAlgorithm signatureAlgorithm, @NotNull CipherType cipherType) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)openSSLName, (String)"openSSLName");
        Intrinsics.checkNotNullParameter((Object)((Object)exchangeType), (String)"exchangeType");
        Intrinsics.checkNotNullParameter((Object)jdkCipherName, (String)"jdkCipherName");
        Intrinsics.checkNotNullParameter((Object)macName, (String)"macName");
        Intrinsics.checkNotNullParameter((Object)((Object)hash), (String)"hash");
        Intrinsics.checkNotNullParameter((Object)((Object)signatureAlgorithm), (String)"signatureAlgorithm");
        Intrinsics.checkNotNullParameter((Object)((Object)cipherType), (String)"cipherType");
        this.code = code;
        this.name = name;
        this.openSSLName = openSSLName;
        this.exchangeType = exchangeType;
        this.jdkCipherName = jdkCipherName;
        this.keyStrength = keyStrength;
        this.fixedIvLength = fixedIvLength;
        this.ivLength = ivLength;
        this.cipherTagSizeInBytes = cipherTagSizeInBytes;
        this.macName = macName;
        this.macStrength = macStrength;
        this.hash = hash;
        this.signatureAlgorithm = signatureAlgorithm;
        this.cipherType = cipherType;
        this.keyStrengthInBytes = this.keyStrength / 8;
        this.macStrengthInBytes = this.macStrength / 8;
    }

    public /* synthetic */ CipherSuite(short s, String string, String string2, SecretExchangeType secretExchangeType, String string3, int n, int n2, int n3, int n4, String string4, int n5, HashAlgorithm hashAlgorithm, SignatureAlgorithm signatureAlgorithm, CipherType cipherType, int n6, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n6 & 0x2000) != 0) {
            cipherType = CipherType.GCM;
        }
        this(s, string, string2, secretExchangeType, string3, n, n2, n3, n4, string4, n5, hashAlgorithm, signatureAlgorithm, cipherType);
    }

    public final short getCode() {
        return this.code;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getOpenSSLName() {
        return this.openSSLName;
    }

    @NotNull
    public final SecretExchangeType getExchangeType() {
        return this.exchangeType;
    }

    @NotNull
    public final String getJdkCipherName() {
        return this.jdkCipherName;
    }

    public final int getKeyStrength() {
        return this.keyStrength;
    }

    public final int getFixedIvLength() {
        return this.fixedIvLength;
    }

    public final int getIvLength() {
        return this.ivLength;
    }

    public final int getCipherTagSizeInBytes() {
        return this.cipherTagSizeInBytes;
    }

    @NotNull
    public final String getMacName() {
        return this.macName;
    }

    public final int getMacStrength() {
        return this.macStrength;
    }

    @NotNull
    public final HashAlgorithm getHash() {
        return this.hash;
    }

    @NotNull
    public final SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @NotNull
    public final CipherType getCipherType() {
        return this.cipherType;
    }

    public final int getKeyStrengthInBytes() {
        return this.keyStrengthInBytes;
    }

    public final int getMacStrengthInBytes() {
        return this.macStrengthInBytes;
    }

    public final short component1() {
        return this.code;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final String component3() {
        return this.openSSLName;
    }

    @NotNull
    public final SecretExchangeType component4() {
        return this.exchangeType;
    }

    @NotNull
    public final String component5() {
        return this.jdkCipherName;
    }

    public final int component6() {
        return this.keyStrength;
    }

    public final int component7() {
        return this.fixedIvLength;
    }

    public final int component8() {
        return this.ivLength;
    }

    public final int component9() {
        return this.cipherTagSizeInBytes;
    }

    @NotNull
    public final String component10() {
        return this.macName;
    }

    public final int component11() {
        return this.macStrength;
    }

    @NotNull
    public final HashAlgorithm component12() {
        return this.hash;
    }

    @NotNull
    public final SignatureAlgorithm component13() {
        return this.signatureAlgorithm;
    }

    @NotNull
    public final CipherType component14() {
        return this.cipherType;
    }

    @NotNull
    public final CipherSuite copy(short code, @NotNull String name, @NotNull String openSSLName, @NotNull SecretExchangeType exchangeType, @NotNull String jdkCipherName, int keyStrength, int fixedIvLength, int ivLength, int cipherTagSizeInBytes, @NotNull String macName, int macStrength, @NotNull HashAlgorithm hash, @NotNull SignatureAlgorithm signatureAlgorithm, @NotNull CipherType cipherType) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)openSSLName, (String)"openSSLName");
        Intrinsics.checkNotNullParameter((Object)((Object)exchangeType), (String)"exchangeType");
        Intrinsics.checkNotNullParameter((Object)jdkCipherName, (String)"jdkCipherName");
        Intrinsics.checkNotNullParameter((Object)macName, (String)"macName");
        Intrinsics.checkNotNullParameter((Object)((Object)hash), (String)"hash");
        Intrinsics.checkNotNullParameter((Object)((Object)signatureAlgorithm), (String)"signatureAlgorithm");
        Intrinsics.checkNotNullParameter((Object)((Object)cipherType), (String)"cipherType");
        return new CipherSuite(code, name, openSSLName, exchangeType, jdkCipherName, keyStrength, fixedIvLength, ivLength, cipherTagSizeInBytes, macName, macStrength, hash, signatureAlgorithm, cipherType);
    }

    public static /* synthetic */ CipherSuite copy$default(CipherSuite cipherSuite, short s, String string, String string2, SecretExchangeType secretExchangeType, String string3, int n, int n2, int n3, int n4, String string4, int n5, HashAlgorithm hashAlgorithm, SignatureAlgorithm signatureAlgorithm, CipherType cipherType, int n6, Object object) {
        if ((n6 & 1) != 0) {
            s = cipherSuite.code;
        }
        if ((n6 & 2) != 0) {
            string = cipherSuite.name;
        }
        if ((n6 & 4) != 0) {
            string2 = cipherSuite.openSSLName;
        }
        if ((n6 & 8) != 0) {
            secretExchangeType = cipherSuite.exchangeType;
        }
        if ((n6 & 0x10) != 0) {
            string3 = cipherSuite.jdkCipherName;
        }
        if ((n6 & 0x20) != 0) {
            n = cipherSuite.keyStrength;
        }
        if ((n6 & 0x40) != 0) {
            n2 = cipherSuite.fixedIvLength;
        }
        if ((n6 & 0x80) != 0) {
            n3 = cipherSuite.ivLength;
        }
        if ((n6 & 0x100) != 0) {
            n4 = cipherSuite.cipherTagSizeInBytes;
        }
        if ((n6 & 0x200) != 0) {
            string4 = cipherSuite.macName;
        }
        if ((n6 & 0x400) != 0) {
            n5 = cipherSuite.macStrength;
        }
        if ((n6 & 0x800) != 0) {
            hashAlgorithm = cipherSuite.hash;
        }
        if ((n6 & 0x1000) != 0) {
            signatureAlgorithm = cipherSuite.signatureAlgorithm;
        }
        if ((n6 & 0x2000) != 0) {
            cipherType = cipherSuite.cipherType;
        }
        return cipherSuite.copy(s, string, string2, secretExchangeType, string3, n, n2, n3, n4, string4, n5, hashAlgorithm, signatureAlgorithm, cipherType);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CipherSuite(code=").append(this.code).append(", name=").append(this.name).append(", openSSLName=").append(this.openSSLName).append(", exchangeType=").append((Object)this.exchangeType).append(", jdkCipherName=").append(this.jdkCipherName).append(", keyStrength=").append(this.keyStrength).append(", fixedIvLength=").append(this.fixedIvLength).append(", ivLength=").append(this.ivLength).append(", cipherTagSizeInBytes=").append(this.cipherTagSizeInBytes).append(", macName=").append(this.macName).append(", macStrength=").append(this.macStrength).append(", hash=");
        stringBuilder.append((Object)this.hash).append(", signatureAlgorithm=").append((Object)this.signatureAlgorithm).append(", cipherType=").append((Object)this.cipherType).append(')');
        return stringBuilder.toString();
    }

    public int hashCode() {
        int result2 = Short.hashCode(this.code);
        result2 = result2 * 31 + this.name.hashCode();
        result2 = result2 * 31 + this.openSSLName.hashCode();
        result2 = result2 * 31 + this.exchangeType.hashCode();
        result2 = result2 * 31 + this.jdkCipherName.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.keyStrength);
        result2 = result2 * 31 + Integer.hashCode(this.fixedIvLength);
        result2 = result2 * 31 + Integer.hashCode(this.ivLength);
        result2 = result2 * 31 + Integer.hashCode(this.cipherTagSizeInBytes);
        result2 = result2 * 31 + this.macName.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.macStrength);
        result2 = result2 * 31 + this.hash.hashCode();
        result2 = result2 * 31 + this.signatureAlgorithm.hashCode();
        result2 = result2 * 31 + this.cipherType.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CipherSuite)) {
            return false;
        }
        CipherSuite cipherSuite = (CipherSuite)other;
        if (this.code != cipherSuite.code) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)cipherSuite.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.openSSLName, (Object)cipherSuite.openSSLName)) {
            return false;
        }
        if (this.exchangeType != cipherSuite.exchangeType) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.jdkCipherName, (Object)cipherSuite.jdkCipherName)) {
            return false;
        }
        if (this.keyStrength != cipherSuite.keyStrength) {
            return false;
        }
        if (this.fixedIvLength != cipherSuite.fixedIvLength) {
            return false;
        }
        if (this.ivLength != cipherSuite.ivLength) {
            return false;
        }
        if (this.cipherTagSizeInBytes != cipherSuite.cipherTagSizeInBytes) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.macName, (Object)cipherSuite.macName)) {
            return false;
        }
        if (this.macStrength != cipherSuite.macStrength) {
            return false;
        }
        if (this.hash != cipherSuite.hash) {
            return false;
        }
        if (this.signatureAlgorithm != cipherSuite.signatureAlgorithm) {
            return false;
        }
        return this.cipherType == cipherSuite.cipherType;
    }
}

