/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.CodecsKt;
import io.ktor.http.Parameters;
import io.ktor.http.QueryKt;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLBuilderKt;
import io.ktor.http.URLParserException;
import io.ktor.http.URLProtocol;
import io.ktor.util.CharsetKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\u001a\u0019\u0010\u0003\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u001b\u0010\u0005\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0004\u001a3\u0010\u000b\u001a\u00020\n*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000b\u0010\f\u001a+\u0010\r\u001a\u00020\n*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\r\u0010\u000e\u001a+\u0010\u000f\u001a\u00020\u0006*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a+\u0010\u0011\u001a\u00020\n*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u000e\u001a+\u0010\u0012\u001a\u00020\n*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u000e\u001a'\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a/\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018\u001a#\u0010\u0019\u001a\u00020\u0006*\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0014\u001a\u0013\u0010\u001b\u001a\u00020\u001a*\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001c\" \u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u001d8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lio/ktor/http/URLBuilder;", "", "urlString", "takeFrom", "(Lio/ktor/http/URLBuilder;Ljava/lang/String;)Lio/ktor/http/URLBuilder;", "takeFromUnsafe", "", "startIndex", "endIndex", "slashCount", "", "parseFile", "(Lio/ktor/http/URLBuilder;Ljava/lang/String;III)V", "parseMailto", "(Lio/ktor/http/URLBuilder;Ljava/lang/String;II)V", "parseQuery", "(Lio/ktor/http/URLBuilder;Ljava/lang/String;II)I", "parseFragment", "fillHost", "findScheme", "(Ljava/lang/String;II)I", "", "char", "count", "(Ljava/lang/String;IIC)I", "indexOfColonInHostPort", "", "isLetter", "(C)Z", "", "ROOT_PATH", "Ljava/util/List;", "getROOT_PATH", "()Ljava/util/List;", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nURLParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 URLParser.kt\nio/ktor/http/URLParserKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,283:1\n158#2,6:284\n170#2,6:290\n1#3:296\n*S KotlinDebug\n*F\n+ 1 URLParser.kt\nio/ktor/http/URLParserKt\n*L\n38#1:284,6\n39#1:290,6\n*E\n"})
public final class URLParserKt {
    @NotNull
    private static final List<String> ROOT_PATH = CollectionsKt.listOf((Object)"");

    @NotNull
    public static final List<String> getROOT_PATH() {
        return ROOT_PATH;
    }

    @NotNull
    public static final URLBuilder takeFrom(@NotNull URLBuilder $this$takeFrom, @NotNull String urlString) {
        URLBuilder uRLBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$takeFrom, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        if (StringsKt.isBlank((CharSequence)urlString)) {
            return $this$takeFrom;
        }
        try {
            uRLBuilder = URLParserKt.takeFromUnsafe($this$takeFrom, urlString);
        }
        catch (Throwable cause) {
            throw new URLParserException(urlString, cause);
        }
        return uRLBuilder;
    }

    @NotNull
    public static final URLBuilder takeFromUnsafe(@NotNull URLBuilder $this$takeFromUnsafe, @NotNull String urlString) {
        int pathEnd;
        int it;
        int n;
        int startIndex;
        block21: {
            int n2;
            int n3;
            block20: {
                Intrinsics.checkNotNullParameter((Object)$this$takeFromUnsafe, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
                CharSequence $this$indexOfFirst$iv = urlString;
                boolean $i$f$indexOfFirst = false;
                n3 = $this$indexOfFirst$iv.length();
                for (int index$iv = 0; index$iv < n3; ++index$iv) {
                    char it2 = $this$indexOfFirst$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!(!CharsKt.isWhitespace((char)it2))) continue;
                    n2 = index$iv;
                    break block20;
                }
                n2 = -1;
            }
            startIndex = n2;
            CharSequence $this$indexOfLast$iv = urlString;
            boolean $i$f$indexOfLast = false;
            n3 = $this$indexOfLast$iv.length() + -1;
            if (0 <= n3) {
                do {
                    int index$iv = n3--;
                    char it3 = $this$indexOfLast$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!(!CharsKt.isWhitespace((char)it3))) continue;
                    n = index$iv;
                    break block21;
                } while (0 <= n3);
            }
            n = -1;
        }
        int endIndex = n + 1;
        int schemeLength = URLParserKt.findScheme(urlString, startIndex, endIndex);
        if (schemeLength > 0) {
            String string = urlString.substring(startIndex, startIndex + schemeLength);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String scheme = string;
            $this$takeFromUnsafe.setProtocol(URLProtocol.Companion.createOrDefault(scheme));
            startIndex += schemeLength + 1;
        }
        int slashCount = URLParserKt.count(urlString, startIndex, endIndex, '/');
        startIndex += slashCount;
        if (Intrinsics.areEqual((Object)$this$takeFromUnsafe.getProtocol().getName(), (Object)"file")) {
            URLParserKt.parseFile($this$takeFromUnsafe, urlString, startIndex, endIndex, slashCount);
            return $this$takeFromUnsafe;
        }
        if (Intrinsics.areEqual((Object)$this$takeFromUnsafe.getProtocol().getName(), (Object)"mailto")) {
            if (!(slashCount == 0)) {
                String index$iv = "Failed requirement.";
                throw new IllegalArgumentException(index$iv.toString());
            }
            URLParserKt.parseMailto($this$takeFromUnsafe, urlString, startIndex, endIndex);
            return $this$takeFromUnsafe;
        }
        if (Intrinsics.areEqual((Object)$this$takeFromUnsafe.getProtocol().getName(), (Object)"about")) {
            if (!(slashCount == 0)) {
                String index$iv = "Failed requirement.";
                throw new IllegalArgumentException(index$iv.toString());
            }
            String string = urlString.substring(startIndex, endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            $this$takeFromUnsafe.setHost(string);
            return $this$takeFromUnsafe;
        }
        if (Intrinsics.areEqual((Object)$this$takeFromUnsafe.getProtocol().getName(), (Object)"tel")) {
            if (!(slashCount == 0)) {
                String index$iv = "Failed requirement.";
                throw new IllegalArgumentException(index$iv.toString());
            }
            String string = urlString.substring(startIndex, endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            $this$takeFromUnsafe.setHost(string);
            return $this$takeFromUnsafe;
        }
        if (slashCount >= 2) {
            int delimiter;
            while (true) {
                Integer it3 = StringsKt.indexOfAny$default((CharSequence)urlString, (char[])CharsetKt.toCharArray((String)"@/\\?#"), (int)startIndex, (boolean)false, (int)4, null);
                it = ((Number)it3).intValue();
                boolean bl = false;
                Integer n4 = it > 0 ? it3 : null;
                int n5 = delimiter = n4 != null ? n4 : endIndex;
                if (delimiter >= endIndex || urlString.charAt(delimiter) != '@') break;
                int passwordIndex = URLParserKt.indexOfColonInHostPort(urlString, startIndex, delimiter);
                if (passwordIndex != -1) {
                    String string = urlString.substring(startIndex, passwordIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    $this$takeFromUnsafe.setEncodedUser(string);
                    String string2 = urlString.substring(passwordIndex + 1, delimiter);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    $this$takeFromUnsafe.setEncodedPassword(string2);
                } else {
                    String string = urlString.substring(startIndex, delimiter);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    $this$takeFromUnsafe.setEncodedUser(string);
                }
                startIndex = delimiter + 1;
            }
            URLParserKt.fillHost($this$takeFromUnsafe, urlString, startIndex, delimiter);
            startIndex = delimiter;
        }
        if (startIndex >= endIndex) {
            $this$takeFromUnsafe.setEncodedPathSegments(urlString.charAt(endIndex - 1) == '/' ? ROOT_PATH : CollectionsKt.emptyList());
            return $this$takeFromUnsafe;
        }
        $this$takeFromUnsafe.setEncodedPathSegments(slashCount == 0 ? CollectionsKt.dropLast($this$takeFromUnsafe.getEncodedPathSegments(), (int)1) : CollectionsKt.emptyList());
        Integer it3 = StringsKt.indexOfAny$default((CharSequence)urlString, (char[])CharsetKt.toCharArray((String)"?#"), (int)startIndex, (boolean)false, (int)4, null);
        it = ((Number)it3).intValue();
        boolean bl2 = false;
        Integer n6 = it > 0 ? it3 : null;
        int n7 = pathEnd = n6 != null ? n6 : endIndex;
        if (pathEnd > startIndex) {
            List list;
            List basePath;
            String string = urlString.substring(startIndex, pathEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String rawPath = string;
            List list2 = $this$takeFromUnsafe.getEncodedPathSegments().size() == 1 && ((CharSequence)CollectionsKt.first($this$takeFromUnsafe.getEncodedPathSegments())).length() == 0 ? CollectionsKt.emptyList() : (basePath = $this$takeFromUnsafe.getEncodedPathSegments());
            if (Intrinsics.areEqual((Object)rawPath, (Object)"/")) {
                list = ROOT_PATH;
            } else {
                char[] bl2 = new char[]{'/'};
                list = StringsKt.split$default((CharSequence)rawPath, (char[])bl2, (boolean)false, (int)0, (int)6, null);
            }
            List rawChunks = list;
            List relativePath = CollectionsKt.plus((Collection)(slashCount == 1 ? ROOT_PATH : CollectionsKt.emptyList()), (Iterable)rawChunks);
            $this$takeFromUnsafe.setEncodedPathSegments(CollectionsKt.plus((Collection)basePath, (Iterable)relativePath));
            startIndex = pathEnd;
        }
        if (startIndex < endIndex && urlString.charAt(startIndex) == '?') {
            startIndex = URLParserKt.parseQuery($this$takeFromUnsafe, urlString, startIndex, endIndex);
        }
        URLParserKt.parseFragment($this$takeFromUnsafe, urlString, startIndex, endIndex);
        return $this$takeFromUnsafe;
    }

    private static final void parseFile(URLBuilder $this$parseFile, String urlString, int startIndex, int endIndex, int slashCount) {
        switch (slashCount) {
            case 1: {
                $this$parseFile.setHost("");
                String string = urlString.substring(startIndex, endIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                URLBuilderKt.setEncodedPath($this$parseFile, string);
                break;
            }
            case 2: {
                int nextSlash = StringsKt.indexOf$default((CharSequence)urlString, (char)'/', (int)startIndex, (boolean)false, (int)4, null);
                if (nextSlash == -1 || nextSlash == endIndex) {
                    String string = urlString.substring(startIndex, endIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    $this$parseFile.setHost(string);
                    return;
                }
                String string = urlString.substring(startIndex, nextSlash);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                $this$parseFile.setHost(string);
                String string2 = urlString.substring(nextSlash, endIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                URLBuilderKt.setEncodedPath($this$parseFile, string2);
                break;
            }
            case 3: {
                $this$parseFile.setHost("");
                StringBuilder stringBuilder = new StringBuilder().append('/');
                String string = urlString.substring(startIndex, endIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                URLBuilderKt.setEncodedPath($this$parseFile, stringBuilder.append(string).toString());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid file url: " + urlString);
            }
        }
    }

    private static final void parseMailto(URLBuilder $this$parseMailto, String urlString, int startIndex, int endIndex) {
        int delimiter = StringsKt.indexOf$default((CharSequence)urlString, (String)"@", (int)startIndex, (boolean)false, (int)4, null);
        if (delimiter == -1) {
            throw new IllegalArgumentException("Invalid mailto url: " + urlString + ", it should contain '@'.");
        }
        String string = urlString.substring(startIndex, delimiter);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        $this$parseMailto.setUser(CodecsKt.decodeURLPart$default(string, 0, 0, null, 7, null));
        String string2 = urlString.substring(delimiter + 1, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        $this$parseMailto.setHost(string2);
    }

    private static final int parseQuery(URLBuilder $this$parseQuery, String urlString, int startIndex, int endIndex) {
        if (startIndex + 1 == endIndex) {
            $this$parseQuery.setTrailingQuery(true);
            return endIndex;
        }
        Integer n = StringsKt.indexOf$default((CharSequence)urlString, (char)'#', (int)(startIndex + 1), (boolean)false, (int)4, null);
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it > 0 ? n : null;
        int fragmentStart = n2 != null ? n2 : endIndex;
        String string = urlString.substring(startIndex + 1, fragmentStart);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        Parameters rawParameters = QueryKt.parseQueryString$default(string, 0, 0, false, 6, null);
        rawParameters.forEach((arg_0, arg_1) -> URLParserKt.parseQuery$lambda$5($this$parseQuery, arg_0, arg_1));
        return fragmentStart;
    }

    private static final void parseFragment(URLBuilder $this$parseFragment, String urlString, int startIndex, int endIndex) {
        if (startIndex < endIndex && urlString.charAt(startIndex) == '#') {
            String string = urlString.substring(startIndex + 1, endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            $this$parseFragment.setEncodedFragment(string);
        }
    }

    private static final void fillHost(URLBuilder $this$fillHost, String urlString, int startIndex, int endIndex) {
        int n;
        Integer n2 = URLParserKt.indexOfColonInHostPort(urlString, startIndex, endIndex);
        int it = ((Number)n2).intValue();
        boolean bl = false;
        Integer n3 = it > 0 ? n2 : null;
        int colonIndex = n3 != null ? n3 : endIndex;
        String string = urlString.substring(startIndex, colonIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        $this$fillHost.setHost(string);
        if (colonIndex + 1 < endIndex) {
            String string2 = urlString.substring(colonIndex + 1, endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            n = Integer.parseInt(string2);
        } else {
            n = 0;
        }
        $this$fillHost.setPort(n);
    }

    private static final int findScheme(String urlString, int startIndex, int endIndex) {
        int current = startIndex;
        int incorrectSchemePosition = -1;
        char firstChar = urlString.charAt(current);
        if (!('a' <= firstChar ? firstChar < '{' : false)) {
            if (!('A' <= firstChar ? firstChar < '[' : false)) {
                incorrectSchemePosition = current;
            }
        }
        while (current < endIndex) {
            char c = urlString.charAt(current);
            if (c == ':') {
                if (incorrectSchemePosition != -1) {
                    throw new IllegalArgumentException("Illegal character in scheme at position " + incorrectSchemePosition);
                }
                return current - startIndex;
            }
            switch (c) {
                case '#': 
                case '/': 
                case '?': {
                    return -1;
                }
            }
            if (incorrectSchemePosition == -1) {
                if (!('a' <= c ? c < '{' : false)) {
                    if (!('A' <= c ? c < '[' : false)) {
                        if (!('0' <= c ? c < ':' : false) && c != '.' && c != '+' && c != '-') {
                            incorrectSchemePosition = current;
                        }
                    }
                }
            }
            ++current;
        }
        return -1;
    }

    private static final int count(String urlString, int startIndex, int endIndex, char c) {
        int result2 = 0;
        while (startIndex + result2 < endIndex && urlString.charAt(startIndex + result2) == c) {
            ++result2;
        }
        return result2;
    }

    private static final int indexOfColonInHostPort(String $this$indexOfColonInHostPort, int startIndex, int endIndex) {
        boolean skip = false;
        block5: for (int index = startIndex; index < endIndex; ++index) {
            switch ($this$indexOfColonInHostPort.charAt(index)) {
                case '[': {
                    skip = true;
                    continue block5;
                }
                case ']': {
                    skip = false;
                    continue block5;
                }
                case ':': {
                    if (skip) continue block5;
                    return index;
                }
            }
        }
        return -1;
    }

    private static final boolean isLetter(char $this$isLetter) {
        char c = Character.toLowerCase($this$isLetter);
        return 'a' <= c ? c < '{' : false;
    }

    private static final Unit parseQuery$lambda$5(URLBuilder $this_parseQuery, String key2, List values) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        $this_parseQuery.getEncodedParameters().appendAll(key2, values);
        return Unit.INSTANCE;
    }
}

