/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.DatabaseSessionActionBase;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.audit.CancelProgressAuditor;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class CancelRunningStatementsAction
extends DatabaseSessionActionBase
implements GridAction {
    @Override
    protected boolean isEnabled(@NotNull AnActionEvent event, @NotNull DatabaseSession session) {
        if (event == null) {
            CancelRunningStatementsAction.$$$reportNull$$$0(0);
        }
        if (session == null) {
            CancelRunningStatementsAction.$$$reportNull$$$0(1);
        }
        return session.isValid() && !session.isIdle();
    }

    @Override
    protected void performAction(@NotNull AnActionEvent event, @NotNull DatabaseSession session) {
        if (event == null) {
            CancelRunningStatementsAction.$$$reportNull$$$0(2);
        }
        if (session == null) {
            CancelRunningStatementsAction.$$$reportNull$$$0(3);
        }
        if (!session.isCancelled()) {
            session.getMessageBus().getDataProducer().processRequest(CancelRunningStatementsAction.createCancelRequest(session));
        } else {
            CancelRunningStatementsAction.deactivateWithConfirmation(session, false);
        }
    }

    public static GridDataRequest createCancelRequest(@NotNull DatabaseSession session) {
        if (session == null) {
            CancelRunningStatementsAction.$$$reportNull$$$0(4);
        }
        DataRequest.Cancel cancelRequest = new DataRequest.Cancel((DataRequest.OwnerEx)session);
        cancelRequest.getPromise().onError(ignored -> ApplicationManager.getApplication().invokeLater(() -> CancelRunningStatementsAction.deactivateWithConfirmation(session, true)));
        cancelRequest.putUserData(CancelProgressAuditor.SHOW_CANCEL_PROGRESS, (Object)true);
        return cancelRequest;
    }

    private static void deactivateWithConfirmation(@NotNull DatabaseSession session, boolean isCancellingFailed) {
        int ret;
        if (session == null) {
            CancelRunningStatementsAction.$$$reportNull$$$0(5);
        }
        if ((ret = Messages.showOkCancelDialog((Project)session.getProject(), (String)DatabaseBundle.message((String)"deactivate.data.source.dialog.message", (Object[])new Object[0]), (String)DatabaseBundle.message((String)"deactivate.data.source.dialog.title", (Object[])new Object[]{isCancellingFailed ? 1 : 0}), (String)DatabaseBundle.message((String)"deactivate.data.source.dialog.ok.button.text", (Object[])new Object[0]), (String)DatabaseBundle.message((String)"deactivate.data.source.dialog.cancel.button.text", (Object[])new Object[0]), (Icon)Messages.getWarningIcon())) != 0) {
            return;
        }
        SessionsUtil.deactivateDataSourceAsync(session);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/actions/CancelRunningStatementsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "performAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createCancelRequest";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "deactivateWithConfirmation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

