/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.validation;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverUtils;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactList;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactManager;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.dataSource.validation.DatabaseDriverValidator;
import com.intellij.database.util.Version;
import com.intellij.database.view.ui.ActualConfigInfoProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocalDataSourceValidator
extends DatabaseConfigValidator<LocalDataSource> {
    @Override
    public Class<? extends LocalDataSource> getTargetClass() {
        return LocalDataSource.class;
    }

    @Override
    public void collectProblems(@NotNull Project project, @NotNull LocalDataSource target, @NotNull Consumer<? super DataSourceProblem> problems, @Nullable ActualConfigInfoProvider configInfoProvider) {
        DatabaseDriver driver;
        if (project == null) {
            LocalDataSourceValidator.$$$reportNull$$$0(0);
        }
        if (target == null) {
            LocalDataSourceValidator.$$$reportNull$$$0(1);
        }
        if (problems == null) {
            LocalDataSourceValidator.$$$reportNull$$$0(2);
        }
        if ((driver = target.getDatabaseDriver()) == null) {
            return;
        }
        DatabaseDriver targetDriver = configInfoProvider == null ? driver : configInfoProvider.getTempTargetOrTarget(driver);
        LocalDataSourceValidator.findSupportProblems(target, targetDriver, problems);
        DatabaseDriverValidator.findDriverFilesProblems(targetDriver, problems, target);
        DatabaseConfigValidator authProvider = (DatabaseConfigValidator)ObjectUtils.tryCast((Object)DatabaseAuthProvider.get((DatabaseConnectionPoint)target), DatabaseConfigValidator.class);
        if (authProvider != null && this.getTargetClass().isAssignableFrom(target.getClass())) {
            authProvider.collectProblems(project, target, problems, configInfoProvider);
        }
        DatabaseDriverValidator.findDriverLanguageProblem(targetDriver, problems, target);
    }

    private static void findSupportProblems(@NotNull LocalDataSource target, DatabaseDriver targetDriver, @NotNull Consumer<? super DataSourceProblem> problems) {
        if (target == null) {
            LocalDataSourceValidator.$$$reportNull$$$0(3);
        }
        if (problems == null) {
            LocalDataSourceValidator.$$$reportNull$$$0(4);
        }
        if (!DatabaseDriverUtils.passesConstraints((DatabaseDriver)targetDriver, (LocalDataSource)target)) {
            return;
        }
        Version version = target.getVersion();
        if (Version.ZERO.less(version)) {
            Dbms dbms = target.getDbms();
            Couple range = DatabaseDriverUtils.getSupportedRange((DatabaseArtifactList)DatabaseArtifactManager.getArtifacts(), (DatabaseDriver)targetDriver, (Dbms)dbms);
            if (version.less((Version)range.first) || ((Version)range.second).less(version)) {
                String text = DatabaseBundle.message((String)"notification.content.driver.does.not.support", (Object[])new Object[]{dbms.getDisplayName(), version});
                DataSourceProblem.HyperText hyperText = new DataSourceProblem.HyperText(DatabaseBundle.message((String)"notification.title.driver.database.incompatibility", (Object[])new Object[0]), text, text, new Object[0]);
                problems.consume((Object)new DataSourceProblem(target, null, DataSourceProblem.Level.ERROR, hyperText, null));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/validation/LocalDataSourceValidator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectProblems";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findSupportProblems";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

