/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.ui;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.NewLinterView;
import com.intellij.lang.javascript.linter.ui.JSLinterConfigFileTexts;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.NotNullProducer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public class JSLinterConfigFileView {
    private static final String EMPTY_ERROR_TEXT = " ";
    private final FileType myConfigFileType;
    private final JPanel myComponent;
    private final JRadioButton mySearchRadioButton;
    private final JRadioButton myConfigRadioButton;
    private final TextFieldWithHistoryWithBrowseButton myConfigFileField;
    private final JLabel myConfigFileErrorLabel;
    private NotNullProducer<List<VirtualFile>> myAdditionalConfigFilesProducer;

    public JSLinterConfigFileView(@NotNull Project project, @NotNull JSLinterConfigFileTexts texts, @Nullable FileType configFileType) {
        if (project == null) {
            JSLinterConfigFileView.$$$reportNull$$$0(0);
        }
        if (texts == null) {
            JSLinterConfigFileView.$$$reportNull$$$0(1);
        }
        this.myConfigFileType = configFileType;
        this.mySearchRadioButton = new JBRadioButton(texts.getSearchOptionTitle());
        this.myConfigRadioButton = new JBRadioButton(JavaScriptBundle.message("javascript.linter.radio.button.configuration.file", new Object[0]));
        this.myConfigFileField = this.createCustomConfigField(project, texts.getConfigFileBrowseDialogTitle());
        this.myConfigFileErrorLabel = new JLabel(EMPTY_ERROR_TEXT);
        this.myConfigFileErrorLabel.setFont(UIUtil.getTitledBorderFont());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.mySearchRadioButton);
        buttonGroup.add(this.myConfigRadioButton);
        this.mySearchRadioButton.setSelected(true);
        ((TextFieldWithHistory)this.myConfigFileField.getChildComponent()).getTextEditor().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                JSLinterConfigFileView.this.updateCustomErrorMessage();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/linter/ui/JSLinterConfigFileView$1", "textChanged"));
            }
        });
        this.myComponent = this.createResultPanel(texts.getSearchOptionDescription());
    }

    public void setAdditionalConfigFilesProducer(@NotNull NotNullProducer<List<VirtualFile>> additionalConfigFilesProducer) {
        if (additionalConfigFilesProducer == null) {
            JSLinterConfigFileView.$$$reportNull$$$0(2);
        }
        this.myAdditionalConfigFilesProducer = additionalConfigFilesProducer;
    }

    @NotNull
    public JPanel getComponent() {
        JPanel jPanel = this.myComponent;
        if (jPanel == null) {
            JSLinterConfigFileView.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    public boolean isCustomConfigFileUsed() {
        return this.myConfigRadioButton.isSelected();
    }

    @NotNull
    public @SystemIndependent String getCustomConfigFilePath() {
        String string = FileUtil.toSystemIndependentName((String)this.myConfigFileField.getText().trim());
        if (string == null) {
            JSLinterConfigFileView.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void onEnabledStateChanged(boolean enabled) {
        if (enabled) {
            this.setCustomConfigFileUsed(this.myConfigRadioButton.isSelected());
        } else {
            this.updateCustomErrorMessage();
        }
    }

    public void setCustomConfigFileUsed(boolean customConfigFileUsed) {
        this.mySearchRadioButton.setSelected(!customConfigFileUsed);
        this.myConfigRadioButton.setSelected(customConfigFileUsed);
        this.onSelectedItemChanged(customConfigFileUsed, false);
    }

    private void onSelectedItemChanged(boolean customConfigUsed, boolean focusInput) {
        UIUtil.setEnabled((Component)this.myConfigFileField, (boolean)customConfigUsed, (boolean)true);
        if (customConfigUsed && focusInput) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myConfigFileField, true));
        }
        this.updateCustomErrorMessage();
    }

    public void setCustomConfigFilePath(@NotNull String customConfigFilePath) {
        if (customConfigFilePath == null) {
            JSLinterConfigFileView.$$$reportNull$$$0(5);
        }
        TextFieldWithHistory history = (TextFieldWithHistory)this.myConfigFileField.getChildComponent();
        history.setText(FileUtil.toSystemDependentName((String)customConfigFilePath));
        history.addCurrentTextToHistory();
    }

    private void updateCustomErrorMessage() {
        if (this.myConfigRadioButton.isSelected() && this.myConfigRadioButton.isEnabled()) {
            String errorMessage = JSLinterConfigFileView.formatErrorMessage(((TextFieldWithHistory)this.myConfigFileField.getChildComponent()).getText());
            if (errorMessage != null) {
                String html = JSLinterUtil.getRedErrorTextHtml(errorMessage);
                this.myConfigFileErrorLabel.setText(html);
            } else {
                this.myConfigFileErrorLabel.setText(EMPTY_ERROR_TEXT);
            }
        } else {
            this.myConfigFileErrorLabel.setText(EMPTY_ERROR_TEXT);
        }
    }

    public void setEnabled(boolean enabled) {
        this.myConfigRadioButton.setEnabled(enabled);
        this.mySearchRadioButton.setEnabled(enabled);
        this.myConfigFileField.setEnabled(enabled);
    }

    @Nullable
    @InspectionMessage
    public static String formatErrorMessage(@NotNull String path2) {
        if (path2 == null) {
            JSLinterConfigFileView.$$$reportNull$$$0(6);
        }
        if (path2.trim().isEmpty()) {
            return JavaScriptBundle.message("javascript.linter.error.empty.path", new Object[0]);
        }
        File file = new File(path2);
        if (!file.isAbsolute() || !file.isFile()) {
            return JavaScriptBundle.message("javascript.linter.error.no.such.file", new Object[0]);
        }
        return null;
    }

    @NotNull
    private JPanel createResultPanel(@NlsContexts.Tooltip @NotNull String searchForConfigDescription) {
        if (searchForConfigDescription == null) {
            JSLinterConfigFileView.$$$reportNull$$$0(7);
        }
        ItemListener radioButtonListener = e -> {
            if (e.getItem() == this.myConfigRadioButton) {
                this.onSelectedItemChanged(this.myConfigRadioButton.isSelected(), true);
            }
        };
        this.mySearchRadioButton.addItemListener(radioButtonListener);
        this.myConfigRadioButton.addItemListener(radioButtonListener);
        FormBuilder formBuilder = FormBuilder.createFormBuilder();
        formBuilder.addComponent((JComponent)this.mySearchRadioButton);
        JComponent searchButtonWrapped = NewLinterView.createPanelWithHelpLink(this.mySearchRadioButton, searchForConfigDescription);
        formBuilder.addComponent(searchButtonWrapped);
        formBuilder.addComponent((JComponent)this.createCustomConfigFilePanel());
        JPanel panel = formBuilder.getPanel();
        panel.setBorder(IdeBorderFactory.createTitledBorder((String)JavaScriptBundle.message("javascript.linter.configuration.file.title", new Object[0])));
        JPanel jPanel = panel;
        if (jPanel == null) {
            JSLinterConfigFileView.$$$reportNull$$$0(8);
        }
        return jPanel;
    }

    @NotNull
    private JPanel createCustomConfigFilePanel() {
        JPanel configFileErrorPanel = SwingHelper.wrapWithoutStretch((JComponent)this.myConfigFileErrorLabel);
        configFileErrorPanel.setBorder(BorderFactory.createEmptyBorder(0, JBUIScale.scale((int)4), 0, 0));
        JPanel jPanel = FormBuilder.createFormBuilder().addLabeledComponent((JComponent)this.myConfigRadioButton, (JComponent)this.myConfigFileField).addComponentToRightColumn((JComponent)configFileErrorPanel, 0).getPanel();
        if (jPanel == null) {
            JSLinterConfigFileView.$$$reportNull$$$0(9);
        }
        return jPanel;
    }

    @NotNull
    private TextFieldWithHistoryWithBrowseButton createCustomConfigField(@NotNull Project project, @NlsContexts.DialogTitle String selectFileText) {
        if (project == null) {
            JSLinterConfigFileView.$$$reportNull$$$0(10);
        }
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withTitle(selectFileText);
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = SwingHelper.createTextFieldWithHistoryWithBrowseButton((Project)project, (FileChooserDescriptor)descriptor, () -> {
            List<VirtualFile> files = this.listConfigFilesInContentScope(project);
            return ContainerUtil.sorted((Collection)ContainerUtil.map(files, file -> FileUtil.toSystemDependentName((String)file.getPath())));
        });
        if (textFieldWithHistoryWithBrowseButton == null) {
            JSLinterConfigFileView.$$$reportNull$$$0(11);
        }
        return textFieldWithHistoryWithBrowseButton;
    }

    @NotNull
    private List<VirtualFile> listConfigFilesInContentScope(@NotNull Project project) {
        if (project == null) {
            JSLinterConfigFileView.$$$reportNull$$$0(12);
        }
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        if (this.myConfigFileType != null) {
            GlobalSearchScope scope2 = ProjectScope.getContentScope((Project)project);
            Collection configs = FileTypeIndex.getFiles((FileType)this.myConfigFileType, (GlobalSearchScope)scope2);
            for (VirtualFile config : configs) {
                if (config == null || !config.isValid() || config.isDirectory() || JSLibraryUtil.isProbableLibraryFile(config, project)) continue;
                result2.add(config);
            }
        }
        if (this.myAdditionalConfigFilesProducer != null) {
            List files = (List)this.myAdditionalConfigFilesProducer.produce();
            result2.addAll(files);
        }
        ArrayList<VirtualFile> arrayList = result2;
        if (arrayList == null) {
            JSLinterConfigFileView.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    public void setPreferredWidthToComponents() {
        SwingHelper.setPreferredWidthToFitText((TextFieldWithHistoryWithBrowseButton)this.myConfigFileField);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 8, 9, 11, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "texts";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalConfigFilesProducer";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/ui/JSLinterConfigFileView";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customConfigFilePath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchForConfigDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/ui/JSLinterConfigFileView";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomConfigFilePath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createResultPanel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomConfigFilePanel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomConfigField";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "listConfigFilesInContentScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setAdditionalConfigFilesProducer";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setCustomConfigFilePath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "formatErrorMessage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createResultPanel";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createCustomConfigField";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "listConfigFilesInContentScope";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 8, 9, 11, 13 -> new IllegalStateException(string);
        };
    }
}

