/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContextualUnionType;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.recordImpl.PropertySignatureImpl;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIntersectionTypeImpl
extends JSCompositeTypeBaseImpl
implements JSIntersectionType {
    @ApiStatus.Internal
    public JSIntersectionTypeImpl(@NotNull JSTypeSource source, @NotNull Collection<? extends JSType> _types) {
        if (source == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(0);
        }
        if (_types == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(1);
        }
        super(source, _types);
    }

    protected JSIntersectionTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(2);
        }
        if (inputStream == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(3);
        }
        super(source, inputStream);
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(4);
        }
        if (processingContext == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(5);
        }
        return JSIntersectionTypeImpl.isDirectlyAssignableTypeImpl(this, elementType, processingContext);
    }

    public static boolean isDirectlyAssignableTypeImpl(@NotNull JSIntersectionType thisType, @NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (thisType == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(6);
        }
        if (elementType == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(7);
        }
        if (processingContext == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(8);
        }
        boolean hadAssignable = false;
        List<JSType> types = thisType.getTypes();
        HashSet<JSType> nonAssignable = new HashSet<JSType>();
        boolean allNonAssignableWeak = true;
        for (JSType type2 : types) {
            if (!type2.isDirectlyAssignableType(elementType, processingContext)) {
                nonAssignable.add(type2);
                allNonAssignableWeak &= JSIntersectionTypeImpl.isWeakOrWithoutProperties(type2, processingContext);
                continue;
            }
            if (thisType instanceof JSContextualUnionType) {
                return true;
            }
            hadAssignable = true;
        }
        if (nonAssignable.isEmpty()) {
            return true;
        }
        if (allNonAssignableWeak) {
            if (hadAssignable) {
                Set names = nonAssignable.stream().flatMap(t -> t.asRecordType().getPropertyNames().stream()).collect(Collectors.toSet());
                JSRecordType elementRecordType = elementType.asRecordType();
                names.retainAll(elementRecordType.getPropertyNames());
                if (names.isEmpty()) {
                    return true;
                }
                JSRecordType ownRecordType = thisType.asRecordType();
                for (String name : names) {
                    JSRecordType.PropertySignature ownSignature = ownRecordType.findPropertySignature(name);
                    JSRecordType.PropertySignature otherSignature = elementRecordType.findPropertySignature(name);
                    assert (ownSignature != null && otherSignature != null);
                    JSType ownSignatureType = ownSignature.getJSType();
                    if (ownSignatureType == null || ownSignatureType.isDirectlyAssignableType(otherSignature.getJSType(), processingContext)) continue;
                    return false;
                }
                return true;
            }
            return thisType.asRecordType().isDirectlyAssignableType(elementType, processingContext);
        }
        return JSTypeCastUtil.isDirectlyAssignableTypeCommon(thisType, elementType, processingContext).isAssignable();
    }

    private static boolean isWeakOrWithoutProperties(@Nullable JSType t, @NotNull ProcessingContext processingContext) {
        if (processingContext == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(9);
        }
        JSType jSType = t = t == null ? null : t.substitute();
        if (t instanceof JSPrimitiveType) {
            t = null;
        }
        if (t != null) {
            t = t.asRecordType((PsiElement)processingContext.get(JSTypeComparingContextService.LOCATION));
        }
        return t != null && (((JSRecordType)t).isWeak() || !((JSRecordType)t).hasProperties());
    }

    @Override
    @NotNull
    protected JSType createType(@NotNull List<JSType> transformedTypes, @NotNull JSTypeSource newSource, boolean isSimpleTransformer) {
        if (transformedTypes == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(10);
        }
        if (newSource == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(11);
        }
        if (isSimpleTransformer) {
            return new JSIntersectionTypeImpl(newSource, transformedTypes);
        }
        JSType jSType = JSCompositeTypeFactory.createIntersectionType(transformedTypes, newSource);
        if (jSType == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(12);
        }
        return jSType;
    }

    @Override
    @Nullable
    public JSType substituteImpl(@NotNull JSTypeSubstitutionContext context2) {
        JSType result2;
        if (context2 == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(13);
        }
        if ((result2 = JSCompositeTypeBaseImpl.getSimpleCompositeTypeResult(this)) != null) {
            return result2;
        }
        return TypeScriptTypeRelations.expandUnionOrIntersectionType(this, context2);
    }

    @Override
    @NotNull
    public JSRecordType asRecordTypeNoCache() {
        return JSIntersectionTypeImpl.asRecordTypeNoCache(this);
    }

    @NotNull
    public static JSRecordType asRecordTypeNoCache(@NotNull JSIntersectionType thisType) {
        Collection<JSRecordType> resolvedTypes;
        if (thisType == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(14);
        }
        if ((resolvedTypes = JSCompositeTypeBaseImpl.getNestedTypesAsRecordType(thisType)).isEmpty()) {
            return new JSRecordTypeImpl(thisType.getSource(), ContainerUtil.emptyList());
        }
        ArrayList<JSRecordType.TypeMember> resultMembers = new ArrayList<JSRecordType.TypeMember>();
        MultiMap map2 = MultiMap.createLinked();
        for (JSRecordType resolvedType : resolvedTypes) {
            for (JSRecordType.TypeMember member : resolvedType.getTypeMembers()) {
                ProgressManager.checkCanceled();
                if (member instanceof JSRecordType.PropertySignature) {
                    JSRecordType.PropertySignature propertySignature = (JSRecordType.PropertySignature)member;
                    String name = propertySignature.getMemberName();
                    map2.putValue((Object)name, (Object)propertySignature);
                    continue;
                }
                resultMembers.add(member);
            }
        }
        if (map2.size() > 0) {
            for (Map.Entry entry : map2.entrySet()) {
                ProgressManager.checkCanceled();
                JSRecordType.PropertySignature newProperty = JSIntersectionTypeImpl.getSignature(thisType, (String)entry.getKey(), (Collection)entry.getValue(), resolvedTypes);
                resultMembers.add(newProperty);
            }
        }
        return new JSRecordTypeImpl(thisType.getSource(), resultMembers);
    }

    private static @NotNull JSRecordType.PropertySignature getSignature(@NotNull JSIntersectionType thisType, @NotNull String key, @NotNull Collection<JSRecordType.PropertySignature> values, @NotNull Collection<JSRecordType> resolvedTypes) {
        boolean startOptional;
        if (thisType == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(15);
        }
        if (key == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(16);
        }
        if (values == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(17);
        }
        if (resolvedTypes == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(18);
        }
        boolean isContextualUnion = thisType instanceof JSContextualUnionType;
        if (values.size() == 1 && !isContextualUnion) {
            JSRecordType.PropertySignature propertySignature = (JSRecordType.PropertySignature)ContainerUtil.getFirstItem(values);
            if (propertySignature == null) {
                JSIntersectionTypeImpl.$$$reportNull$$$0(19);
            }
            return propertySignature;
        }
        boolean isOptional = startOptional = !isContextualUnion;
        boolean isReadonly = isContextualUnion;
        ArrayList<JSType> types = new ArrayList<JSType>();
        ArrayList<PsiElement> propertySources = new ArrayList<PsiElement>(values.size());
        for (JSRecordType.PropertySignature signature : values) {
            JSType signatureType;
            if (startOptional != signature.isOptional()) {
                isOptional = signature.isOptional();
            }
            if (isContextualUnion && !signature.isConst()) {
                isReadonly = false;
            }
            if (!isContextualUnion && signature.isConst()) {
                isReadonly = true;
            }
            if ((signatureType = signature.getJSType()) != null) {
                types.add(signatureType);
            }
            JSRecordType.MemberSource source = signature.getMemberSource();
            propertySources.addAll(source.getAllSourceElements());
        }
        JSType resultType = thisType instanceof JSContextualUnionType ? JSCompositeTypeFactory.createContextualUnionType(types, thisType.getSource()) : JSCompositeTypeFactory.createIntersectionType(types, thisType.getSource());
        boolean finalOptional = isOptional || isContextualUnion && values.size() != resolvedTypes.size();
        JSRecordType.MemberSource source = JSRecordMemberSourceFactory.createSource(propertySources, JSRecordType.MemberSourceKind.Intersection, true);
        return new PropertySignatureImpl(key, resultType, finalOptional, isReadonly, source);
    }

    @Override
    protected boolean useCacheForRecordType() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_types";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 6: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformedTypes";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSIntersectionTypeImpl";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSIntersectionTypeImpl";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isWeakOrWithoutProperties";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 12: 
            case 19: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "substituteImpl";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "asRecordTypeNoCache";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getSignature";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 19 -> new IllegalStateException(string);
        };
    }
}

