/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.lsp;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.javascript.integration.JSAnnotationRangeError;
import com.intellij.lang.typescript.compiler.languageService.DiagnosticMessageItem;
import com.intellij.lang.typescript.compiler.languageService.DiagnosticMessageWithConcatenatedItemsParser;
import com.intellij.lang.typescript.compiler.languageService.LanguageServiceInfo;
import com.intellij.lang.typescript.compiler.languageService.LanguageServiceKind;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceAnnotationResult;
import com.intellij.lang.typescript.library.TypeScriptServiceDirectoryWatcher;
import com.intellij.lang.typescript.lsp.LspAnnotationErrorFilter;
import com.intellij.lang.typescript.lsp.TypeScriptGoPackageInfo;
import com.intellij.lang.typescript.lsp.TypeScriptGoPackageInfoKt;
import com.intellij.lang.typescript.lsp.TypeScriptGoPackageKind;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.lsp.impl.highlighting.DiagnosticAndQuickFixes;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0001\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0007H\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0007H\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\b\u0010!\u001a\u00020\u0007H\u0016J\b\u0010\"\u001a\u00020\u001cH\u0016J\b\u0010#\u001a\u00020\u001cH\u0016J\b\u0010$\u001a\u00020\u001cH\u0016J\b\u0010%\u001a\u00020\u001cH\u0016J\n\u0010&\u001a\u0004\u0018\u00010\u0007H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/lang/typescript/lsp/LspAnnotationError;", "Lcom/intellij/lang/javascript/integration/JSAnnotationRangeError;", "project", "Lcom/intellij/openapi/project/Project;", "diagnosticAndQuickFixes", "Lcom/intellij/platform/lsp/impl/highlighting/DiagnosticAndQuickFixes;", "path", "", "source", "filter", "Lcom/intellij/lang/typescript/lsp/LspAnnotationErrorFilter;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/platform/lsp/impl/highlighting/DiagnosticAndQuickFixes;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/lang/typescript/lsp/LspAnnotationErrorFilter;)V", "diagnostic", "Lorg/eclipse/lsp4j/Diagnostic;", "quickFixes", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "getQuickFixes", "()Ljava/util/List;", "tooltip", "simpleError", "getLanguageServiceInfo", "Lcom/intellij/lang/typescript/compiler/languageService/LanguageServiceInfo;", "getPrefix", "languageServiceKind", "Lcom/intellij/lang/typescript/compiler/languageService/LanguageServiceKind;", "code", "", "getDescription", "getTooltipText", "getHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "getCategory", "getLine", "getColumn", "getEndLine", "getEndColumn", "getAbsoluteFilePath", "intellij.javascript.impl"})
public final class LspAnnotationError
implements JSAnnotationRangeError {
    @Nullable
    private final String path;
    @Nullable
    private final String source;
    @NotNull
    private final LspAnnotationErrorFilter filter;
    @NotNull
    private final Diagnostic diagnostic;
    @NotNull
    private final List<IntentionAction> quickFixes;
    @NlsSafe
    @Nullable
    private final String tooltip;
    @NlsSafe
    @NotNull
    private final String simpleError;

    public LspAnnotationError(@NotNull Project project, @NotNull DiagnosticAndQuickFixes diagnosticAndQuickFixes, @NlsSafe @Nullable String path2, @NlsSafe @Nullable String source, @NotNull LspAnnotationErrorFilter filter2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)diagnosticAndQuickFixes, (String)"diagnosticAndQuickFixes");
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        this.path = path2;
        this.source = source;
        this.filter = filter2;
        this.diagnostic = diagnosticAndQuickFixes.getDiagnostic();
        this.quickFixes = diagnosticAndQuickFixes.getQuickFixes();
        String string = StringUtil.notNullize((String)this.diagnostic.getMessage(), (String)"error");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"notNullize(...)");
        this.simpleError = ((Object)StringsKt.trim((CharSequence)string)).toString();
        LanguageServiceInfo languageServiceInfo = this.getLanguageServiceInfo(project);
        Object object = this.diagnostic.getCode();
        int code = object != null && (object = (Integer)object.getRight()) != null ? (Integer)object : -1;
        List<DiagnosticMessageItem> parsedItems = DiagnosticMessageWithConcatenatedItemsParser.INSTANCE.parse(this.simpleError, code, project, languageServiceInfo);
        String prefix = this.getPrefix(languageServiceInfo.getServiceKind(), code);
        this.tooltip = DiagnosticMessageWithConcatenatedItemsParser.INSTANCE.messageItemsToHtml(parsedItems, prefix, project);
    }

    @NotNull
    public final List<IntentionAction> getQuickFixes() {
        return this.quickFixes;
    }

    private final LanguageServiceInfo getLanguageServiceInfo(Project project) {
        LanguageServiceInfo languageServiceInfo;
        TypeScriptServiceDirectoryWatcher typeScriptServiceDirectoryWatcher = TypeScriptServiceDirectoryWatcher.getService(project);
        Intrinsics.checkNotNullExpressionValue((Object)typeScriptServiceDirectoryWatcher, (String)"getService(...)");
        TypeScriptServiceDirectoryWatcher service = typeScriptServiceDirectoryWatcher;
        String string = service.calcServiceDirectoryAndRefresh();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"calcServiceDirectoryAndRefresh(...)");
        String servicePath = string;
        TypeScriptGoPackageInfo tsGoInfo = TypeScriptGoPackageInfoKt.getTypeScriptGoPackageInfo(servicePath);
        if (tsGoInfo != null) {
            Object object = tsGoInfo.getVersion();
            if (object == null || (object = object.getParsedVersion()) == null) {
                object = "unknown";
            }
            languageServiceInfo = new LanguageServiceInfo(servicePath, (String)object, null, switch (WhenMappings.$EnumSwitchMapping$0[tsGoInfo.getKind().ordinal()]) {
                case 1 -> LanguageServiceKind.TsGoLocal;
                case 2 -> LanguageServiceKind.TsGoNativePreview;
                default -> throw new NoWhenBranchMatchedException();
            });
        } else {
            String string2 = service.getDefaultServicePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDefaultServicePath(...)");
            languageServiceInfo = new LanguageServiceInfo(string2, "5.7.3", null, LanguageServiceKind.OtherLsp);
        }
        return languageServiceInfo;
    }

    private final String getPrefix(LanguageServiceKind languageServiceKind, int code) {
        return (languageServiceKind == LanguageServiceKind.TsGoLocal || languageServiceKind == LanguageServiceKind.TsGoNativePreview) && code > 0 ? "(tsgo) TS" + code + ": " : (this.source != null ? this.source + ": " : "");
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.source != null ? this.source + ": " + this.simpleError : this.simpleError;
    }

    @Override
    @Nullable
    public String getTooltipText() {
        return this.tooltip;
    }

    @Override
    @Nullable
    public ProblemHighlightType getHighlightType() {
        Object object = this.diagnostic.getCode();
        int code = object != null && (object = (Integer)object.getRight()) != null ? (Integer)object : -1;
        return TypeScriptLanguageServiceAnnotationResult.getHighlightingTypeByCode(this.getDescription(), code, this.getCategory());
    }

    @Override
    @NotNull
    public String getCategory() {
        if (!this.filter.isProblemEnabled(this.diagnostic)) {
            return "info";
        }
        DiagnosticSeverity diagnosticSeverity = this.diagnostic.getSeverity();
        return switch (diagnosticSeverity == null ? -1 : WhenMappings.$EnumSwitchMapping$1[diagnosticSeverity.ordinal()]) {
            case 1 -> "error";
            case 2 -> "warning";
            case 3 -> "suggestion";
            default -> "info";
        };
    }

    @Override
    public int getLine() {
        return this.diagnostic.getRange().getStart().getLine();
    }

    @Override
    public int getColumn() {
        return this.diagnostic.getRange().getStart().getCharacter();
    }

    @Override
    public int getEndLine() {
        return this.diagnostic.getRange().getEnd().getLine();
    }

    @Override
    public int getEndColumn() {
        return this.diagnostic.getRange().getEnd().getCharacter();
    }

    @Override
    @Nullable
    public String getAbsoluteFilePath() {
        return this.path;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[TypeScriptGoPackageKind.values().length];
            try {
                nArray[TypeScriptGoPackageKind.LocallyClonedAndBuilt.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TypeScriptGoPackageKind.NativePreviewPackage.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[DiagnosticSeverity.values().length];
            try {
                nArray[DiagnosticSeverity.Error.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DiagnosticSeverity.Warning.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DiagnosticSeverity.Hint.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

