// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        (unknown)
// source: pbmesh/v2beta1/proxy_configuration.proto

package meshv2beta1

import (
	v2beta1 "github.com/hashicorp/consul/proto-public/pbcatalog/v2beta1"
	_ "github.com/hashicorp/consul/proto-public/pbresource"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// +kubebuilder:validation:Enum=PROXY_MODE_DEFAULT;PROXY_MODE_TRANSPARENT;PROXY_MODE_DIRECT
// +kubebuilder:validation:Type=string
type ProxyMode int32

const (
	// ProxyModeDefault represents no specific mode and should
	// be used to indicate that a different layer of the configuration
	// chain should take precedence
	// buf:lint:ignore ENUM_ZERO_VALUE_SUFFIX
	ProxyMode_PROXY_MODE_DEFAULT ProxyMode = 0
	// ProxyModeTransparent represents that inbound and outbound application
	// traffic is being captured and redirected through the proxy.
	ProxyMode_PROXY_MODE_TRANSPARENT ProxyMode = 1
	// ProxyModeDirect represents that the proxy's listeners must be dialed directly
	// by the local application and other proxies.
	ProxyMode_PROXY_MODE_DIRECT ProxyMode = 2
)

// Enum value maps for ProxyMode.
var (
	ProxyMode_name = map[int32]string{
		0: "PROXY_MODE_DEFAULT",
		1: "PROXY_MODE_TRANSPARENT",
		2: "PROXY_MODE_DIRECT",
	}
	ProxyMode_value = map[string]int32{
		"PROXY_MODE_DEFAULT":     0,
		"PROXY_MODE_TRANSPARENT": 1,
		"PROXY_MODE_DIRECT":      2,
	}
)

func (x ProxyMode) Enum() *ProxyMode {
	p := new(ProxyMode)
	*p = x
	return p
}

func (x ProxyMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProxyMode) Descriptor() protoreflect.EnumDescriptor {
	return file_pbmesh_v2beta1_proxy_configuration_proto_enumTypes[0].Descriptor()
}

func (ProxyMode) Type() protoreflect.EnumType {
	return &file_pbmesh_v2beta1_proxy_configuration_proto_enumTypes[0]
}

func (x ProxyMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProxyMode.Descriptor instead.
func (ProxyMode) EnumDescriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_proxy_configuration_proto_rawDescGZIP(), []int{0}
}

// +kubebuilder:validation:Enum=LOG_SINK_TYPE_DEFAULT;LOG_SINK_TYPE_FILE;LOG_SINK_TYPE_STDERR;LOG_SINK_TYPE_STDOUT
// +kubebuilder:validation:Type=string
type LogSinkType int32

const (
	// buf:lint:ignore ENUM_ZERO_VALUE_SUFFIX
	LogSinkType_LOG_SINK_TYPE_DEFAULT LogSinkType = 0
	LogSinkType_LOG_SINK_TYPE_FILE    LogSinkType = 1
	LogSinkType_LOG_SINK_TYPE_STDERR  LogSinkType = 2
	LogSinkType_LOG_SINK_TYPE_STDOUT  LogSinkType = 3
)

// Enum value maps for LogSinkType.
var (
	LogSinkType_name = map[int32]string{
		0: "LOG_SINK_TYPE_DEFAULT",
		1: "LOG_SINK_TYPE_FILE",
		2: "LOG_SINK_TYPE_STDERR",
		3: "LOG_SINK_TYPE_STDOUT",
	}
	LogSinkType_value = map[string]int32{
		"LOG_SINK_TYPE_DEFAULT": 0,
		"LOG_SINK_TYPE_FILE":    1,
		"LOG_SINK_TYPE_STDERR":  2,
		"LOG_SINK_TYPE_STDOUT":  3,
	}
)

func (x LogSinkType) Enum() *LogSinkType {
	p := new(LogSinkType)
	*p = x
	return p
}

func (x LogSinkType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LogSinkType) Descriptor() protoreflect.EnumDescriptor {
	return file_pbmesh_v2beta1_proxy_configuration_proto_enumTypes[1].Descriptor()
}

func (LogSinkType) Type() protoreflect.EnumType {
	return &file_pbmesh_v2beta1_proxy_configuration_proto_enumTypes[1]
}

func (x LogSinkType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LogSinkType.Descriptor instead.
func (LogSinkType) EnumDescriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_proxy_configuration_proto_rawDescGZIP(), []int{1}
}

// +kubebuilder:validation:Enum=MUTUAL_TLS_MODE_DEFAULT;MUTUAL_TLS_MODE_STRICT;MUTUAL_TLS_MODE_PERMISSIVE
// +kubebuilder:validation:Type=string
type MutualTLSMode int32

const (
	// buf:lint:ignore ENUM_ZERO_VALUE_SUFFIX
	MutualTLSMode_MUTUAL_TLS_MODE_DEFAULT    MutualTLSMode = 0
	MutualTLSMode_MUTUAL_TLS_MODE_STRICT     MutualTLSMode = 1
	MutualTLSMode_MUTUAL_TLS_MODE_PERMISSIVE MutualTLSMode = 2
)

// Enum value maps for MutualTLSMode.
var (
	MutualTLSMode_name = map[int32]string{
		0: "MUTUAL_TLS_MODE_DEFAULT",
		1: "MUTUAL_TLS_MODE_STRICT",
		2: "MUTUAL_TLS_MODE_PERMISSIVE",
	}
	MutualTLSMode_value = map[string]int32{
		"MUTUAL_TLS_MODE_DEFAULT":    0,
		"MUTUAL_TLS_MODE_STRICT":     1,
		"MUTUAL_TLS_MODE_PERMISSIVE": 2,
	}
)

func (x MutualTLSMode) Enum() *MutualTLSMode {
	p := new(MutualTLSMode)
	*p = x
	return p
}

func (x MutualTLSMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MutualTLSMode) Descriptor() protoreflect.EnumDescriptor {
	return file_pbmesh_v2beta1_proxy_configuration_proto_enumTypes[2].Descriptor()
}

func (MutualTLSMode) Type() protoreflect.EnumType {
	return &file_pbmesh_v2beta1_proxy_configuration_proto_enumTypes[2]
}

func (x MutualTLSMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MutualTLSMode.Descriptor instead.
func (MutualTLSMode) EnumDescriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_proxy_configuration_proto_rawDescGZIP(), []int{2}
}

// This is a Resource type.
type ProxyConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Selection of workloads this proxy configuration should apply to.
	// These can be prefixes or specific workload names.
	Workloads *v2beta1.WorkloadSelector `protobuf:"bytes,1,opt,name=workloads,proto3" json:"workloads,omitempty"`
	// dynamic_config is the configuration that could be changed
	// dynamically (i.e. without needing restart).
	DynamicConfig *DynamicConfig `protobuf:"bytes,2,opt,name=dynamic_config,json=dynamicConfig,proto3" json:"dynamic_config,omitempty"`
	// bootstrap_config is the configuration that requires proxies
	// to be restarted to be applied.
	BootstrapConfig *BootstrapConfig `protobuf:"bytes,3,opt,name=bootstrap_config,json=bootstrapConfig,proto3" json:"bootstrap_config,omitempty"`
	// deprecated: prevent usage when using v2 APIs directly.
	// needed for backwards compatibility
	//
	// +kubebuilder:validation:Type=object
	// +kubebuilder:validation:Schemaless
	// +kubebuilder:pruning:PreserveUnknownFields
	//
	// Deprecated: Marked as deprecated in pbmesh/v2beta1/proxy_configuration.proto.
	OpaqueConfig *structpb.Struct `protobuf:"bytes,4,opt,name=opaque_config,json=opaqueConfig,proto3" json:"opaque_config,omitempty"`
}

func (x *ProxyConfiguration) Reset() {
	*x = ProxyConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_proxy_configuration_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProxyConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProxyConfiguration) ProtoMessage() {}

func (x *ProxyConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_proxy_configuration_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProxyConfiguration.ProtoReflect.Descriptor instead.
func (*ProxyConfiguration) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_proxy_configuration_proto_rawDescGZIP(), []int{0}
}

func (x *ProxyConfiguration) GetWorkloads() *v2beta1.WorkloadSelector {
	if x != nil {
		return x.Workloads
	}
	return nil
}

func (x *ProxyConfiguration) GetDynamicConfig() *DynamicConfig {
	if x != nil {
		return x.DynamicConfig
	}
	return nil
}

func (x *ProxyConfiguration) GetBootstrapConfig() *BootstrapConfig {
	if x != nil {
		return x.BootstrapConfig
	}
	return nil
}

// Deprecated: Marked as deprecated in pbmesh/v2beta1/proxy_configuration.proto.
func (x *ProxyConfiguration) GetOpaqueConfig() *structpb.Struct {
	if x != nil {
		return x.OpaqueConfig
	}
	return nil
}

type DynamicConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// mode indicates the proxy's mode. This will default to 'transparent'.
	Mode             ProxyMode         `protobuf:"varint,1,opt,name=mode,proto3,enum=hashicorp.consul.mesh.v2beta1.ProxyMode" json:"mode,omitempty"`
	TransparentProxy *TransparentProxy `protobuf:"bytes,2,opt,name=transparent_proxy,json=transparentProxy,proto3" json:"transparent_proxy,omitempty"`
	MutualTlsMode    MutualTLSMode     `protobuf:"varint,3,opt,name=mutual_tls_mode,json=mutualTlsMode,proto3,enum=hashicorp.consul.mesh.v2beta1.MutualTLSMode" json:"mutual_tls_mode,omitempty"`
	// local_connection is the configuration that should be used
	// to connect to the local application provided per-port.
	// The map keys should correspond to port names on the workload.
	LocalConnection map[string]*ConnectionConfig `protobuf:"bytes,4,rep,name=local_connection,json=localConnection,proto3" json:"local_connection,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// inbound_connections configures inbound connections to the proxy.
	InboundConnections *InboundConnectionsConfig `protobuf:"bytes,5,opt,name=inbound_connections,json=inboundConnections,proto3" json:"inbound_connections,omitempty"`
	MeshGatewayMode    MeshGatewayMode           `protobuf:"varint,6,opt,name=mesh_gateway_mode,json=meshGatewayMode,proto3,enum=hashicorp.consul.mesh.v2beta1.MeshGatewayMode" json:"mesh_gateway_mode,omitempty"`
	ExposeConfig       *ExposeConfig             `protobuf:"bytes,7,opt,name=expose_config,json=exposeConfig,proto3" json:"expose_config,omitempty"`
	// AccessLogs configures the output and format of Envoy access logs
	AccessLogs          *AccessLogsConfig `protobuf:"bytes,8,opt,name=access_logs,json=accessLogs,proto3" json:"access_logs,omitempty"`
	PublicListenerJson  string            `protobuf:"bytes,9,opt,name=public_listener_json,json=publicListenerJson,proto3" json:"public_listener_json,omitempty"`
	ListenerTracingJson string            `protobuf:"bytes,10,opt,name=listener_tracing_json,json=listenerTracingJson,proto3" json:"listener_tracing_json,omitempty"`
	LocalClusterJson    string            `protobuf:"bytes,11,opt,name=local_cluster_json,json=localClusterJson,proto3" json:"local_cluster_json,omitempty"`
	// deprecated:
	// local_workload_address, local_workload_port, and local_workload_socket_path
	// are deprecated and are only needed for migration of existing resources.
	//
	// Deprecated: Marked as deprecated in pbmesh/v2beta1/proxy_configuration.proto.
	LocalWorkloadAddress string `protobuf:"bytes,12,opt,name=local_workload_address,json=localWorkloadAddress,proto3" json:"local_workload_address,omitempty"`
	// Deprecated: Marked as deprecated in pbmesh/v2beta1/proxy_configuration.proto.
	LocalWorkloadPort uint32 `protobuf:"varint,13,opt,name=local_workload_port,json=localWorkloadPort,proto3" json:"local_workload_port,omitempty"`
	// Deprecated: Marked as deprecated in pbmesh/v2beta1/proxy_configuration.proto.
	LocalWorkloadSocketPath string `protobuf:"bytes,14,opt,name=local_workload_socket_path,json=localWorkloadSocketPath,proto3" json:"local_workload_socket_path,omitempty"`
}

func (x *DynamicConfig) Reset() {
	*x = DynamicConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_proxy_configuration_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DynamicConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DynamicConfig) ProtoMessage() {}

func (x *DynamicConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_proxy_configuration_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DynamicConfig.ProtoReflect.Descriptor instead.
func (*DynamicConfig) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_proxy_configuration_proto_rawDescGZIP(), []int{1}
}

func (x *DynamicConfig) GetMode() ProxyMode {
	if x != nil {
		return x.Mode
	}
	return ProxyMode_PROXY_MODE_DEFAULT
}

func (x *DynamicConfig) GetTransparentProxy() *TransparentProxy {
	if x != nil {
		return x.TransparentProxy
	}
	return nil
}

func (x *DynamicConfig) GetMutualTlsMode() MutualTLSMode {
	if x != nil {
		return x.MutualTlsMode
	}
	return MutualTLSMode_MUTUAL_TLS_MODE_DEFAULT
}

func (x *DynamicConfig) GetLocalConnection() map[string]*ConnectionConfig {
	if x != nil {
		return x.LocalConnection
	}
	return nil
}

func (x *DynamicConfig) GetInboundConnections() *InboundConnectionsConfig {
	if x != nil {
		return x.InboundConnections
	}
	return nil
}

func (x *DynamicConfig) GetMeshGatewayMode() MeshGatewayMode {
	if x != nil {
		return x.MeshGatewayMode
	}
	return MeshGatewayMode_MESH_GATEWAY_MODE_UNSPECIFIED
}

func (x *DynamicConfig) GetExposeConfig() *ExposeConfig {
	if x != nil {
		return x.ExposeConfig
	}
	return nil
}

func (x *DynamicConfig) GetAccessLogs() *AccessLogsConfig {
	if x != nil {
		return x.AccessLogs
	}
	return nil
}

func (x *DynamicConfig) GetPublicListenerJson() string {
	if x != nil {
		return x.PublicListenerJson
	}
	return ""
}

func (x *DynamicConfig) GetListenerTracingJson() string {
	if x != nil {
		return x.ListenerTracingJson
	}
	return ""
}

func (x *DynamicConfig) GetLocalClusterJson() string {
	if x != nil {
		return x.LocalClusterJson
	}
	return ""
}

// Deprecated: Marked as deprecated in pbmesh/v2beta1/proxy_configuration.proto.
func (x *DynamicConfig) GetLocalWorkloadAddress() string {
	if x != nil {
		return x.LocalWorkloadAddress
	}
	return ""
}

// Deprecated: Marked as deprecated in pbmesh/v2beta1/proxy_configuration.proto.
func (x *DynamicConfig) GetLocalWorkloadPort() uint32 {
	if x != nil {
		return x.LocalWorkloadPort
	}
	return 0
}

// Deprecated: Marked as deprecated in pbmesh/v2beta1/proxy_configuration.proto.
func (x *DynamicConfig) GetLocalWorkloadSocketPath() string {
	if x != nil {
		return x.LocalWorkloadSocketPath
	}
	return ""
}

type TransparentProxy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// outbound_listener_port is the port for the proxy's outbound listener.
	// This defaults to 15001.
	OutboundListenerPort uint32 `protobuf:"varint,1,opt,name=outbound_listener_port,json=outboundListenerPort,proto3" json:"outbound_listener_port,omitempty"`
	// dialed_directly indicates whether this proxy should be dialed using original destination IP
	// in the connection rather than load balance between all endpoints.
	DialedDirectly bool `protobuf:"varint,2,opt,name=dialed_directly,json=dialedDirectly,proto3" json:"dialed_directly,omitempty"`
}

func (x *TransparentProxy) Reset() {
	*x = TransparentProxy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_proxy_configuration_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransparentProxy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransparentProxy) ProtoMessage() {}

func (x *TransparentProxy) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_proxy_configuration_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransparentProxy.ProtoReflect.Descriptor instead.
func (*TransparentProxy) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_proxy_configuration_proto_rawDescGZIP(), []int{2}
}

func (x *TransparentProxy) GetOutboundListenerPort() uint32 {
	if x != nil {
		return x.OutboundListenerPort
	}
	return 0
}

func (x *TransparentProxy) GetDialedDirectly() bool {
	if x != nil {
		return x.DialedDirectly
	}
	return false
}

// BootstrapConfig is equivalent to configuration defined
// in our docs.
type BootstrapConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	StatsdUrl                       string   `protobuf:"bytes,1,opt,name=statsd_url,json=statsdUrl,proto3" json:"statsd_url,omitempty"`
	DogstatsdUrl                    string   `protobuf:"bytes,2,opt,name=dogstatsd_url,json=dogstatsdUrl,proto3" json:"dogstatsd_url,omitempty"`
	StatsTags                       []string `protobuf:"bytes,3,rep,name=stats_tags,json=statsTags,proto3" json:"stats_tags,omitempty"`
	PrometheusBindAddr              string   `protobuf:"bytes,4,opt,name=prometheus_bind_addr,json=prometheusBindAddr,proto3" json:"prometheus_bind_addr,omitempty"`
	StatsBindAddr                   string   `protobuf:"bytes,5,opt,name=stats_bind_addr,json=statsBindAddr,proto3" json:"stats_bind_addr,omitempty"`
	ReadyBindAddr                   string   `protobuf:"bytes,6,opt,name=ready_bind_addr,json=readyBindAddr,proto3" json:"ready_bind_addr,omitempty"`
	OverrideJsonTpl                 string   `protobuf:"bytes,7,opt,name=override_json_tpl,json=overrideJsonTpl,proto3" json:"override_json_tpl,omitempty"`
	StaticClustersJson              string   `protobuf:"bytes,8,opt,name=static_clusters_json,json=staticClustersJson,proto3" json:"static_clusters_json,omitempty"`
	StaticListenersJson             string   `protobuf:"bytes,9,opt,name=static_listeners_json,json=staticListenersJson,proto3" json:"static_listeners_json,omitempty"`
	StatsSinksJson                  string   `protobuf:"bytes,10,opt,name=stats_sinks_json,json=statsSinksJson,proto3" json:"stats_sinks_json,omitempty"`
	StatsConfigJson                 string   `protobuf:"bytes,11,opt,name=stats_config_json,json=statsConfigJson,proto3" json:"stats_config_json,omitempty"`
	StatsFlushInterval              string   `protobuf:"bytes,12,opt,name=stats_flush_interval,json=statsFlushInterval,proto3" json:"stats_flush_interval,omitempty"`
	TracingConfigJson               string   `protobuf:"bytes,13,opt,name=tracing_config_json,json=tracingConfigJson,proto3" json:"tracing_config_json,omitempty"`
	TelemetryCollectorBindSocketDir string   `protobuf:"bytes,14,opt,name=telemetry_collector_bind_socket_dir,json=telemetryCollectorBindSocketDir,proto3" json:"telemetry_collector_bind_socket_dir,omitempty"`
}

func (x *BootstrapConfig) Reset() {
	*x = BootstrapConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_proxy_configuration_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BootstrapConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BootstrapConfig) ProtoMessage() {}

func (x *BootstrapConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_proxy_configuration_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BootstrapConfig.ProtoReflect.Descriptor instead.
func (*BootstrapConfig) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_proxy_configuration_proto_rawDescGZIP(), []int{3}
}

func (x *BootstrapConfig) GetStatsdUrl() string {
	if x != nil {
		return x.StatsdUrl
	}
	return ""
}

func (x *BootstrapConfig) GetDogstatsdUrl() string {
	if x != nil {
		return x.DogstatsdUrl
	}
	return ""
}

func (x *BootstrapConfig) GetStatsTags() []string {
	if x != nil {
		return x.StatsTags
	}
	return nil
}

func (x *BootstrapConfig) GetPrometheusBindAddr() string {
	if x != nil {
		return x.PrometheusBindAddr
	}
	return ""
}

func (x *BootstrapConfig) GetStatsBindAddr() string {
	if x != nil {
		return x.StatsBindAddr
	}
	return ""
}

func (x *BootstrapConfig) GetReadyBindAddr() string {
	if x != nil {
		return x.ReadyBindAddr
	}
	return ""
}

func (x *BootstrapConfig) GetOverrideJsonTpl() string {
	if x != nil {
		return x.OverrideJsonTpl
	}
	return ""
}

func (x *BootstrapConfig) GetStaticClustersJson() string {
	if x != nil {
		return x.StaticClustersJson
	}
	return ""
}

func (x *BootstrapConfig) GetStaticListenersJson() string {
	if x != nil {
		return x.StaticListenersJson
	}
	return ""
}

func (x *BootstrapConfig) GetStatsSinksJson() string {
	if x != nil {
		return x.StatsSinksJson
	}
	return ""
}

func (x *BootstrapConfig) GetStatsConfigJson() string {
	if x != nil {
		return x.StatsConfigJson
	}
	return ""
}

func (x *BootstrapConfig) GetStatsFlushInterval() string {
	if x != nil {
		return x.StatsFlushInterval
	}
	return ""
}

func (x *BootstrapConfig) GetTracingConfigJson() string {
	if x != nil {
		return x.TracingConfigJson
	}
	return ""
}

func (x *BootstrapConfig) GetTelemetryCollectorBindSocketDir() string {
	if x != nil {
		return x.TelemetryCollectorBindSocketDir
	}
	return ""
}

// AccessLogsConfig contains the associated default settings for all Envoy
// instances within the datacenter or partition
type AccessLogsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Enabled turns off all access logging
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// DisableListenerLogs turns off just listener logs for connections rejected by Envoy because they don't
	// have a matching listener filter.
	DisableListenerLogs bool `protobuf:"varint,2,opt,name=disable_listener_logs,json=disableListenerLogs,proto3" json:"disable_listener_logs,omitempty"`
	// Type selects the output for logs: "file", "stderr". "stdout"
	Type LogSinkType `protobuf:"varint,3,opt,name=type,proto3,enum=hashicorp.consul.mesh.v2beta1.LogSinkType" json:"type,omitempty"`
	// Path is the output file to write logs
	Path string `protobuf:"bytes,4,opt,name=path,proto3" json:"path,omitempty"`
	// The presence of one format string or the other implies the access log string encoding.
	// Defining both is invalid.
	JsonFormat string `protobuf:"bytes,5,opt,name=json_format,json=jsonFormat,proto3" json:"json_format,omitempty"`
	TextFormat string `protobuf:"bytes,6,opt,name=text_format,json=textFormat,proto3" json:"text_format,omitempty"`
}

func (x *AccessLogsConfig) Reset() {
	*x = AccessLogsConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_proxy_configuration_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessLogsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessLogsConfig) ProtoMessage() {}

func (x *AccessLogsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_proxy_configuration_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessLogsConfig.ProtoReflect.Descriptor instead.
func (*AccessLogsConfig) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_proxy_configuration_proto_rawDescGZIP(), []int{4}
}

func (x *AccessLogsConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *AccessLogsConfig) GetDisableListenerLogs() bool {
	if x != nil {
		return x.DisableListenerLogs
	}
	return false
}

func (x *AccessLogsConfig) GetType() LogSinkType {
	if x != nil {
		return x.Type
	}
	return LogSinkType_LOG_SINK_TYPE_DEFAULT
}

func (x *AccessLogsConfig) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *AccessLogsConfig) GetJsonFormat() string {
	if x != nil {
		return x.JsonFormat
	}
	return ""
}

func (x *AccessLogsConfig) GetTextFormat() string {
	if x != nil {
		return x.TextFormat
	}
	return ""
}

// EnvoyExtension has configuration for an extension that patches Envoy resources.
type EnvoyExtension struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name     string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Required bool   `protobuf:"varint,2,opt,name=required,proto3" json:"required,omitempty"`
	// +kubebuilder:validation:Type=object
	// +kubebuilder:validation:Schemaless
	// +kubebuilder:pruning:PreserveUnknownFields
	Arguments     *structpb.Struct `protobuf:"bytes,3,opt,name=arguments,proto3" json:"arguments,omitempty"`
	ConsulVersion string           `protobuf:"bytes,4,opt,name=consul_version,json=consulVersion,proto3" json:"consul_version,omitempty"`
	EnvoyVersion  string           `protobuf:"bytes,5,opt,name=envoy_version,json=envoyVersion,proto3" json:"envoy_version,omitempty"`
}

func (x *EnvoyExtension) Reset() {
	*x = EnvoyExtension{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_proxy_configuration_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnvoyExtension) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnvoyExtension) ProtoMessage() {}

func (x *EnvoyExtension) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_proxy_configuration_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnvoyExtension.ProtoReflect.Descriptor instead.
func (*EnvoyExtension) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_proxy_configuration_proto_rawDescGZIP(), []int{5}
}

func (x *EnvoyExtension) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EnvoyExtension) GetRequired() bool {
	if x != nil {
		return x.Required
	}
	return false
}

func (x *EnvoyExtension) GetArguments() *structpb.Struct {
	if x != nil {
		return x.Arguments
	}
	return nil
}

func (x *EnvoyExtension) GetConsulVersion() string {
	if x != nil {
		return x.ConsulVersion
	}
	return ""
}

func (x *EnvoyExtension) GetEnvoyVersion() string {
	if x != nil {
		return x.EnvoyVersion
	}
	return ""
}

var File_pbmesh_v2beta1_proxy_configuration_proto protoreflect.FileDescriptor

var file_pbmesh_v2beta1_proxy_configuration_proto_rawDesc = []byte{
	0x0a, 0x28, 0x70, 0x62, 0x6d, 0x65, 0x73, 0x68, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x68, 0x61, 0x73, 0x68,
	0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73,
	0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x70, 0x62, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x65, 0x6c, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x70, 0x62, 0x6d, 0x65, 0x73,
	0x68, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x70, 0x62, 0x6d, 0x65,
	0x73, 0x68, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x65, 0x78, 0x70, 0x6f, 0x73,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x70, 0x62, 0x6d, 0x65, 0x73, 0x68, 0x2f,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x70, 0x62, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xe0, 0x02, 0x0a, 0x12, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x09, 0x77, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e,
	0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c,
	0x2e, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x52, 0x09, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x12, 0x53, 0x0a, 0x0e,
	0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70,
	0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x0d, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x59, 0x0a, 0x10, 0x62, 0x6f, 0x6f, 0x74, 0x73, 0x74, 0x72, 0x61, 0x70, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x68, 0x61,
	0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d,
	0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x6f, 0x6f, 0x74,
	0x73, 0x74, 0x72, 0x61, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0f, 0x62, 0x6f, 0x6f,
	0x74, 0x73, 0x74, 0x72, 0x61, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x40, 0x0a, 0x0d,
	0x6f, 0x70, 0x61, 0x71, 0x75, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x0c, 0x6f, 0x70, 0x61, 0x71, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x3a, 0x06,
	0xa2, 0x93, 0x04, 0x02, 0x08, 0x03, 0x22, 0x91, 0x09, 0x0a, 0x0d, 0x44, 0x79, 0x6e, 0x61, 0x6d,
	0x69, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3c, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f,
	0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x4d, 0x6f, 0x64, 0x65,
	0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x12, 0x5c, 0x0a, 0x11, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f,
	0x78, 0x79, 0x52, 0x10, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x50,
	0x72, 0x6f, 0x78, 0x79, 0x12, 0x54, 0x0a, 0x0f, 0x6d, 0x75, 0x74, 0x75, 0x61, 0x6c, 0x5f, 0x74,
	0x6c, 0x73, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e,
	0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c,
	0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x75,
	0x74, 0x75, 0x61, 0x6c, 0x54, 0x4c, 0x53, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x0d, 0x6d, 0x75, 0x74,
	0x75, 0x61, 0x6c, 0x54, 0x6c, 0x73, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x6c, 0x0a, 0x10, 0x6c, 0x6f,
	0x63, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70,
	0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0f, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x68, 0x0a, 0x13, 0x69, 0x6e, 0x62, 0x6f,
	0x75, 0x6e, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72,
	0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x12,
	0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x5a, 0x0a, 0x11, 0x6d, 0x65, 0x73, 0x68, 0x5f, 0x67, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e,
	0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c,
	0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x65,
	0x73, 0x68, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x0f, 0x6d,
	0x65, 0x73, 0x68, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x50,
	0x0a, 0x0d, 0x65, 0x78, 0x70, 0x6f, 0x73, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72,
	0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x0c, 0x65, 0x78, 0x70, 0x6f, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x50, 0x0a, 0x0b, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72,
	0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x6f, 0x67, 0x73,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0a, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x6f,
	0x67, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6c, 0x69, 0x73,
	0x74, 0x65, 0x6e, 0x65, 0x72, 0x5f, 0x6a, 0x73, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x12, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72,
	0x4a, 0x73, 0x6f, 0x6e, 0x12, 0x32, 0x0a, 0x15, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72,
	0x5f, 0x74, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x6a, 0x73, 0x6f, 0x6e, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x13, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x54, 0x72, 0x61,
	0x63, 0x69, 0x6e, 0x67, 0x4a, 0x73, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x12, 0x6c, 0x6f, 0x63, 0x61,
	0x6c, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6a, 0x73, 0x6f, 0x6e, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x4a, 0x73, 0x6f, 0x6e, 0x12, 0x38, 0x0a, 0x16, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f,
	0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x14, 0x6c, 0x6f, 0x63, 0x61,
	0x6c, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x12, 0x32, 0x0a, 0x13, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x11, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x50, 0x6f, 0x72, 0x74, 0x12, 0x3f, 0x0a, 0x1a, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x77, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x73, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x70, 0x61,
	0x74, 0x68, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x17, 0x6c, 0x6f,
	0x63, 0x61, 0x6c, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x6f, 0x63, 0x6b, 0x65,
	0x74, 0x50, 0x61, 0x74, 0x68, 0x1a, 0x73, 0x0a, 0x14, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x45, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x71, 0x0a, 0x10, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x12, 0x34,
	0x0a, 0x16, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x65,
	0x6e, 0x65, 0x72, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x14,
	0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72,
	0x50, 0x6f, 0x72, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x64, 0x69, 0x61, 0x6c, 0x65, 0x64, 0x5f, 0x64,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x64,
	0x69, 0x61, 0x6c, 0x65, 0x64, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6c, 0x79, 0x22, 0x8e, 0x05,
	0x0a, 0x0f, 0x42, 0x6f, 0x6f, 0x74, 0x73, 0x74, 0x72, 0x61, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x73, 0x64, 0x5f, 0x75, 0x72, 0x6c, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x74, 0x61, 0x74, 0x73, 0x64, 0x55, 0x72, 0x6c,
	0x12, 0x23, 0x0a, 0x0d, 0x64, 0x6f, 0x67, 0x73, 0x74, 0x61, 0x74, 0x73, 0x64, 0x5f, 0x75, 0x72,
	0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x64, 0x6f, 0x67, 0x73, 0x74, 0x61, 0x74,
	0x73, 0x64, 0x55, 0x72, 0x6c, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x73, 0x5f, 0x74,
	0x61, 0x67, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x73, 0x74, 0x61, 0x74, 0x73,
	0x54, 0x61, 0x67, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65,
	0x75, 0x73, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x12, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x42, 0x69,
	0x6e, 0x64, 0x41, 0x64, 0x64, 0x72, 0x12, 0x26, 0x0a, 0x0f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x5f,
	0x62, 0x69, 0x6e, 0x64, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x73, 0x74, 0x61, 0x74, 0x73, 0x42, 0x69, 0x6e, 0x64, 0x41, 0x64, 0x64, 0x72, 0x12, 0x26,
	0x0a, 0x0f, 0x72, 0x65, 0x61, 0x64, 0x79, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x5f, 0x61, 0x64, 0x64,
	0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x72, 0x65, 0x61, 0x64, 0x79, 0x42, 0x69,
	0x6e, 0x64, 0x41, 0x64, 0x64, 0x72, 0x12, 0x2a, 0x0a, 0x11, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69,
	0x64, 0x65, 0x5f, 0x6a, 0x73, 0x6f, 0x6e, 0x5f, 0x74, 0x70, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0f, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x4a, 0x73, 0x6f, 0x6e, 0x54,
	0x70, 0x6c, 0x12, 0x30, 0x0a, 0x14, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x73, 0x5f, 0x6a, 0x73, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x12, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73,
	0x4a, 0x73, 0x6f, 0x6e, 0x12, 0x32, 0x0a, 0x15, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x6c,
	0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x73, 0x5f, 0x6a, 0x73, 0x6f, 0x6e, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x13, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x4c, 0x69, 0x73, 0x74, 0x65,
	0x6e, 0x65, 0x72, 0x73, 0x4a, 0x73, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x10, 0x73, 0x74, 0x61, 0x74,
	0x73, 0x5f, 0x73, 0x69, 0x6e, 0x6b, 0x73, 0x5f, 0x6a, 0x73, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x73, 0x53, 0x69, 0x6e, 0x6b, 0x73, 0x4a, 0x73,
	0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x11, 0x73, 0x74, 0x61, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x5f, 0x6a, 0x73, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x73,
	0x74, 0x61, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4a, 0x73, 0x6f, 0x6e, 0x12, 0x30,
	0x0a, 0x14, 0x73, 0x74, 0x61, 0x74, 0x73, 0x5f, 0x66, 0x6c, 0x75, 0x73, 0x68, 0x5f, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x73, 0x74,
	0x61, 0x74, 0x73, 0x46, 0x6c, 0x75, 0x73, 0x68, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c,
	0x12, 0x2e, 0x0a, 0x13, 0x74, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x5f, 0x6a, 0x73, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x74,
	0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4a, 0x73, 0x6f, 0x6e,
	0x12, 0x4c, 0x0a, 0x23, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f,
	0x6c, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x5f, 0x73, 0x6f, 0x63,
	0x6b, 0x65, 0x74, 0x5f, 0x64, 0x69, 0x72, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1f, 0x74,
	0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x42, 0x69, 0x6e, 0x64, 0x53, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x44, 0x69, 0x72, 0x22, 0xf6,
	0x01, 0x0a, 0x10, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x32, 0x0a,
	0x15, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65,
	0x72, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x64, 0x69,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x4c, 0x6f, 0x67,
	0x73, 0x12, 0x3e, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2a, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73,
	0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4c, 0x6f, 0x67, 0x53, 0x69, 0x6e, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x1f, 0x0a, 0x0b, 0x6a, 0x73, 0x6f, 0x6e, 0x5f, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6a, 0x73, 0x6f, 0x6e,
	0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x74, 0x65, 0x78,
	0x74, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x22, 0xc3, 0x01, 0x0a, 0x0e, 0x45, 0x6e, 0x76, 0x6f,
	0x79, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1a,
	0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x12, 0x35, 0x0a, 0x09, 0x61, 0x72,
	0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x09, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x6e, 0x76, 0x6f,
	0x79, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x2a, 0x56, 0x0a,
	0x09, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x16, 0x0a, 0x12, 0x50, 0x52,
	0x4f, 0x58, 0x59, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54,
	0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16, 0x50, 0x52, 0x4f, 0x58, 0x59, 0x5f, 0x4d, 0x4f, 0x44, 0x45,
	0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x50, 0x41, 0x52, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x15,
	0x0a, 0x11, 0x50, 0x52, 0x4f, 0x58, 0x59, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x44, 0x49, 0x52,
	0x45, 0x43, 0x54, 0x10, 0x02, 0x2a, 0x74, 0x0a, 0x0b, 0x4c, 0x6f, 0x67, 0x53, 0x69, 0x6e, 0x6b,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x4c, 0x4f, 0x47, 0x5f, 0x53, 0x49, 0x4e, 0x4b,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x00, 0x12,
	0x16, 0x0a, 0x12, 0x4c, 0x4f, 0x47, 0x5f, 0x53, 0x49, 0x4e, 0x4b, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x46, 0x49, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x4c, 0x4f, 0x47, 0x5f, 0x53,
	0x49, 0x4e, 0x4b, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x54, 0x44, 0x45, 0x52, 0x52, 0x10,
	0x02, 0x12, 0x18, 0x0a, 0x14, 0x4c, 0x4f, 0x47, 0x5f, 0x53, 0x49, 0x4e, 0x4b, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x53, 0x54, 0x44, 0x4f, 0x55, 0x54, 0x10, 0x03, 0x2a, 0x68, 0x0a, 0x0d, 0x4d,
	0x75, 0x74, 0x75, 0x61, 0x6c, 0x54, 0x4c, 0x53, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x1b, 0x0a, 0x17,
	0x4d, 0x55, 0x54, 0x55, 0x41, 0x4c, 0x5f, 0x54, 0x4c, 0x53, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f,
	0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16, 0x4d, 0x55, 0x54,
	0x55, 0x41, 0x4c, 0x5f, 0x54, 0x4c, 0x53, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x53, 0x54, 0x52,
	0x49, 0x43, 0x54, 0x10, 0x01, 0x12, 0x1e, 0x0a, 0x1a, 0x4d, 0x55, 0x54, 0x55, 0x41, 0x4c, 0x5f,
	0x54, 0x4c, 0x53, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53,
	0x49, 0x56, 0x45, 0x10, 0x02, 0x42, 0x98, 0x02, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x68, 0x61,
	0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d,
	0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x17, 0x50, 0x72, 0x6f,
	0x78, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2f, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2d, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63,
	0x2f, 0x70, 0x62, 0x6d, 0x65, 0x73, 0x68, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x3b,
	0x6d, 0x65, 0x73, 0x68, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0xa2, 0x02, 0x03, 0x48, 0x43,
	0x4d, 0xaa, 0x02, 0x1d, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x43, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x4d, 0x65, 0x73, 0x68, 0x2e, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0xca, 0x02, 0x1d, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x5c, 0x43, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x5c, 0x4d, 0x65, 0x73, 0x68, 0x5c, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0xe2, 0x02, 0x29, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x5c, 0x43, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x5c, 0x4d, 0x65, 0x73, 0x68, 0x5c, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x5c, 0x47, 0x50, 0x42, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xea, 0x02, 0x20,
	0x48, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x3a, 0x3a, 0x43, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x3a, 0x3a, 0x4d, 0x65, 0x73, 0x68, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_pbmesh_v2beta1_proxy_configuration_proto_rawDescOnce sync.Once
	file_pbmesh_v2beta1_proxy_configuration_proto_rawDescData = file_pbmesh_v2beta1_proxy_configuration_proto_rawDesc
)

func file_pbmesh_v2beta1_proxy_configuration_proto_rawDescGZIP() []byte {
	file_pbmesh_v2beta1_proxy_configuration_proto_rawDescOnce.Do(func() {
		file_pbmesh_v2beta1_proxy_configuration_proto_rawDescData = protoimpl.X.CompressGZIP(file_pbmesh_v2beta1_proxy_configuration_proto_rawDescData)
	})
	return file_pbmesh_v2beta1_proxy_configuration_proto_rawDescData
}

var file_pbmesh_v2beta1_proxy_configuration_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_pbmesh_v2beta1_proxy_configuration_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_pbmesh_v2beta1_proxy_configuration_proto_goTypes = []interface{}{
	(ProxyMode)(0),                   // 0: hashicorp.consul.mesh.v2beta1.ProxyMode
	(LogSinkType)(0),                 // 1: hashicorp.consul.mesh.v2beta1.LogSinkType
	(MutualTLSMode)(0),               // 2: hashicorp.consul.mesh.v2beta1.MutualTLSMode
	(*ProxyConfiguration)(nil),       // 3: hashicorp.consul.mesh.v2beta1.ProxyConfiguration
	(*DynamicConfig)(nil),            // 4: hashicorp.consul.mesh.v2beta1.DynamicConfig
	(*TransparentProxy)(nil),         // 5: hashicorp.consul.mesh.v2beta1.TransparentProxy
	(*BootstrapConfig)(nil),          // 6: hashicorp.consul.mesh.v2beta1.BootstrapConfig
	(*AccessLogsConfig)(nil),         // 7: hashicorp.consul.mesh.v2beta1.AccessLogsConfig
	(*EnvoyExtension)(nil),           // 8: hashicorp.consul.mesh.v2beta1.EnvoyExtension
	nil,                              // 9: hashicorp.consul.mesh.v2beta1.DynamicConfig.LocalConnectionEntry
	(*v2beta1.WorkloadSelector)(nil), // 10: hashicorp.consul.catalog.v2beta1.WorkloadSelector
	(*structpb.Struct)(nil),          // 11: google.protobuf.Struct
	(*InboundConnectionsConfig)(nil), // 12: hashicorp.consul.mesh.v2beta1.InboundConnectionsConfig
	(MeshGatewayMode)(0),             // 13: hashicorp.consul.mesh.v2beta1.MeshGatewayMode
	(*ExposeConfig)(nil),             // 14: hashicorp.consul.mesh.v2beta1.ExposeConfig
	(*ConnectionConfig)(nil),         // 15: hashicorp.consul.mesh.v2beta1.ConnectionConfig
}
var file_pbmesh_v2beta1_proxy_configuration_proto_depIdxs = []int32{
	10, // 0: hashicorp.consul.mesh.v2beta1.ProxyConfiguration.workloads:type_name -> hashicorp.consul.catalog.v2beta1.WorkloadSelector
	4,  // 1: hashicorp.consul.mesh.v2beta1.ProxyConfiguration.dynamic_config:type_name -> hashicorp.consul.mesh.v2beta1.DynamicConfig
	6,  // 2: hashicorp.consul.mesh.v2beta1.ProxyConfiguration.bootstrap_config:type_name -> hashicorp.consul.mesh.v2beta1.BootstrapConfig
	11, // 3: hashicorp.consul.mesh.v2beta1.ProxyConfiguration.opaque_config:type_name -> google.protobuf.Struct
	0,  // 4: hashicorp.consul.mesh.v2beta1.DynamicConfig.mode:type_name -> hashicorp.consul.mesh.v2beta1.ProxyMode
	5,  // 5: hashicorp.consul.mesh.v2beta1.DynamicConfig.transparent_proxy:type_name -> hashicorp.consul.mesh.v2beta1.TransparentProxy
	2,  // 6: hashicorp.consul.mesh.v2beta1.DynamicConfig.mutual_tls_mode:type_name -> hashicorp.consul.mesh.v2beta1.MutualTLSMode
	9,  // 7: hashicorp.consul.mesh.v2beta1.DynamicConfig.local_connection:type_name -> hashicorp.consul.mesh.v2beta1.DynamicConfig.LocalConnectionEntry
	12, // 8: hashicorp.consul.mesh.v2beta1.DynamicConfig.inbound_connections:type_name -> hashicorp.consul.mesh.v2beta1.InboundConnectionsConfig
	13, // 9: hashicorp.consul.mesh.v2beta1.DynamicConfig.mesh_gateway_mode:type_name -> hashicorp.consul.mesh.v2beta1.MeshGatewayMode
	14, // 10: hashicorp.consul.mesh.v2beta1.DynamicConfig.expose_config:type_name -> hashicorp.consul.mesh.v2beta1.ExposeConfig
	7,  // 11: hashicorp.consul.mesh.v2beta1.DynamicConfig.access_logs:type_name -> hashicorp.consul.mesh.v2beta1.AccessLogsConfig
	1,  // 12: hashicorp.consul.mesh.v2beta1.AccessLogsConfig.type:type_name -> hashicorp.consul.mesh.v2beta1.LogSinkType
	11, // 13: hashicorp.consul.mesh.v2beta1.EnvoyExtension.arguments:type_name -> google.protobuf.Struct
	15, // 14: hashicorp.consul.mesh.v2beta1.DynamicConfig.LocalConnectionEntry.value:type_name -> hashicorp.consul.mesh.v2beta1.ConnectionConfig
	15, // [15:15] is the sub-list for method output_type
	15, // [15:15] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_pbmesh_v2beta1_proxy_configuration_proto_init() }
func file_pbmesh_v2beta1_proxy_configuration_proto_init() {
	if File_pbmesh_v2beta1_proxy_configuration_proto != nil {
		return
	}
	file_pbmesh_v2beta1_connection_proto_init()
	file_pbmesh_v2beta1_expose_proto_init()
	file_pbmesh_v2beta1_routing_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_pbmesh_v2beta1_proxy_configuration_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProxyConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_proxy_configuration_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DynamicConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_proxy_configuration_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransparentProxy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_proxy_configuration_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BootstrapConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_proxy_configuration_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccessLogsConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_proxy_configuration_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnvoyExtension); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_pbmesh_v2beta1_proxy_configuration_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_pbmesh_v2beta1_proxy_configuration_proto_goTypes,
		DependencyIndexes: file_pbmesh_v2beta1_proxy_configuration_proto_depIdxs,
		EnumInfos:         file_pbmesh_v2beta1_proxy_configuration_proto_enumTypes,
		MessageInfos:      file_pbmesh_v2beta1_proxy_configuration_proto_msgTypes,
	}.Build()
	File_pbmesh_v2beta1_proxy_configuration_proto = out.File
	file_pbmesh_v2beta1_proxy_configuration_proto_rawDesc = nil
	file_pbmesh_v2beta1_proxy_configuration_proto_goTypes = nil
	file_pbmesh_v2beta1_proxy_configuration_proto_depIdxs = nil
}
