% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{MeshesDifference}
\alias{MeshesDifference}
\title{Meshes difference}
\usage{
MeshesDifference(mesh1, mesh2, clean = TRUE, normals = FALSE)
}
\arguments{
\item{mesh1, mesh2}{two meshes, each being given as either a
\strong{rgl} mesh, or a list with (at least) two fields:
\code{vertices} and \code{faces}; the \code{vertices} matrix can be
a numeric matrix or a matrix of \code{bigq} rational numbers (from the
\strong{gmp} package)}

\item{clean}{Boolean, whether to clean the meshes (merging duplicated
vertices, duplicated faces, removing isolated vertices); set to
\code{FALSE} if you know your meshes are clean}

\item{normals}{Boolean, whether to return the per-vertex normals of the
output mesh}
}
\value{
A triangle mesh given as a list with fields \code{vertices},
  \code{faces}, \code{edges}, \code{exteriorEdges}, \code{gmpvertices}
  if using \strong{gmp} meshes, and \code{normals} if \code{normals=TRUE}.
}
\description{
Computes the difference between two meshes.
}
\examples{
library(Boov)
library(rgl)

# mesh one: a cube
mesh1 <- cube3d() # (from the rgl package)

# mesh two: another cube
mesh2 <- translate3d( # (from the rgl package)
  cube3d(), 1, 1, 0
)

# compute the difference
differ <- MeshesDifference(mesh1, mesh2)

# plot
rgldiffer <- toRGL(differ)
open3d(windowRect = c(50, 50, 562, 562))
shade3d(mesh1, color = "yellow", alpha = 0.2)
shade3d(mesh2, color = "cyan", alpha = 0.2)
shade3d(rgldiffer, color = "red")
plotEdges(
  vertices = differ[["vertices"]], edges = differ[["exteriorEdges"]],
  edgesAsTubes = TRUE, verticesAsSpheres = TRUE
)
}
