% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixednum.R
\name{model.fixednum}
\alias{model.fixednum}
\title{Estimate the location of change-points when the number of them is fixed}
\usage{
model.fixednum(cptpath.object, fixednum = NULL)
}
\arguments{
\item{cptpath.object}{A solution-path object, returned by a \code{sol.[name]} routine. Note that the field \code{cptpath.object$x} contains the input data sequence.}

\item{fixednum}{The number of change-points or change-point-type features}
}
\value{
An S3 object of class \code{cptmodel}, which contains the following fields: 
\item{solution.path}{The solution path method used to obtain \code{cptpath.object}}
\item{type}{The model type used, inherited from the given \code{cptpath.object}}
\item{model.selection}{The model selection method used to return the final change-point or change-point-type feature estimators object, here its value is \code{"ic"}}
\item{no.of.cpt}{The number of estimated features in the mean of the vector \code{cptpath.object$x} based on the given \code{type} of the model}
\item{cpts}{The locations of estimated features in the mean of the vector \code{cptpath.object$x}. These are the end-points of the corresponding constant-mean or constant-slope intervals}
\item{est}{An estimate of the mean of the vector \code{cptpath.object$x}; for piecewise-constant signals, the values are the sample means of the data (replicated a suitable number of times) between each pair of consecutive detected change-points; 
for piecewise-linear but discontinuous signals, the values are the estimated linear trend (replicated a suitable number of times) between each pair of consecutive detected change of slopes; 
for piecewise-linear and continuous signals, it is similar to the previous case but with the continuity constraint enforced, which envolves solving a global least squares problem.}
}
\description{
Return a solution with the given number of change-points or change-point-type features from the solution path
}
\details{
The model selection method which returns results with a given number of change-points or change-point-type features. If there are 
multiple such elements on the solution path, the one with the smaller residual sum of squares will be returned. On the other hand,
if no such element exists, an empty set (i.e. with no change-points) will be returned.
}
\examples{
x <- c(rep(0, 100), rep(1, 100), rep(0, 100)) + rnorm(300)
model.fixednum(sol.wbs(x),2)
model.fixednum(sol.not(x),2)
}
\seealso{
\code{\link{sol.idetect}}, \code{\link{sol.not}}, \code{\link{sol.tguh}}, \code{\link{sol.wbs}}, \code{\link{sol.wbs2}}, \code{\link{sol.wcm}}, \code{\link{breakfast}}
}
