% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_stats_anova.R
\name{ard_stats_anova}
\alias{ard_stats_anova}
\alias{ard_stats_anova.anova}
\alias{ard_stats_anova.data.frame}
\title{ARD ANOVA}
\usage{
ard_stats_anova(x, ...)

\method{ard_stats_anova}{anova}(x, method_text = "ANOVA results from `stats::anova()`", ...)

\method{ard_stats_anova}{data.frame}(
  x,
  formulas,
  method,
  method.args = list(),
  package = "base",
  method_text = "ANOVA results from `stats::anova()`",
  ...
)
}
\arguments{
\item{x}{(\code{anova} or \code{data.frame})\cr
an object of class \code{'anova'} created with \code{stats::anova()} or
a data frame}

\item{...}{These dots are for future extensions and must be empty.}

\item{method_text}{(\code{string})\cr
string of the method used. Default is \verb{"ANOVA results from }stats::anova()\verb{"}.
We provide the option to change this as \code{stats::anova()} can produce
results from many types of models that may warrant a more precise
description.}

\item{formulas}{(\code{list})\cr
a list of formulas}

\item{method}{(\code{string})\cr
string of function naming the function to be called, e.g. \code{"glm"}.
If function belongs to a library that is not attached, the package name
must be specified in the \code{package} argument.}

\item{method.args}{(named \code{list})\cr
named list of arguments that will be passed to \code{method}.

Note that this list may contain non-standard evaluation components.
If you are wrapping this function in other functions, the argument
must be passed in a way that does not evaluate the list, e.g.
using rlang's  embrace operator \code{{{ . }}}.}

\item{package}{(\code{string})\cr
string of package name that will be temporarily loaded when function
specified in \code{method} is executed.}
}
\value{
ARD data frame
}
\description{
Prepare ANOVA results from the \code{stats::anova()} function.
Users may pass a pre-calculated \code{stats::anova()} object or a list of
formulas. In the latter case, the models will be constructed using the
information passed and models will be passed to \code{stats::anova()}.
}
\details{
When a list of formulas is supplied to \code{ard_stats_anova()}, these formulas
along with information from other arguments, are used to construct models
and pass those models to \code{stats::anova()}.

The models are constructed using \code{rlang::exec()}, which is similar to \code{do.call()}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{rlang::exec(.fn = method, formula = formula, data = data, !!!method.args)
}\if{html}{\out{</div>}}

The above function is executed in \code{withr::with_namespace(package)}, which
allows for the use of \code{ard_stats_anova(method)} from packages,
e.g. \code{package = 'lme4'} must be specified when \code{method = 'glmer'}.
See example below.
}
\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = c("broom", "withr", "lme4"), reference_pkg = "cardx"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
anova(
  lm(mpg ~ am, mtcars),
  lm(mpg ~ am + hp, mtcars)
) |>
  ard_stats_anova()

ard_stats_anova(
  x = mtcars,
  formulas = list(am ~ mpg, am ~ mpg + hp),
  method = "glm",
  method.args = list(family = binomial)
)

ard_stats_anova(
  x = mtcars,
  formulas = list(am ~ 1 + (1 | vs), am ~ mpg + (1 | vs)),
  method = "glmer",
  method.args = list(family = binomial),
  package = "lme4"
)
\dontshow{\}) # examplesIf}
}
