/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 4.14.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

/*
 * SWGDeviceListItem.h
 *
 * Summarized information about attached hardware device
 */

#ifndef SWGDeviceListItem_H_
#define SWGDeviceListItem_H_

#include <QJsonObject>


#include <QString>

#include "SWGObject.h"
#include "export.h"

namespace SWGSDRangel {

class SWG_API SWGDeviceListItem: public SWGObject {
public:
    SWGDeviceListItem();
    SWGDeviceListItem(QString* json);
    virtual ~SWGDeviceListItem();
    void init();
    void cleanup();

    virtual QString asJson () override;
    virtual QJsonObject* asJsonObject() override;
    virtual void fromJsonObject(QJsonObject &json) override;
    virtual SWGDeviceListItem* fromJson(QString &jsonString) override;

    QString* getDisplayedName();
    void setDisplayedName(QString* displayed_name);

    QString* getHwType();
    void setHwType(QString* hw_type);

    QString* getSerial();
    void setSerial(QString* serial);

    qint32 getSequence();
    void setSequence(qint32 sequence);

    qint32 getDirection();
    void setDirection(qint32 direction);

    qint32 getDeviceNbStreams();
    void setDeviceNbStreams(qint32 device_nb_streams);

    qint32 getDeviceStreamIndex();
    void setDeviceStreamIndex(qint32 device_stream_index);

    qint32 getDeviceSetIndex();
    void setDeviceSetIndex(qint32 device_set_index);

    qint32 getIndex();
    void setIndex(qint32 index);


    virtual bool isSet() override;

private:
    QString* displayed_name;
    bool m_displayed_name_isSet;

    QString* hw_type;
    bool m_hw_type_isSet;

    QString* serial;
    bool m_serial_isSet;

    qint32 sequence;
    bool m_sequence_isSet;

    qint32 direction;
    bool m_direction_isSet;

    qint32 device_nb_streams;
    bool m_device_nb_streams_isSet;

    qint32 device_stream_index;
    bool m_device_stream_index_isSet;

    qint32 device_set_index;
    bool m_device_set_index_isSet;

    qint32 index;
    bool m_index_isSet;

};

}

#endif /* SWGDeviceListItem_H_ */
