///////////////////////////////////////////////////////////////////////////////////
// Copyright (C) 2020 Edouard Griffiths, F4EXB                                   //
//                                                                               //
// This program is free software; you can redistribute it and/or modify          //
// it under the terms of the GNU General Public License as published by          //
// the Free Software Foundation as version 3 of the License, or                  //
// (at your option) any later version.                                           //
//                                                                               //
// This program is distributed in the hope that it will be useful,               //
// but WITHOUT ANY WARRANTY; without even the implied warranty of                //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the                  //
// GNU General Public License V3 for more details.                               //
//                                                                               //
// You should have received a copy of the GNU General Public License             //
// along with this program. If not, see <http://www.gnu.org/licenses/>.          //
///////////////////////////////////////////////////////////////////////////////////

#ifndef INCLUDE_FEATURE_AFCSETTINGS_H_
#define INCLUDE_FEATURE_AFCSETTINGS_H_

#include <QByteArray>
#include <QString>

class Serializable;

struct AFCSettings
{
    QString m_title;
    quint32 m_rgbColor;
    int m_trackerDeviceSetIndex; //!< will take the first instance of freq tracker in the list of channels
    int m_trackedDeviceSetIndex;
    bool m_hasTargetFrequency;
    bool m_transverterTarget;
    quint64 m_targetFrequency;
    quint64 m_freqTolerance;
    unsigned int m_trackerAdjustPeriod; //!< tracker channel frequency adjustment period in seconds
    bool m_useReverseAPI;
    QString m_reverseAPIAddress;
    uint16_t m_reverseAPIPort;
    uint16_t m_reverseAPIFeatureSetIndex;
    uint16_t m_reverseAPIFeatureIndex;

    AFCSettings();
    void resetToDefaults();
    QByteArray serialize() const;
    bool deserialize(const QByteArray& data);
};

#endif // INCLUDE_FEATURE_AFCSETTINGS_H_
