/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGHeatMapSettings.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGHeatMapSettings::SWGHeatMapSettings(QString* json) {
    init();
    this->fromJson(*json);
}

SWGHeatMapSettings::SWGHeatMapSettings() {
    input_frequency_offset = 0L;
    m_input_frequency_offset_isSet = false;
    rf_bandwidth = 0.0f;
    m_rf_bandwidth_isSet = false;
    min_power = 0.0f;
    m_min_power_isSet = false;
    max_power = 0.0f;
    m_max_power_isSet = false;
    color_map_name = nullptr;
    m_color_map_name_isSet = false;
    mode = 0;
    m_mode_isSet = false;
    pulse_threshold = 0.0f;
    m_pulse_threshold_isSet = false;
    average_period_us = 0;
    m_average_period_us_isSet = false;
    sample_rate = 0;
    m_sample_rate_isSet = false;
    rgb_color = 0;
    m_rgb_color_isSet = false;
    title = nullptr;
    m_title_isSet = false;
    stream_index = 0;
    m_stream_index_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = nullptr;
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    reverse_api_device_index = 0;
    m_reverse_api_device_index_isSet = false;
    reverse_api_channel_index = 0;
    m_reverse_api_channel_index_isSet = false;
    scope_config = nullptr;
    m_scope_config_isSet = false;
    channel_marker = nullptr;
    m_channel_marker_isSet = false;
    rollup_state = nullptr;
    m_rollup_state_isSet = false;
}

SWGHeatMapSettings::~SWGHeatMapSettings() {
    this->cleanup();
}

void
SWGHeatMapSettings::init() {
    input_frequency_offset = 0L;
    m_input_frequency_offset_isSet = false;
    rf_bandwidth = 0.0f;
    m_rf_bandwidth_isSet = false;
    min_power = 0.0f;
    m_min_power_isSet = false;
    max_power = 0.0f;
    m_max_power_isSet = false;
    color_map_name = new QString("");
    m_color_map_name_isSet = false;
    mode = 0;
    m_mode_isSet = false;
    pulse_threshold = 0.0f;
    m_pulse_threshold_isSet = false;
    average_period_us = 0;
    m_average_period_us_isSet = false;
    sample_rate = 0;
    m_sample_rate_isSet = false;
    rgb_color = 0;
    m_rgb_color_isSet = false;
    title = new QString("");
    m_title_isSet = false;
    stream_index = 0;
    m_stream_index_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = new QString("");
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    reverse_api_device_index = 0;
    m_reverse_api_device_index_isSet = false;
    reverse_api_channel_index = 0;
    m_reverse_api_channel_index_isSet = false;
    scope_config = new SWGGLScope();
    m_scope_config_isSet = false;
    channel_marker = new SWGChannelMarker();
    m_channel_marker_isSet = false;
    rollup_state = new SWGRollupState();
    m_rollup_state_isSet = false;
}

void
SWGHeatMapSettings::cleanup() {




    if(color_map_name != nullptr) { 
        delete color_map_name;
    }





    if(title != nullptr) { 
        delete title;
    }


    if(reverse_api_address != nullptr) { 
        delete reverse_api_address;
    }



    if(scope_config != nullptr) { 
        delete scope_config;
    }
    if(channel_marker != nullptr) { 
        delete channel_marker;
    }
    if(rollup_state != nullptr) { 
        delete rollup_state;
    }
}

SWGHeatMapSettings*
SWGHeatMapSettings::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGHeatMapSettings::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&input_frequency_offset, pJson["inputFrequencyOffset"], "qint64", "");
    
    ::SWGSDRangel::setValue(&rf_bandwidth, pJson["rfBandwidth"], "float", "");
    
    ::SWGSDRangel::setValue(&min_power, pJson["minPower"], "float", "");
    
    ::SWGSDRangel::setValue(&max_power, pJson["maxPower"], "float", "");
    
    ::SWGSDRangel::setValue(&color_map_name, pJson["colorMapName"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&mode, pJson["mode"], "qint32", "");
    
    ::SWGSDRangel::setValue(&pulse_threshold, pJson["pulseThreshold"], "float", "");
    
    ::SWGSDRangel::setValue(&average_period_us, pJson["averagePeriodUS"], "qint32", "");
    
    ::SWGSDRangel::setValue(&sample_rate, pJson["sampleRate"], "qint32", "");
    
    ::SWGSDRangel::setValue(&rgb_color, pJson["rgbColor"], "qint32", "");
    
    ::SWGSDRangel::setValue(&title, pJson["title"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&stream_index, pJson["streamIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&use_reverse_api, pJson["useReverseAPI"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_address, pJson["reverseAPIAddress"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&reverse_api_port, pJson["reverseAPIPort"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_device_index, pJson["reverseAPIDeviceIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_channel_index, pJson["reverseAPIChannelIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&scope_config, pJson["scopeConfig"], "SWGGLScope", "SWGGLScope");
    
    ::SWGSDRangel::setValue(&channel_marker, pJson["channelMarker"], "SWGChannelMarker", "SWGChannelMarker");
    
    ::SWGSDRangel::setValue(&rollup_state, pJson["rollupState"], "SWGRollupState", "SWGRollupState");
    
}

QString
SWGHeatMapSettings::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGHeatMapSettings::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_input_frequency_offset_isSet){
        obj->insert("inputFrequencyOffset", QJsonValue(input_frequency_offset));
    }
    if(m_rf_bandwidth_isSet){
        obj->insert("rfBandwidth", QJsonValue(rf_bandwidth));
    }
    if(m_min_power_isSet){
        obj->insert("minPower", QJsonValue(min_power));
    }
    if(m_max_power_isSet){
        obj->insert("maxPower", QJsonValue(max_power));
    }
    if(color_map_name != nullptr && *color_map_name != QString("")){
        toJsonValue(QString("colorMapName"), color_map_name, obj, QString("QString"));
    }
    if(m_mode_isSet){
        obj->insert("mode", QJsonValue(mode));
    }
    if(m_pulse_threshold_isSet){
        obj->insert("pulseThreshold", QJsonValue(pulse_threshold));
    }
    if(m_average_period_us_isSet){
        obj->insert("averagePeriodUS", QJsonValue(average_period_us));
    }
    if(m_sample_rate_isSet){
        obj->insert("sampleRate", QJsonValue(sample_rate));
    }
    if(m_rgb_color_isSet){
        obj->insert("rgbColor", QJsonValue(rgb_color));
    }
    if(title != nullptr && *title != QString("")){
        toJsonValue(QString("title"), title, obj, QString("QString"));
    }
    if(m_stream_index_isSet){
        obj->insert("streamIndex", QJsonValue(stream_index));
    }
    if(m_use_reverse_api_isSet){
        obj->insert("useReverseAPI", QJsonValue(use_reverse_api));
    }
    if(reverse_api_address != nullptr && *reverse_api_address != QString("")){
        toJsonValue(QString("reverseAPIAddress"), reverse_api_address, obj, QString("QString"));
    }
    if(m_reverse_api_port_isSet){
        obj->insert("reverseAPIPort", QJsonValue(reverse_api_port));
    }
    if(m_reverse_api_device_index_isSet){
        obj->insert("reverseAPIDeviceIndex", QJsonValue(reverse_api_device_index));
    }
    if(m_reverse_api_channel_index_isSet){
        obj->insert("reverseAPIChannelIndex", QJsonValue(reverse_api_channel_index));
    }
    if((scope_config != nullptr) && (scope_config->isSet())){
        toJsonValue(QString("scopeConfig"), scope_config, obj, QString("SWGGLScope"));
    }
    if((channel_marker != nullptr) && (channel_marker->isSet())){
        toJsonValue(QString("channelMarker"), channel_marker, obj, QString("SWGChannelMarker"));
    }
    if((rollup_state != nullptr) && (rollup_state->isSet())){
        toJsonValue(QString("rollupState"), rollup_state, obj, QString("SWGRollupState"));
    }

    return obj;
}

qint64
SWGHeatMapSettings::getInputFrequencyOffset() {
    return input_frequency_offset;
}
void
SWGHeatMapSettings::setInputFrequencyOffset(qint64 input_frequency_offset) {
    this->input_frequency_offset = input_frequency_offset;
    this->m_input_frequency_offset_isSet = true;
}

float
SWGHeatMapSettings::getRfBandwidth() {
    return rf_bandwidth;
}
void
SWGHeatMapSettings::setRfBandwidth(float rf_bandwidth) {
    this->rf_bandwidth = rf_bandwidth;
    this->m_rf_bandwidth_isSet = true;
}

float
SWGHeatMapSettings::getMinPower() {
    return min_power;
}
void
SWGHeatMapSettings::setMinPower(float min_power) {
    this->min_power = min_power;
    this->m_min_power_isSet = true;
}

float
SWGHeatMapSettings::getMaxPower() {
    return max_power;
}
void
SWGHeatMapSettings::setMaxPower(float max_power) {
    this->max_power = max_power;
    this->m_max_power_isSet = true;
}

QString*
SWGHeatMapSettings::getColorMapName() {
    return color_map_name;
}
void
SWGHeatMapSettings::setColorMapName(QString* color_map_name) {
    this->color_map_name = color_map_name;
    this->m_color_map_name_isSet = true;
}

qint32
SWGHeatMapSettings::getMode() {
    return mode;
}
void
SWGHeatMapSettings::setMode(qint32 mode) {
    this->mode = mode;
    this->m_mode_isSet = true;
}

float
SWGHeatMapSettings::getPulseThreshold() {
    return pulse_threshold;
}
void
SWGHeatMapSettings::setPulseThreshold(float pulse_threshold) {
    this->pulse_threshold = pulse_threshold;
    this->m_pulse_threshold_isSet = true;
}

qint32
SWGHeatMapSettings::getAveragePeriodUs() {
    return average_period_us;
}
void
SWGHeatMapSettings::setAveragePeriodUs(qint32 average_period_us) {
    this->average_period_us = average_period_us;
    this->m_average_period_us_isSet = true;
}

qint32
SWGHeatMapSettings::getSampleRate() {
    return sample_rate;
}
void
SWGHeatMapSettings::setSampleRate(qint32 sample_rate) {
    this->sample_rate = sample_rate;
    this->m_sample_rate_isSet = true;
}

qint32
SWGHeatMapSettings::getRgbColor() {
    return rgb_color;
}
void
SWGHeatMapSettings::setRgbColor(qint32 rgb_color) {
    this->rgb_color = rgb_color;
    this->m_rgb_color_isSet = true;
}

QString*
SWGHeatMapSettings::getTitle() {
    return title;
}
void
SWGHeatMapSettings::setTitle(QString* title) {
    this->title = title;
    this->m_title_isSet = true;
}

qint32
SWGHeatMapSettings::getStreamIndex() {
    return stream_index;
}
void
SWGHeatMapSettings::setStreamIndex(qint32 stream_index) {
    this->stream_index = stream_index;
    this->m_stream_index_isSet = true;
}

qint32
SWGHeatMapSettings::getUseReverseApi() {
    return use_reverse_api;
}
void
SWGHeatMapSettings::setUseReverseApi(qint32 use_reverse_api) {
    this->use_reverse_api = use_reverse_api;
    this->m_use_reverse_api_isSet = true;
}

QString*
SWGHeatMapSettings::getReverseApiAddress() {
    return reverse_api_address;
}
void
SWGHeatMapSettings::setReverseApiAddress(QString* reverse_api_address) {
    this->reverse_api_address = reverse_api_address;
    this->m_reverse_api_address_isSet = true;
}

qint32
SWGHeatMapSettings::getReverseApiPort() {
    return reverse_api_port;
}
void
SWGHeatMapSettings::setReverseApiPort(qint32 reverse_api_port) {
    this->reverse_api_port = reverse_api_port;
    this->m_reverse_api_port_isSet = true;
}

qint32
SWGHeatMapSettings::getReverseApiDeviceIndex() {
    return reverse_api_device_index;
}
void
SWGHeatMapSettings::setReverseApiDeviceIndex(qint32 reverse_api_device_index) {
    this->reverse_api_device_index = reverse_api_device_index;
    this->m_reverse_api_device_index_isSet = true;
}

qint32
SWGHeatMapSettings::getReverseApiChannelIndex() {
    return reverse_api_channel_index;
}
void
SWGHeatMapSettings::setReverseApiChannelIndex(qint32 reverse_api_channel_index) {
    this->reverse_api_channel_index = reverse_api_channel_index;
    this->m_reverse_api_channel_index_isSet = true;
}

SWGGLScope*
SWGHeatMapSettings::getScopeConfig() {
    return scope_config;
}
void
SWGHeatMapSettings::setScopeConfig(SWGGLScope* scope_config) {
    this->scope_config = scope_config;
    this->m_scope_config_isSet = true;
}

SWGChannelMarker*
SWGHeatMapSettings::getChannelMarker() {
    return channel_marker;
}
void
SWGHeatMapSettings::setChannelMarker(SWGChannelMarker* channel_marker) {
    this->channel_marker = channel_marker;
    this->m_channel_marker_isSet = true;
}

SWGRollupState*
SWGHeatMapSettings::getRollupState() {
    return rollup_state;
}
void
SWGHeatMapSettings::setRollupState(SWGRollupState* rollup_state) {
    this->rollup_state = rollup_state;
    this->m_rollup_state_isSet = true;
}


bool
SWGHeatMapSettings::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_input_frequency_offset_isSet){
            isObjectUpdated = true; break;
        }
        if(m_rf_bandwidth_isSet){
            isObjectUpdated = true; break;
        }
        if(m_min_power_isSet){
            isObjectUpdated = true; break;
        }
        if(m_max_power_isSet){
            isObjectUpdated = true; break;
        }
        if(color_map_name && *color_map_name != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_mode_isSet){
            isObjectUpdated = true; break;
        }
        if(m_pulse_threshold_isSet){
            isObjectUpdated = true; break;
        }
        if(m_average_period_us_isSet){
            isObjectUpdated = true; break;
        }
        if(m_sample_rate_isSet){
            isObjectUpdated = true; break;
        }
        if(m_rgb_color_isSet){
            isObjectUpdated = true; break;
        }
        if(title && *title != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_stream_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_use_reverse_api_isSet){
            isObjectUpdated = true; break;
        }
        if(reverse_api_address && *reverse_api_address != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_port_isSet){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_device_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_channel_index_isSet){
            isObjectUpdated = true; break;
        }
        if(scope_config && scope_config->isSet()){
            isObjectUpdated = true; break;
        }
        if(channel_marker && channel_marker->isSet()){
            isObjectUpdated = true; break;
        }
        if(rollup_state && rollup_state->isSet()){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

