/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

/*
 * SWGVORLocalizerSettings.h
 *
 * VORLocalizer
 */

#ifndef SWGVORLocalizerSettings_H_
#define SWGVORLocalizerSettings_H_

#include <QJsonObject>


#include "SWGRollupState.h"
#include <QList>
#include <QString>

#include "SWGObject.h"
#include "export.h"

namespace SWGSDRangel {

class SWG_API SWGVORLocalizerSettings: public SWGObject {
public:
    SWGVORLocalizerSettings();
    SWGVORLocalizerSettings(QString* json);
    virtual ~SWGVORLocalizerSettings();
    void init();
    void cleanup();

    virtual QString asJson () override;
    virtual QJsonObject* asJsonObject() override;
    virtual void fromJsonObject(QJsonObject &json) override;
    virtual SWGVORLocalizerSettings* fromJson(QString &jsonString) override;

    qint32 getRgbColor();
    void setRgbColor(qint32 rgb_color);

    QString* getTitle();
    void setTitle(QString* title);

    qint32 getUseReverseApi();
    void setUseReverseApi(qint32 use_reverse_api);

    QString* getReverseApiAddress();
    void setReverseApiAddress(QString* reverse_api_address);

    qint32 getReverseApiPort();
    void setReverseApiPort(qint32 reverse_api_port);

    qint32 getReverseApiFeatureSetIndex();
    void setReverseApiFeatureSetIndex(qint32 reverse_api_feature_set_index);

    qint32 getReverseApiFeatureIndex();
    void setReverseApiFeatureIndex(qint32 reverse_api_feature_index);

    qint32 getMagDecAdjust();
    void setMagDecAdjust(qint32 mag_dec_adjust);

    qint32 getRrTime();
    void setRrTime(qint32 rr_time);

    qint32 getForceRrAveraging();
    void setForceRrAveraging(qint32 force_rr_averaging);

    qint32 getCenterShift();
    void setCenterShift(qint32 center_shift);

    SWGRollupState* getRollupState();
    void setRollupState(SWGRollupState* rollup_state);

    QList<qint32>* getColumnIndexes();
    void setColumnIndexes(QList<qint32>* column_indexes);

    QList<qint32>* getColumnSizes();
    void setColumnSizes(QList<qint32>* column_sizes);


    virtual bool isSet() override;

private:
    qint32 rgb_color;
    bool m_rgb_color_isSet;

    QString* title;
    bool m_title_isSet;

    qint32 use_reverse_api;
    bool m_use_reverse_api_isSet;

    QString* reverse_api_address;
    bool m_reverse_api_address_isSet;

    qint32 reverse_api_port;
    bool m_reverse_api_port_isSet;

    qint32 reverse_api_feature_set_index;
    bool m_reverse_api_feature_set_index_isSet;

    qint32 reverse_api_feature_index;
    bool m_reverse_api_feature_index_isSet;

    qint32 mag_dec_adjust;
    bool m_mag_dec_adjust_isSet;

    qint32 rr_time;
    bool m_rr_time_isSet;

    qint32 force_rr_averaging;
    bool m_force_rr_averaging_isSet;

    qint32 center_shift;
    bool m_center_shift_isSet;

    SWGRollupState* rollup_state;
    bool m_rollup_state_isSet;

    QList<qint32>* column_indexes;
    bool m_column_indexes_isSet;

    QList<qint32>* column_sizes;
    bool m_column_sizes_isSet;

};

}

#endif /* SWGVORLocalizerSettings_H_ */
