INCLUDE(FindPkgConfig)
PKG_CHECK_MODULES(PC_LZ4 "liblz4")

FIND_PATH(LZ4_INCLUDE_DIRS
    NAMES lz4.h
    HINTS ${PC_LZ4_INCLUDE_DIR}
          ${CMAKE_INSTALL_PREFIX}/include
          ${LIBLZ4_INSTALL_PREFIX}/include
    PATHS /usr/local/include
          /usr/include
)

FIND_LIBRARY(LZ4_LIBRARIES
    NAMES lz4 liblz4
    HINTS ${PC_LZ4_LIBDIR}
          ${CMAKE_INSTALL_PREFIX}/lib
          ${CMAKE_INSTALL_PREFIX}/lib64
    PATHS ${LZ4_INCLUDE_DIRS}/../lib
          /usr/local/lib
          /usr/lib
)

if (LZ4_LIBRARIES AND LZ4_INCLUDE_DIRS)
    set(LIBLZ4_FOUND TRUE CACHE INTERNAL "liblz4 found")
    message(STATUS "Found liblz4: ${LZ4_INCLUDE_DIRS}, ${LZ4_LIBRARIES}")
else (LZ4_LIBRARIES AND LZ4_INCLUDE_DIRS)
    set(LIBLZ4_FOUND FALSE CACHE INTERNAL "liblz4 found")
    message(STATUS "liblz4 not found")
endif (LZ4_LIBRARIES AND LZ4_INCLUDE_DIRS)

INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(LZ4 DEFAULT_MSG LZ4_LIBRARIES LZ4_INCLUDE_DIRS)
MARK_AS_ADVANCED(LZ4_LIBRARIES LZ4_INCLUDE_DIRS)
