require "spec"
require "crystal/compiler_rt/shift"
require "./spec_helper"

# Ported from https://github.com/llvm/llvm-project/blob/ce59ccd04023cab3a837da14079ca2dcbfebb70c/compiler-rt/test/builtins/Unit/lshrti3_test.c

it ".__lshrti3" do
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 0).should eq make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 1).should eq make_ti(0x7F6E5D4C3B2A190A, 0xFF6E5D4C3B2A190A)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 2).should eq make_ti(0x3FB72EA61D950C85, 0x7FB72EA61D950C85)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 3).should eq make_ti(0x1FDB97530ECA8642, 0xBFDB97530ECA8642)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 4).should eq make_ti(0x0FEDCBA987654321, 0x5FEDCBA987654321)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 28).should eq make_ti(0x0000000FEDCBA987, 0x6543215FEDCBA987)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 29).should eq make_ti(0x00000007F6E5D4C3, 0xB2A190AFF6E5D4C3)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 30).should eq make_ti(0x00000003FB72EA61, 0xD950C857FB72EA61)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 31).should eq make_ti(0x00000001FDB97530, 0xECA8642BFDB97530)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 32).should eq make_ti(0x00000000FEDCBA98, 0x76543215FEDCBA98)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 33).should eq make_ti(0x000000007F6E5D4C, 0x3B2A190AFF6E5D4C)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 34).should eq make_ti(0x000000003FB72EA6, 0x1D950C857FB72EA6)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 35).should eq make_ti(0x000000001FDB9753, 0x0ECA8642BFDB9753)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 36).should eq make_ti(0x000000000FEDCBA9, 0x876543215FEDCBA9)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 60).should eq make_ti(0x000000000000000F, 0xEDCBA9876543215F)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 61).should eq make_ti(0x0000000000000007, 0xF6E5D4C3B2A190AF)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 62).should eq make_ti(0x0000000000000003, 0xFB72EA61D950C857)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 63).should eq make_ti(0x0000000000000001, 0xFDB97530ECA8642B)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 64).should eq make_ti(0x0000000000000000, 0xFEDCBA9876543215)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 65).should eq make_ti(0x0000000000000000, 0x7F6E5D4C3B2A190A)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 66).should eq make_ti(0x0000000000000000, 0x3FB72EA61D950C85)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 67).should eq make_ti(0x0000000000000000, 0x1FDB97530ECA8642)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 68).should eq make_ti(0x0000000000000000, 0x0FEDCBA987654321)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 92).should eq make_ti(0x0000000000000000, 0x0000000FEDCBA987)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 93).should eq make_ti(0x0000000000000000, 0x00000007F6E5D4C3)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 94).should eq make_ti(0x0000000000000000, 0x00000003FB72EA61)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 95).should eq make_ti(0x0000000000000000, 0x00000001FDB97530)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 96).should eq make_ti(0x0000000000000000, 0x00000000FEDCBA98)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 97).should eq make_ti(0x0000000000000000, 0x000000007F6E5D4C)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 98).should eq make_ti(0x0000000000000000, 0x000000003FB72EA6)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 99).should eq make_ti(0x0000000000000000, 0x000000001FDB9753)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 100).should eq make_ti(0x0000000000000000, 0x000000000FEDCBA9)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 124).should eq make_ti(0x0000000000000000, 0x000000000000000F)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 125).should eq make_ti(0x0000000000000000, 0x0000000000000007)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 126).should eq make_ti(0x0000000000000000, 0x0000000000000003)
  __lshrti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 127).should eq make_ti(0x0000000000000000, 0x0000000000000001)
end
