/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class ByteNumberFormat
extends NumberFormat {
    private static final long serialVersionUID = 1L;
    public static final Unit[] UNITS = Unit.values();
    private static final DecimalFormat fpFormat = new DecimalFormat("#.#");
    private boolean useLongUnitNames = false;

    public static int computeIndex(double bytes) {
        int index = 0;
        int i = 0;
        while (i < UNITS.length) {
            int result = (int)(bytes / 1024.0);
            if (result == 0 || (bytes /= 1024.0) < 1.0) break;
            ++index;
            ++i;
        }
        return index;
    }

    public String getBytes(double bytes) {
        double intBytes;
        int index = ByteNumberFormat.computeIndex(bytes);
        if (index >= UNITS.length) {
            index = UNITS.length - 1;
        }
        if ((intBytes = bytes) == 0.0) {
            return String.valueOf(0);
        }
        int i = 0;
        while (i < index) {
            intBytes /= 1024.0;
            ++i;
        }
        String str = (long)intBytes >= 10L ? String.valueOf((long)intBytes) : fpFormat.format(intBytes);
        Unit unit = UNITS[index];
        return String.valueOf(str) + (this.useLongUnitNames ? unit.fullName : unit.shortName);
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        return toAppendTo.append(this.getBytes(number));
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        return toAppendTo.append(this.getBytes(number));
    }

    @Override
    public Number parse(String source, ParsePosition parsePosition) {
        return null;
    }

    public void setUseLongUnitNames(boolean useLongUnitNames) {
        this.useLongUnitNames = useLongUnitNames;
    }

    private static enum Unit {
        BYTE("B", "B"),
        KILOBYTE("K", "KiB"),
        MEGABYTE("M", "MiB"),
        GIGABYTE("G", "GiB"),
        TERABYTE("T", "TiB"),
        PETABYTE("P", "PiB");

        private final String shortName;
        private final String fullName;

        private Unit(String shortName, String fullName) {
            this.shortName = shortName;
            this.fullName = fullName;
        }
    }
}

