/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.views.session;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchSite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSession;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.DatabaseLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.navigator.itemlist.DatabaseObjectListControl;
import org.jkiss.dbeaver.ui.navigator.itemlist.ObjectListControl;

class SessionTable<SESSION_TYPE extends DBAServerSession>
extends DatabaseObjectListControl<SESSION_TYPE> {
    private static final Log log = Log.getLog(SessionTable.class);
    private DBAServerSessionManager<SESSION_TYPE> sessionManager;
    private static IStructuredContentProvider CONTENT_PROVIDER = new IStructuredContentProvider(){

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    };

    SessionTable(Composite parent, int style, IWorkbenchSite site, DBAServerSessionManager<SESSION_TYPE> sessionManager) {
        super(parent, style, site, (IContentProvider)CONTENT_PROVIDER);
        this.sessionManager = sessionManager;
    }

    public DBAServerSessionManager<SESSION_TYPE> getSessionManager() {
        return this.sessionManager;
    }

    @NotNull
    protected String getListConfigId(List<Class<?>> classList) {
        return "Sessions/" + this.sessionManager.getDataSource().getContainer().getDriver().getId();
    }

    protected LoadingJob<Collection<SESSION_TYPE>> createLoadService(boolean forUpdate) {
        return LoadingJob.createService((ILoadService)new LoadSessionsService(), (ILoadVisualizer)new ObjectListControl.ObjectsLoadVisualizer((ObjectListControl)this));
    }

    LoadingJob<Void> createAlterService(List<SESSION_TYPE> sessions, Map<String, Object> options) {
        return LoadingJob.createService((ILoadService)new KillSessionsService(sessions, options), (ILoadVisualizer)new ObjectListControl.ObjectActionVisualizer((ObjectListControl)this));
    }

    public void init(DBAServerSessionManager<SESSION_TYPE> sessionManager) {
        this.sessionManager = sessionManager;
    }

    protected Map<String, Object> getSessionOptions() {
        return null;
    }

    private class KillSessionsService
    extends DatabaseLoadService<Void> {
        private final List<SESSION_TYPE> sessions;
        private final Map<String, Object> options;

        KillSessionsService(List<SESSION_TYPE> sessions, Map<String, Object> options) {
            super("Kill session", SessionTable.this.sessionManager.getDataSource());
            this.sessions = sessions;
            this.options = options;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public Void evaluate(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (DBCExecutionContext isolatedContext = SessionTable.this.sessionManager.getDataSource().getDefaultInstance().openIsolatedContext(monitor, "View sessions", null);){
                    block25: {
                        Throwable throwable2 = null;
                        Object var6_10 = null;
                        DBCSession session = isolatedContext.openSession(monitor, DBCExecutionPurpose.UTIL, "Kill server session");
                        try {
                            Exception lastError = null;
                            for (DBAServerSession dbaSession : this.sessions) {
                                try {
                                    SessionTable.this.sessionManager.alterSession(session, dbaSession, this.options);
                                }
                                catch (Exception e) {
                                    log.error((Object)("Error killing session " + session), (Throwable)e);
                                    lastError = e;
                                }
                            }
                            if (lastError != null) {
                                throw new InvocationTargetException(lastError);
                            }
                            if (session == null) break block25;
                        }
                        catch (Throwable throwable3) {
                            try {
                                if (session != null) {
                                    session.close();
                                }
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (throwable2 == null) {
                                    throwable2 = throwable4;
                                } else if (throwable2 != throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                throw throwable2;
                            }
                        }
                        session.close();
                    }
                    return null;
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable;
                }
            }
            catch (Throwable ex) {
                throw new InvocationTargetException(ex);
            }
        }
    }

    class LoadSessionsService
    extends DatabaseLoadService<Collection<SESSION_TYPE>> {
        LoadSessionsService() {
            super("Load sessions", SessionTable.this.sessionManager.getDataSource());
        }

        /*
         * Loose catch block
         */
        public Collection<SESSION_TYPE> evaluate(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (DBCExecutionContext isolatedContext = SessionTable.this.sessionManager.getDataSource().getDefaultInstance().openIsolatedContext(monitor, "View sessions", null);){
                    Collection collection;
                    DBCSession session;
                    Throwable throwable2;
                    block21: {
                        throwable2 = null;
                        Object var6_10 = null;
                        session = isolatedContext.openSession(monitor, DBCExecutionPurpose.UTIL, "Retrieve server sessions");
                        collection = SessionTable.this.sessionManager.getSessions(session, SessionTable.this.getSessionOptions());
                        if (session == null) break block21;
                        session.close();
                    }
                    return collection;
                    {
                        catch (Throwable throwable3) {
                            try {
                                if (session != null) {
                                    session.close();
                                }
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (throwable2 == null) {
                                    throwable2 = throwable4;
                                } else if (throwable2 != throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                throw throwable2;
                            }
                        }
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable;
                }
            }
            catch (Throwable ex) {
                throw new InvocationTargetException(ex);
            }
        }
    }
}

