/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.variables;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.SubEditorSite;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class AssignVariableAction
extends Action {
    protected static final Log log = Log.getLog(AssignVariableAction.class);
    private final SQLEditor editor;
    private final String queryText;
    private boolean isQuery = false;
    private boolean isEditable = true;
    private boolean checkDuplicates = true;
    private SQLEditorBase valueEditor;
    private String varValue;

    public AssignVariableAction(SQLEditor editor, String varValue) {
        super(SQLEditorMessages.action_result_tabs_assign_variable);
        this.editor = editor;
        this.queryText = varValue;
    }

    public void setQuery(boolean query) {
        this.isQuery = query;
    }

    public void setEditable(boolean editable) {
        this.isEditable = editable;
    }

    public void setCheckDuplicates(boolean checkDuplicates) {
        this.checkDuplicates = checkDuplicates;
    }

    public void run() {
        EnterNameDialog dialog = new EnterNameDialog(this.editor.getEditorControlWrapper().getShell(), this.isQuery ? SQLEditorMessages.action_result_tabs_assign_variable_sql : SQLEditorMessages.action_result_tabs_assign_variable, ""){

            protected IDialogSettings getDialogBoundsSettings() {
                return UIUtils.getDialogSettings((String)"DBeaver.SQLEditor.AssignVariableDialog");
            }

            protected Composite createDialogArea(Composite parent) {
                Composite area = super.createDialogArea(parent);
                AssignVariableAction.this.valueEditor = new SQLEditorBase(){

                    @Nullable
                    public DBCExecutionContext getExecutionContext() {
                        return (this).AssignVariableAction.this.editor.getExecutionContext();
                    }
                };
                try {
                    AssignVariableAction.this.valueEditor.init((IEditorSite)new SubEditorSite(AssignVariableAction.this.editor.getSite()), (IEditorInput)new StringEditorInput("Variable value", (CharSequence)AssignVariableAction.this.queryText, !AssignVariableAction.this.isEditable, GeneralUtils.getDefaultFileEncoding()));
                }
                catch (PartInitException e) {
                    log.error((Object)e);
                }
                Composite editorPH = UIUtils.createComposite((Composite)area, (int)1);
                editorPH.setLayoutData((Object)new GridData(1808));
                UIUtils.createControlLabel((Composite)editorPH, (String)(AssignVariableAction.this.isQuery ? "Query" : "Value"));
                AssignVariableAction.this.valueEditor.createPartControl(editorPH);
                AssignVariableAction.this.valueEditor.getEditorControlWrapper().setLayoutData(new GridData(1808));
                AssignVariableAction.this.valueEditor.setWordWrap(true);
                AssignVariableAction.this.valueEditor.reloadSyntaxRules();
                UIUtils.asyncExec(() -> {
                    boolean bl = this.propNameText.setFocus();
                });
                return area;
            }

            protected void okPressed() {
                if (AssignVariableAction.this.checkDuplicates) {
                    String varName = this.propNameText.getText();
                    if (AssignVariableAction.this.editor.getGlobalScriptContext().hasVariable(varName)) {
                        UIUtils.showMessageBox((Shell)this.getShell(), (String)"Duplicate variable", (String)("Variable '" + varName + "' already declared"), (int)1);
                        return;
                    }
                }
                AssignVariableAction.this.varValue = AssignVariableAction.this.valueEditor.getEditorControl().getText();
                super.okPressed();
            }
        };
        if (dialog.open() == 0) {
            this.editor.getGlobalScriptContext().setVariable(dialog.getResult(), (Object)this.varValue);
        }
    }
}

