/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model.security;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.exasol.ExasolUserType;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.security.ExasolGrantee;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.access.DBAUser;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.utils.CommonUtils;

public class ExasolUser
extends ExasolGrantee
implements DBAUser,
DBPSaveableObject,
DBPNamedObject2,
DBPRefreshableObject {
    private String userName;
    private String description;
    private String dn;
    private String password;
    private Timestamp created;
    private String kerberosPrincipal;
    private String passwordState;
    private String passwordStateChanged;
    private Timestamp passwordExpiry;
    private BigDecimal passwordExpiryDays;
    private BigDecimal passwordExpiryGrace;
    private String passwordExpiryPolicy;
    private BigDecimal failedLoginAttempts;
    private Boolean locked;
    private ExasolUserType type;

    public ExasolUser(ExasolDataSource dataSource, ResultSet resultSet) {
        super(dataSource, resultSet);
        if (resultSet != null) {
            this.userName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"USER_NAME");
            this.description = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"USER_COMMENT");
            this.dn = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"DISTINGUISHED_NAME");
            this.password = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"PASSWORD");
            this.created = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"CREATED");
            this.kerberosPrincipal = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"KERBEROS_PRINCIPAL");
            this.passwordState = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"PASSWORD_STATE");
            this.passwordStateChanged = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"PASSWORD_STATE_CHANGED");
            this.passwordExpiry = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"PASSWORD_EXPIRY");
            this.passwordExpiryDays = JDBCUtils.safeGetBigDecimal((ResultSet)resultSet, (String)"PASSWORD_EXPIRY_DAYS");
            this.passwordExpiryGrace = JDBCUtils.safeGetBigDecimal((ResultSet)resultSet, (String)"PASSWORD_GRACE_DAYS");
            this.passwordExpiryPolicy = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"PASSWORD_EXPIRY_POLICY");
            this.failedLoginAttempts = JDBCUtils.safeGetBigDecimal((ResultSet)resultSet, (String)"FAILED_LOGIN_ATTEMPTS");
            this.type = CommonUtils.isEmpty((String)this.kerberosPrincipal) & CommonUtils.isEmpty((String)this.dn) ? ExasolUserType.LOCAL : (CommonUtils.isEmpty((String)this.kerberosPrincipal) ? ExasolUserType.LDAP : ExasolUserType.KERBEROS);
            this.locked = this.passwordState != null && this.passwordState.equals("EXPIRED") ? Boolean.valueOf(true) : Boolean.valueOf(false);
        } else {
            this.userName = "user";
            this.description = "";
            this.dn = "";
            this.password = "";
            this.created = null;
            this.kerberosPrincipal = "";
            this.type = ExasolUserType.LOCAL;
        }
    }

    @Property(viewable=true, updatable=true, editable=true, order=35)
    public String getKerberosPrincipal() {
        return this.kerberosPrincipal;
    }

    public void setKerberosPrincipal(String kerberosPrincipal) {
        this.kerberosPrincipal = kerberosPrincipal;
        this.password = null;
        this.dn = null;
        this.type = ExasolUserType.KERBEROS;
    }

    @Property(viewable=true, order=50)
    public String getPasswordState() {
        return this.passwordState;
    }

    public void setPasswordState(String passwordState) {
        this.passwordState = passwordState;
    }

    @Property(viewable=true, order=60)
    public String getPasswordExpiryPolicy() {
        return this.passwordExpiryPolicy;
    }

    public void setPasswordExpiryPolicy(String passwordExpiryPolicy) {
        this.passwordExpiryPolicy = passwordExpiryPolicy;
    }

    public String getUserName() {
        return this.userName;
    }

    @Property(viewable=true, order=70)
    public String getPasswordStateChanged() {
        return this.passwordStateChanged;
    }

    @Property(viewable=true, order=80)
    public Timestamp getPasswordExpiry() {
        return this.passwordExpiry;
    }

    @Property(viewable=true, order=90)
    public BigDecimal getPasswordExpiryDays() {
        return this.passwordExpiryDays;
    }

    @Property(viewable=true, order=100)
    public BigDecimal getPasswordExpiryGrace() {
        return this.passwordExpiryGrace;
    }

    @Property(viewable=true, order=110)
    public BigDecimal getFailedLoginAttempts() {
        return this.failedLoginAttempts;
    }

    @Property(viewable=true, updatable=true, editable=true, order=120)
    public Boolean getLocked() {
        return this.locked;
    }

    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public ExasolUser(ExasolDataSource datasource, String name, String description, String dn, String password, String kerberosPrincipal, ExasolUserType type) {
        super(datasource, false);
        this.userName = name;
        this.description = description;
        this.dn = dn;
        this.password = password;
        this.kerberosPrincipal = kerberosPrincipal;
        this.type = type;
    }

    @Property(viewable=true, updatable=true, editable=true, length=PropertyLength.MULTILINE, order=150)
    public String getDescription() {
        return this.description;
    }

    @Property(viewable=true, editable=true, updatable=true, order=20)
    public String getPassword() {
        return this.password;
    }

    @Property(viewable=true, editable=true, updatable=true, order=30)
    public String getDn() {
        return this.dn;
    }

    @Property(viewable=true, order=50)
    public Timestamp getCreated() {
        return this.created;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.userName;
    }

    public void setName(String newName) {
        this.userName = newName;
    }

    public void setPassword(String newPassword) {
        this.password = newPassword;
        this.dn = null;
        this.kerberosPrincipal = null;
        this.type = ExasolUserType.LOCAL;
    }

    public void setDN(String dn) {
        this.dn = dn;
        this.password = null;
        this.kerberosPrincipal = null;
        this.type = ExasolUserType.LDAP;
    }

    public ExasolUserType getType() {
        return this.type;
    }

    public String toString() {
        return "User " + this.getName();
    }
}

