/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.database;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourcePermission;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBPReferentialIntegrityController;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingCustom;
import org.jkiss.dbeaver.model.data.DBDInsertReplaceMethod;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.impl.struct.AbstractAttribute;
import org.jkiss.dbeaver.model.meta.DBSerializable;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.registry.SQLInsertReplaceMethodDescriptor;
import org.jkiss.dbeaver.model.sql.registry.SQLInsertReplaceMethodRegistry;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSDataManipulatorExt;
import org.jkiss.dbeaver.model.struct.DBSDocumentContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSManipulationType;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;
import org.jkiss.dbeaver.tools.transfer.IDataTransferAttributeTransformer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferNodePrimary;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProcessor;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingAttribute;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingContainer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingType;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferUtils;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.utils.CommonUtils;

@DBSerializable(value="databaseTransferConsumer")
public class DatabaseTransferConsumer
implements IDataTransferConsumer<DatabaseConsumerSettings, IDataTransferProcessor>,
IDataTransferNodePrimary,
DBPReferentialIntegrityController {
    private static final Log log = Log.getLog(DatabaseTransferConsumer.class);
    private DatabaseConsumerSettings settings;
    private DatabaseMappingContainer containerMapping;
    private ColumnMapping[] columnMappings;
    private DBDAttributeBinding[] sourceBindings;
    private DBCExecutionContext targetContext;
    private DBCSession targetSession;
    private DBSDataManipulator.ExecuteBatch executeBatch;
    private long rowsExported = 0L;
    private boolean ignoreErrors = false;
    private List<DBSAttributeBase> targetAttributes;
    private boolean useIsolatedConnection;
    private Boolean oldAutoCommit;
    private DBSObjectContainer targetObjectContainer;
    private DBSDataManipulator localTargetObject;
    private boolean isPreview;
    private List<Object[]> previewRows;
    private DBDAttributeBinding[] rsAttributes;

    public DatabaseTransferConsumer() {
    }

    public DatabaseTransferConsumer(DBSDataManipulator targetObject) {
        this.localTargetObject = targetObject;
    }

    public DatabaseTransferConsumer(DBSObjectContainer targetObjectContainer) {
        this.targetObjectContainer = targetObjectContainer;
    }

    public DBSObjectContainer getTargetObjectContainer() {
        return this.targetObjectContainer;
    }

    public ColumnMapping[] getColumnMappings() {
        return this.columnMappings;
    }

    @Override
    public DBSObject getDatabaseObject() {
        if (this.targetObjectContainer != null) {
            return this.targetObjectContainer;
        }
        return this.containerMapping == null ? this.localTargetObject : this.containerMapping.getTarget();
    }

    protected boolean isPreview() {
        return this.isPreview;
    }

    protected void setPreview(boolean preview) {
        this.isPreview = preview;
    }

    protected List<Object[]> getPreviewRows() {
        return this.previewRows;
    }

    /*
     * Unable to fully structure code
     */
    public void fetchStart(DBCSession session, DBCResultSet resultSet, long offset, long maxRows) throws DBCException {
        try {
            this.initExporter(session.getProgressMonitor());
        }
        catch (DBException e) {
            throw new DBCException("Error initializing exporter", (Throwable)e);
        }
        if (this.containerMapping == null) {
            throw new DBCException("Internal error: consumer mappings not set");
        }
        executionSource = new AbstractExecutionSource(this.containerMapping.getSource(), this.targetContext, (Object)this);
        targetObject = this.getTargetObject();
        if (!this.isPreview && offset <= 0L && this.settings.isTruncateBeforeLoad() && (this.containerMapping == null || this.containerMapping.getMappingType() == DatabaseMappingType.existing)) {
            if ((targetObject.getSupportedFeatures() & 524288) != 0) {
                targetObject.truncateData(this.targetSession, (DBCExecutionSource)executionSource);
            } else {
                DatabaseTransferConsumer.log.error((Object)("Table '" + targetObject.getName() + "' doesn't support truncate operation"));
            }
        }
        dynamicTarget = this.targetContext.getDataSource().getInfo().isDynamicMetadata();
        sourceObject = this.getSourceObject();
        this.rsAttributes = dynamicTarget != false ? DBUtils.getAttributeBindings((DBCSession)session, (DBSDataContainer)sourceObject, (DBCResultSetMetaData)resultSet.getMeta()) : DBUtils.makeLeafAttributeBindings((DBCSession)session, (DBSDataContainer)sourceObject, (DBCResultSet)resultSet);
        this.columnMappings = new ColumnMapping[this.rsAttributes.length];
        this.sourceBindings = this.rsAttributes;
        this.targetAttributes = new ArrayList<DBSAttributeBase>(this.columnMappings.length);
        i = 0;
        while (i < this.rsAttributes.length) {
            if (!this.isSkipColumn(this.rsAttributes[i])) {
                columnMapping = new ColumnMapping(this.rsAttributes[i]);
                if (this.containerMapping == null) {
                    if (targetObject instanceof DBSEntity) {
                        try {
                            attribute = ((DBSEntity)targetObject).getAttribute(session.getProgressMonitor(), columnMapping.sourceAttr.getName());
                            if (attribute != null) {
                                columnMapping.targetAttr = new DatabaseMappingAttribute(null, (DBSAttributeBase)columnMapping.sourceAttr);
                                columnMapping.targetAttr.setTarget(attribute);
                                columnMapping.targetAttr.setMappingType(DatabaseMappingType.existing);
                            }
                        }
                        catch (DBException v0) {
                            DatabaseTransferConsumer.log.error((Object)"Error getting target attribute");
                        }
                    }
                    if (columnMapping.targetAttr == null) {
                        throw new DBCException("Can't resolve target attribute for [" + columnMapping.sourceAttr.getName() + "]");
                    }
                } else if (sourceObject instanceof DBSDocumentContainer && dynamicTarget) {
                    try {
                        docContainer = (DBSDocumentContainer)(targetObject instanceof DBSDocumentContainer != false ? targetObject : sourceObject);
                        docAttribute = docContainer.getDocumentAttribute(session.getProgressMonitor());
                        if (docAttribute == null) ** GOTO lbl54
                        columnMapping.targetAttr = new DatabaseMappingAttribute(this.containerMapping, (DBSAttributeBase)columnMapping.sourceAttr);
                        columnMapping.targetAttr.setTarget(docAttribute);
                        columnMapping.targetAttr.setMappingType(DatabaseMappingType.existing);
                    }
                    catch (DBException e) {
                        throw new DBCException("Error getting document attribute", (Throwable)e);
                    }
                } else {
                    columnMapping.targetAttr = this.containerMapping.getAttributeMapping(columnMapping.sourceAttr);
                    if (columnMapping.targetAttr == null) {
                        throw new DBCException("Can't find target attribute [" + columnMapping.sourceAttr.getName() + "]");
                    }
                }
lbl54:
                // 5 sources

                if (columnMapping.targetAttr.getMappingType() != DatabaseMappingType.skip) {
                    if (columnMapping.targetAttr.getTransformer() != null) {
                        try {
                            columnMapping.valueTransformer = columnMapping.targetAttr.getTransformer().createTransformer();
                            columnMapping.valueTransformerProperties = columnMapping.targetAttr.getTransformerProperties();
                        }
                        catch (DBException e) {
                            throw new DBCException("Can't create attribute transformer", (Throwable)e);
                        }
                    }
                    if ((targetAttr = columnMapping.targetAttr.getTarget()) == null) {
                        if (this.isPreview) {
                            targetAttr = new PreviewColumnInfo(null, columnMapping.sourceAttr, columnMapping.targetIndex);
                        } else if (columnMapping.targetAttr.getSource() instanceof DBSEntityAttribute || targetObject instanceof DBSDocumentContainer) {
                            targetAttr = columnMapping.targetAttr.getSource();
                        } else {
                            throw new DBCException("Target attribute for [" + columnMapping.sourceAttr.getName() + "] wasn't resolved");
                        }
                    }
                    columnMapping.sourceValueHandler = columnMapping.sourceAttr.getValueHandler();
                    columnMapping.targetValueHandler = DBUtils.findValueHandler((DBPDataSource)this.targetContext.getDataSource(), (DBSTypedObject)targetAttr);
                    columnMapping.targetIndex = this.targetAttributes.size();
                    this.columnMappings[i] = columnMapping;
                    this.targetAttributes.add((DBSAttributeBase)targetAttr);
                }
            }
            ++i;
        }
        attributes = this.targetAttributes.toArray(new DBSAttributeBase[0]);
        options = new HashMap<String, Boolean>();
        options.put("data.manipulate.useMultiInsert", this.settings.isUseMultiRowInsert());
        options.put("data.manipulate.skipBindValues", this.settings.isSkipBindValues());
        if (!this.isPreview) {
            if (targetObject instanceof DBSDataManipulatorExt) {
                ((DBSDataManipulatorExt)targetObject).beforeDataChange(this.targetSession, DBSManipulationType.INSERT, attributes, (DBCExecutionSource)executionSource);
            }
            this.executeBatch = targetObject.insertData(this.targetSession, attributes, null, (DBCExecutionSource)executionSource, options);
        } else {
            this.previewRows = new ArrayList<Object[]>();
            this.executeBatch = new PreviewBatch();
        }
    }

    private boolean isSkipColumn(DBDAttributeBinding attr) {
        return attr.isPseudoAttribute() || !this.settings.isTransferAutoGeneratedColumns() && attr.isAutoGenerated() || attr instanceof DBDAttributeBindingCustom;
    }

    public void fetchRow(DBCSession session, DBCResultSet resultSet) throws DBCException {
        Object[] rowValues = new Object[this.targetAttributes.size()];
        int i = 0;
        while (i < this.columnMappings.length) {
            ColumnMapping column = this.columnMappings[i];
            if (column != null && column.targetIndex >= 0) {
                Object attrValue = column.sourceValueHandler != null ? (column.sourceAttr instanceof DBDAttributeBindingCustom ? DBUtils.getAttributeValue((DBDAttributeBinding)column.sourceAttr, (DBDAttributeBinding[])this.sourceBindings, (Object[])rowValues) : column.sourceValueHandler.fetchValueObject(session, resultSet, (DBSTypedObject)column.sourceAttr, i)) : resultSet.getAttributeValue(i);
                if (this.containerMapping != null && this.containerMapping.getTarget() instanceof DBSDocumentContainer) {
                    rowValues[column.targetIndex] = attrValue;
                } else {
                    DatabaseMappingAttribute targetAttr = column.targetAttr;
                    rowValues[column.targetIndex] = column.targetValueHandler.getValueFromObject(this.targetSession, (DBSTypedObject)(targetAttr.getTarget() == null ? targetAttr.getSource() : targetAttr.getTarget()), attrValue, false, false);
                }
            }
            ++i;
        }
        ColumnMapping[] columnMappingArray = this.columnMappings;
        int n = this.columnMappings.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnMapping column = columnMappingArray[n2];
            if (column != null && column.targetIndex >= 0 && column.valueTransformer != null) {
                Object attrValue = rowValues[column.targetIndex];
                try {
                    rowValues[column.targetIndex] = column.valueTransformer.transformAttribute(session, this.rsAttributes, rowValues, column.sourceAttr, attrValue, column.valueTransformerProperties);
                }
                catch (DBException e) {
                    throw new DBCException("Error transforming attribute '" + column.sourceAttr.getName() + "' value with transformer '" + column.targetAttr.getTransformer().getName() + "'", (Throwable)e);
                }
            }
            ++n2;
        }
        this.executeBatch.add(rowValues);
        ++this.rowsExported;
        this.insertBatch(false);
    }

    private void insertBatch(boolean force) throws DBCException {
        DBCTransactionManager txnManager;
        if (this.isPreview) {
            return;
        }
        boolean needCommit = force || this.rowsExported % (long)this.settings.getCommitAfterRows() == 0L;
        HashMap<String, Comparable<Boolean>> options = new HashMap<String, Comparable<Boolean>>();
        boolean disableUsingBatches = this.settings.isDisableUsingBatches();
        boolean onDuplicateKeyCaseOn = this.settings.getOnDuplicateKeyInsertMethodId() != null && !this.settings.getOnDuplicateKeyInsertMethodId().equals("<None>");
        options.put("data.manipulate.disableBatches", Boolean.valueOf(disableUsingBatches));
        options.put("data.manipulate.multiInsertBatchSize", Integer.valueOf(this.settings.getMultiRowInsertBatch()));
        options.put("data.manipulate.skipBindValues", Boolean.valueOf(this.settings.isSkipBindValues()));
        if (onDuplicateKeyCaseOn) {
            String insertMethodId = this.settings.getOnDuplicateKeyInsertMethodId();
            SQLInsertReplaceMethodDescriptor insertReplaceMethod = SQLInsertReplaceMethodRegistry.getInstance().getInsertMethod(insertMethodId);
            if (insertReplaceMethod != null) {
                try {
                    DBDInsertReplaceMethod insertMethod = insertReplaceMethod.createInsertMethod();
                    options.put("data.manipulate.insertReplaceMethod", (Comparable<Boolean>)insertMethod);
                }
                catch (DBException e) {
                    log.debug((Object)"Can't get insert replace method", (Throwable)e);
                }
            }
        }
        if ((needCommit || disableUsingBatches) && this.executeBatch != null) {
            boolean retryInsert;
            this.targetSession.getProgressMonitor().subTask("Insert rows (" + this.rowsExported + ")");
            do {
                retryInsert = false;
                try {
                    this.executeBatch.execute(this.targetSession, options);
                }
                catch (Throwable e) {
                    log.error((Object)"Error inserting row", e);
                    if (this.ignoreErrors) break;
                    String message = disableUsingBatches ? DTMessages.database_transfer_consumer_task_error_occurred_during_data_load : DTMessages.database_transfer_consumer_task_error_occurred_during_batch_insert;
                    DBPPlatformUI.UserResponse response = DBWorkbench.getPlatformUI().showErrorStopRetryIgnore(message, e, true);
                    switch (response) {
                        case STOP: {
                            throw new DBCException("Can't insert row", e);
                        }
                        case RETRY: {
                            retryInsert = true;
                            break;
                        }
                        case IGNORE: {
                            retryInsert = false;
                            break;
                        }
                        case IGNORE_ALL: {
                            this.ignoreErrors = true;
                            retryInsert = false;
                        }
                    }
                }
            } while (retryInsert);
        }
        if (this.settings.isUseTransactions() && needCommit && (txnManager = DBUtils.getTransactionManager((DBCExecutionContext)this.targetSession.getExecutionContext())) != null && txnManager.isSupportsTransactions() && !txnManager.isAutoCommit()) {
            this.targetSession.getProgressMonitor().subTask("Commit changes");
            txnManager.commit(this.targetSession);
        }
    }

    public void fetchEnd(DBCSession session, DBCResultSet resultSet) throws DBCException {
        try {
            if (this.rowsExported > 0L) {
                this.insertBatch(true);
            }
            if (this.executeBatch != null) {
                this.executeBatch.close();
                this.executeBatch = null;
            }
        }
        finally {
            DBSDataManipulator targetObject = this.getTargetObject();
            if (!this.isPreview && targetObject instanceof DBSDataManipulatorExt) {
                ((DBSDataManipulatorExt)targetObject).afterDataChange(this.targetSession, DBSManipulationType.INSERT, this.targetAttributes.toArray(new DBSAttributeBase[0]), (DBCExecutionSource)new AbstractExecutionSource(this.getSourceObject(), this.targetContext, (Object)this));
            }
        }
    }

    public void close() {
        this.closeExporter();
    }

    private void initExporter(DBRProgressMonitor monitor) throws DBException {
        DBCTransactionManager txnManager;
        DBSObject targetDB = this.checkTargetContainer(monitor);
        DBPDataSourceContainer dataSourceContainer = targetDB.getDataSource().getContainer();
        if (!dataSourceContainer.hasModifyPermission(DBPDataSourcePermission.PERMISSION_IMPORT_DATA)) {
            throw new DBCException("Data transfer to database [" + dataSourceContainer.getName() + "] restricted by connection configuration");
        }
        try {
            this.useIsolatedConnection = !this.isPreview && this.settings.isOpenNewConnections() && !dataSourceContainer.getDriver().isEmbedded();
            this.targetContext = this.useIsolatedConnection ? DBUtils.getObjectOwnerInstance((DBSObject)targetDB).openIsolatedContext(monitor, "Data transfer consumer", null) : DBUtils.getDefaultContext((DBSObject)targetDB, (boolean)false);
        }
        catch (DBException e) {
            throw new DBCException("Error opening new connection", (Throwable)e);
        }
        this.targetSession = this.targetContext.openSession(monitor, DBCExecutionPurpose.UTIL, "Data load");
        this.targetSession.enableLogging(false);
        if (!this.isPreview && (txnManager = DBUtils.getTransactionManager((DBCExecutionContext)this.targetSession.getExecutionContext())) != null && txnManager.isSupportsTransactions()) {
            this.oldAutoCommit = txnManager.isAutoCommit();
            if (this.settings.isUseTransactions()) {
                if (this.oldAutoCommit.booleanValue()) {
                    txnManager.setAutoCommit(monitor, false);
                }
            } else if (!this.oldAutoCommit.booleanValue()) {
                txnManager.setAutoCommit(monitor, true);
            }
        }
    }

    DBSObject checkTargetContainer(DBRProgressMonitor monitor) throws DBException {
        DBSDataManipulator targetObject = this.getTargetObject();
        if (targetObject == null) {
            if (this.settings.getContainerNode() != null && this.settings.getContainerNode().getDataSource() == null) {
                this.settings.getContainerNode().initializeNode(monitor, null);
            }
            if (this.settings.getContainer() == null) {
                throw new DBCException("Can't initialize database consumer. No target object and no target container");
            }
        }
        return targetObject == null ? this.settings.getContainer() : targetObject;
    }

    private void closeExporter() {
        if (!this.isPreview && this.targetSession != null && this.oldAutoCommit != null) {
            try {
                DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)this.targetSession.getExecutionContext());
                if (txnManager != null) {
                    txnManager.setAutoCommit(this.targetSession.getProgressMonitor(), this.oldAutoCommit.booleanValue());
                }
            }
            catch (Exception e) {
                log.debug((Object)"Error reverting auto-commit mode", (Throwable)e);
            }
        }
        try {
            if (this.targetSession != null) {
                this.targetSession.close();
                this.targetSession = null;
            }
        }
        catch (Throwable e) {
            log.debug((Object)e);
        }
        if (this.targetContext != null && this.useIsolatedConnection) {
            this.targetContext.close();
            this.targetContext = null;
        }
    }

    @Override
    public void initTransfer(DBSObject sourceObject, DatabaseConsumerSettings settings, IDataTransferConsumer.TransferParameters parameters, IDataTransferProcessor processor, Map<String, Object> processorProperties) {
        this.settings = settings;
        this.containerMapping = settings.getDataMapping((DBSDataContainer)sourceObject);
    }

    @Override
    public void startTransfer(DBRProgressMonitor monitor) throws DBException {
        monitor.beginTask("Create necessary database objects", 1);
        try {
            DBSObject dbObject = this.checkTargetContainer(monitor);
            if (!this.isPreview && this.containerMapping != null) {
                DBSObjectContainer container = this.settings.getContainer();
                if (container == null) {
                    throw new DBException("No target datasource - can't create target objects");
                }
                boolean hasNewObjects = this.createTargetDatabaseObjects(monitor, dbObject);
                if (hasNewObjects) {
                    DatabaseTransferUtils.refreshDatabaseModel(monitor, this.settings, this.containerMapping);
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * Exception decompiling
     */
    private boolean createTargetDatabaseObjects(DBRProgressMonitor monitor, DBSObject dbObject) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 16[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void createTargetTable(DBCSession session, DatabaseMappingContainer containerMapping) throws DBException {
        DBPDataSourceContainer dataSourceContainer = session.getDataSource().getContainer();
        if (!dataSourceContainer.hasModifyPermission(DBPDataSourcePermission.PERMISSION_EDIT_METADATA)) {
            throw new DBCException("New table creation in database [" + dataSourceContainer.getName() + "] restricted by connection configuration");
        }
        DBSObjectContainer schema = this.settings.getContainer();
        if (schema == null) {
            throw new DBException("No target container selected");
        }
        if (session.getDataSource().getInfo().isDynamicMetadata()) {
            DatabaseTransferUtils.createTargetDynamicTable(session.getProgressMonitor(), session.getExecutionContext(), schema, containerMapping);
        } else {
            Object[] actions = DatabaseTransferUtils.generateTargetTableDDL(session.getProgressMonitor(), session.getExecutionContext(), schema, containerMapping);
            try {
                DatabaseTransferUtils.executeDDL(session, (DBEPersistAction[])actions);
            }
            catch (DBCException e) {
                throw new DBCException("Can't create target table:\n" + Arrays.toString(actions), (Throwable)e);
            }
        }
    }

    private void createTargetAttribute(DBCSession session, DatabaseMappingAttribute attribute) throws DBCException {
        DBPDataSourceContainer dataSourceContainer = session.getDataSource().getContainer();
        if (!dataSourceContainer.hasModifyPermission(DBPDataSourcePermission.PERMISSION_EDIT_METADATA)) {
            throw new DBCException("New attribute creation in database [" + dataSourceContainer.getName() + "] restricted by connection configuration");
        }
        session.getProgressMonitor().subTask("Create column " + DBUtils.getObjectFullName((DBPNamedObject)attribute.getParent().getTarget(), (DBPEvaluationContext)DBPEvaluationContext.DDL) + "." + attribute.getTargetName());
        try {
            DatabaseTransferUtils.executeDDL(session, new DBEPersistAction[]{DatabaseTransferUtils.generateTargetAttributeDDL(session.getDataSource(), attribute)});
        }
        catch (DBCException e) {
            throw new DBCException("Can't create target column", (Throwable)e);
        }
    }

    @Override
    public void finishTransfer(DBRProgressMonitor monitor, boolean last) {
        if (last) {
            monitor.subTask("Refresh navigator model");
            try {
                this.settings.getContainerNode().refreshNode(monitor, (Object)this);
            }
            catch (Exception e) {
                log.debug((Object)"Error refreshing navigator model after data consumer", (Throwable)e);
            }
        }
        if (!last && this.settings.isOpenTableOnFinish() && this.getTargetObject() != null) {
            DBWorkbench.getPlatformUI().openEntityEditor((DBSObject)this.getTargetObject());
        }
    }

    public DBSDataContainer getSourceObject() {
        return this.containerMapping == null ? null : this.containerMapping.getSource();
    }

    public DBSDataManipulator getTargetObject() {
        return this.containerMapping == null ? this.localTargetObject : this.containerMapping.getTarget();
    }

    public void setTargetObject(DBSDataManipulator targetObject) {
        this.localTargetObject = targetObject;
    }

    @Override
    public String getObjectName() {
        if (this.targetObjectContainer != null) {
            return this.targetObjectContainer.getName();
        }
        DBSDataManipulator targetObject = this.getTargetObject();
        String targetName = null;
        if (targetObject != null) {
            targetName = DBUtils.getObjectFullName((DBPNamedObject)targetObject, (DBPEvaluationContext)DBPEvaluationContext.UI);
        }
        if (targetName != null) {
            return String.valueOf(targetName) + " [Existing]";
        }
        if (this.containerMapping == null) {
            return "?";
        }
        targetName = this.containerMapping.getTargetFullName();
        switch (this.containerMapping.getMappingType()) {
            case create: {
                return String.valueOf(targetName) + " [Create]";
            }
            case existing: {
                for (DatabaseMappingAttribute attr : this.containerMapping.getAttributeMappings((DBRProgressMonitor)new VoidProgressMonitor())) {
                    if (attr.getMappingType() != DatabaseMappingType.create) continue;
                    return String.valueOf(targetName) + " [Alter]";
                }
                return targetName;
            }
            case skip: {
                return "[Skip]";
            }
        }
        return String.valueOf(targetName) + " [Existing]";
    }

    @Override
    public DBPImage getObjectIcon() {
        if (this.targetObjectContainer != null) {
            return DBIcon.TREE_FOLDER_TABLE;
        }
        DBSDataManipulator targetObject = this.getTargetObject();
        if (targetObject instanceof DBPImageProvider) {
            return DBValueFormatting.getObjectImage((DBPObject)targetObject);
        }
        return DBIcon.TREE_TABLE;
    }

    @Override
    public String getObjectContainerName() {
        if (this.targetObjectContainer != null) {
            return DBUtils.getObjectFullName((DBPNamedObject)this.targetObjectContainer, (DBPEvaluationContext)DBPEvaluationContext.UI);
        }
        DBPDataSourceContainer container = this.getDataSourceContainer();
        return container != null ? container.getName() : "?";
    }

    @Override
    public DBPImage getObjectContainerIcon() {
        if (this.targetObjectContainer != null) {
            return DBIcon.TREE_FOLDER_TABLE;
        }
        DBPDataSourceContainer container = this.getDataSourceContainer();
        return container != null ? container.getDriver().getIcon() : null;
    }

    DBPDataSourceContainer getDataSourceContainer() {
        if (this.targetObjectContainer != null) {
            return this.targetObjectContainer.getDataSource().getContainer();
        }
        DBSDataManipulator targetObject = this.getTargetObject();
        if (targetObject != null) {
            return targetObject.getDataSource().getContainer();
        }
        DBSObjectContainer container = this.settings.getContainer();
        if (container != null) {
            return container.getDataSource().getContainer();
        }
        return null;
    }

    public boolean equals(Object obj) {
        return obj instanceof DatabaseTransferConsumer && CommonUtils.equalObjects((Object)this.getTargetObject(), (Object)((DatabaseTransferConsumer)obj).getTargetObject());
    }

    public boolean supportsChangingReferentialIntegrity(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.checkTargetContainer(monitor) instanceof DBPReferentialIntegrityController;
    }

    public void enableReferentialIntegrity(@NotNull DBRProgressMonitor monitor, boolean enable) throws DBException {
        DBSObject dbsObject = this.checkTargetContainer(monitor);
        if (!(dbsObject instanceof DBPReferentialIntegrityController)) {
            throw new DBException("Changing referential integrity is unsupported!");
        }
        DBPReferentialIntegrityController controller = (DBPReferentialIntegrityController)dbsObject;
        controller.enableReferentialIntegrity(monitor, enable);
    }

    @Nullable
    public String getChangeReferentialIntegrityStatement(@NotNull DBRProgressMonitor monitor, boolean enable) throws DBException {
        DBSObject dbsObject = this.checkTargetContainer(monitor);
        if (dbsObject instanceof DBPReferentialIntegrityController) {
            return ((DBPReferentialIntegrityController)dbsObject).getChangeReferentialIntegrityStatement(monitor, enable);
        }
        return null;
    }

    public DatabaseConsumerSettings getSettings() {
        return this.settings;
    }

    public static class ColumnMapping {
        public DBDAttributeBinding sourceAttr;
        public DatabaseMappingAttribute targetAttr;
        public DBDValueHandler sourceValueHandler;
        public DBDValueHandler targetValueHandler;
        public int targetIndex = -1;
        public IDataTransferAttributeTransformer valueTransformer;
        public Map<String, Object> valueTransformerProperties;

        private ColumnMapping(DBDAttributeBinding sourceAttr) {
            this.sourceAttr = sourceAttr;
        }

        public String toString() {
            return this.sourceAttr + "->" + this.targetAttr;
        }
    }

    private class PreviewBatch
    implements DBSDataManipulator.ExecuteBatch {
        private PreviewBatch() {
        }

        public void add(@NotNull Object[] attributeValues) throws DBCException {
            DatabaseTransferConsumer.this.previewRows.add(attributeValues);
        }

        @NotNull
        public DBCStatistics execute(@NotNull DBCSession session, Map<String, Object> options) throws DBCException {
            return new DBCStatistics();
        }

        public void generatePersistActions(@NotNull DBCSession session, @NotNull List<DBEPersistAction> actions, Map<String, Object> options) throws DBCException {
        }

        public void close() {
        }
    }

    private static class PreviewColumnInfo
    extends AbstractAttribute
    implements DBSEntityAttribute {
        private final DBSEntity entity;
        private final DBDAttributeBinding binding;

        public PreviewColumnInfo(DBSEntity entity, DBDAttributeBinding binding, int index) {
            super(binding.getName(), binding.getTypeName(), -1, index, binding.getMaxLength(), null, null, false, false);
            this.entity = entity;
            this.binding = binding;
        }

        @Nullable
        public String getDefaultValue() {
            return null;
        }

        @NotNull
        public DBSEntity getParentObject() {
            return this.entity;
        }

        @NotNull
        public DBPDataSource getDataSource() {
            return this.binding.getDataSource();
        }

        public DBPDataKind getDataKind() {
            return this.binding.getDataKind();
        }
    }
}

