/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableBase;
import org.jkiss.dbeaver.ext.mysql.tasks.MySQLDatabaseExportInfo;
import org.jkiss.dbeaver.ext.mysql.tasks.MySQLExportSettings;
import org.jkiss.dbeaver.ext.mysql.tools.MySQLExportWizard;
import org.jkiss.dbeaver.ext.mysql.tools.MySQLWizardPageSettings;
import org.jkiss.dbeaver.ext.mysql.ui.internal.MySQLUIMessages;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomSashForm;
import org.jkiss.utils.CommonUtils;

class MySQLExportWizardPageObjects
extends MySQLWizardPageSettings<MySQLExportWizard> {
    private Table catalogTable;
    private Table tablesTable;
    private Map<MySQLCatalog, Set<MySQLTableBase>> checkedObjects = new HashMap<MySQLCatalog, Set<MySQLTableBase>>();
    private MySQLCatalog curCatalog;
    private Button exportViewsCheck;

    protected MySQLExportWizardPageObjects(MySQLExportWizard wizard) {
        super(wizard, MySQLUIMessages.tools_db_export_wizard_page_objects_dialog_wizard_title);
        this.setTitle(MySQLUIMessages.tools_db_export_wizard_page_objects_dialog_title_choose_objects);
        this.setDescription(MySQLUIMessages.tools_db_export_wizard_page_objects_dialog_description);
    }

    public boolean isPageComplete() {
        return super.isPageComplete();
    }

    public void createControl(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        Group objectsGroup = UIUtils.createControlGroup((Composite)composite, (String)MySQLUIMessages.tools_db_export_wizard_page_settings_group_objects, (int)1, (int)768, (int)0);
        objectsGroup.setLayoutData((Object)new GridData(1808));
        CustomSashForm sash = new CustomSashForm((Composite)objectsGroup, 512);
        sash.setLayoutData((Object)new GridData(1808));
        Composite catPanel = UIUtils.createComposite((Composite)sash, (int)1);
        catPanel.setLayoutData((Object)new GridData(1808));
        this.catalogTable = new Table(catPanel, 2080);
        this.catalogTable.addListener(13, event -> {
            TableItem item = (TableItem)event.item;
            if (item != null) {
                MySQLCatalog catalog = (MySQLCatalog)item.getData();
                if (event.detail == 32) {
                    this.catalogTable.select(this.catalogTable.indexOf(item));
                    this.checkedObjects.remove(catalog);
                }
                this.loadTables(catalog);
                this.updateState();
            }
        });
        GridData gd = new GridData(1808);
        gd.heightHint = 50;
        this.catalogTable.setLayoutData((Object)gd);
        Composite buttonsPanel = UIUtils.createComposite((Composite)catPanel, (int)3);
        buttonsPanel.setLayoutData((Object)new GridData(768));
        new Label(buttonsPanel, 0).setLayoutData((Object)new GridData(512));
        this.createCheckButtons(buttonsPanel, this.catalogTable);
        Composite tablesPanel = UIUtils.createComposite((Composite)sash, (int)1);
        tablesPanel.setLayoutData((Object)new GridData(1808));
        this.tablesTable = new Table(tablesPanel, 2080);
        gd = new GridData(1808);
        gd.heightHint = 50;
        this.tablesTable.setLayoutData((Object)gd);
        this.tablesTable.addListener(13, event -> {
            if (event.detail == 32) {
                this.updateCheckedTables();
                this.updateState();
            }
        });
        buttonsPanel = UIUtils.createComposite((Composite)tablesPanel, (int)3);
        buttonsPanel.setLayoutData((Object)new GridData(768));
        this.exportViewsCheck = UIUtils.createCheckbox((Composite)buttonsPanel, (String)MySQLUIMessages.tools_db_export_wizard_page_settings_group_show_views, (boolean)false);
        this.exportViewsCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((MySQLExportSettings)((MySQLExportWizard)MySQLExportWizardPageObjects.this.wizard).getSettings()).setShowViews(MySQLExportWizardPageObjects.this.exportViewsCheck.getSelection());
                MySQLExportWizardPageObjects.this.loadTables(null);
            }
        });
        this.exportViewsCheck.setLayoutData((Object)new GridData(512));
        this.createCheckButtons(buttonsPanel, this.tablesTable);
        this.loadSettings();
        this.setControl((Control)composite);
    }

    public void activatePage() {
        this.loadSettings();
    }

    public void deactivatePage() {
        this.saveState();
    }

    private void loadSettings() {
        this.checkedObjects.clear();
        this.catalogTable.removeAll();
        boolean hasViews = false;
        MySQLDataSource dataSource = null;
        LinkedHashSet<MySQLCatalog> activeCatalogs = new LinkedHashSet<MySQLCatalog>();
        for (MySQLDatabaseExportInfo info : ((MySQLExportSettings)((MySQLExportWizard)this.wizard).getSettings()).getExportObjects()) {
            activeCatalogs.add(info.getDatabase());
            dataSource = info.getDatabase().getDataSource();
            if (CommonUtils.isEmpty((Collection)info.getTables())) continue;
            Set tables = this.checkedObjects.computeIfAbsent(info.getDatabase(), k -> new HashSet());
            for (MySQLTableBase table : info.getTables()) {
                tables.add(table);
                if (!table.isView()) continue;
                hasViews = true;
            }
        }
        if (hasViews) {
            ((MySQLExportSettings)((MySQLExportWizard)this.wizard).getSettings()).setShowViews(true);
            this.exportViewsCheck.setSelection(true);
        }
        if (dataSource != null) {
            boolean tablesLoaded = false;
            for (MySQLCatalog catalog : dataSource.getCatalogs()) {
                if (catalog.getName().equalsIgnoreCase("information_schema")) continue;
                TableItem item = new TableItem(this.catalogTable, 0);
                item.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_DATABASE));
                item.setText(0, catalog.getName());
                item.setData((Object)catalog);
                if (!activeCatalogs.contains(catalog)) continue;
                item.setChecked(true);
                this.catalogTable.select(this.catalogTable.indexOf(item));
                if (tablesLoaded) continue;
                this.loadTables(catalog);
                tablesLoaded = true;
            }
        }
        this.updateState();
    }

    private void updateCheckedTables() {
        TableItem[] tableItems;
        HashSet<MySQLTableBase> checkedTables = new HashSet<MySQLTableBase>();
        TableItem[] tableItemArray = tableItems = this.tablesTable.getItems();
        int n = tableItems.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                checkedTables.add((MySQLTableBase)item.getData());
            }
            ++n2;
        }
        TableItem catalogItem = this.catalogTable.getItem(this.catalogTable.getSelectionIndex());
        catalogItem.setChecked(!checkedTables.isEmpty());
        if (checkedTables.isEmpty() || checkedTables.size() == tableItems.length) {
            this.checkedObjects.remove(this.curCatalog);
        } else {
            this.checkedObjects.put(this.curCatalog, checkedTables);
        }
    }

    private boolean isChecked(MySQLCatalog catalog) {
        TableItem[] tableItemArray = this.catalogTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getData() == catalog) {
                return item.getChecked();
            }
            ++n2;
        }
        return false;
    }

    private void loadTables(MySQLCatalog catalog) {
        if (catalog != null) {
            this.curCatalog = catalog;
        }
        if (this.curCatalog == null) {
            return;
        }
        final boolean isCatalogChecked = this.isChecked(this.curCatalog);
        final Set<MySQLTableBase> checkedObjects = this.checkedObjects.get(this.curCatalog);
        new AbstractJob("Load '" + this.curCatalog.getName() + "' tables"){
            {
                super($anonymous0);
                this.setUser(true);
            }

            protected IStatus run(DBRProgressMonitor monitor) {
                try {
                    ArrayList objects = new ArrayList();
                    objects.addAll(MySQLExportWizardPageObjects.this.curCatalog.getTables(monitor));
                    if (((MySQLExportSettings)((MySQLExportWizard)MySQLExportWizardPageObjects.this.wizard).getSettings()).isShowViews()) {
                        objects.addAll(MySQLExportWizardPageObjects.this.curCatalog.getViews(monitor));
                    }
                    objects.sort(DBUtils.nameComparator());
                    UIUtils.syncExec(() -> {
                        MySQLExportWizardPageObjects.this.tablesTable.removeAll();
                        for (MySQLTableBase table : objects) {
                            TableItem item = new TableItem(MySQLExportWizardPageObjects.this.tablesTable, 0);
                            item.setImage(DBeaverIcons.getImage((DBPImage)(table.isView() ? DBIcon.TREE_VIEW : DBIcon.TREE_TABLE)));
                            item.setText(0, table.getName());
                            item.setData((Object)table);
                            item.setChecked(isCatalogChecked && (checkedObjects == null || checkedObjects.contains(table)));
                        }
                    });
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError("Table list", "Can't read table list", (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void saveState() {
        List objects = ((MySQLExportSettings)((MySQLExportWizard)this.wizard).getSettings()).getExportObjects();
        objects.clear();
        TableItem[] tableItemArray = this.catalogTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                MySQLCatalog catalog = (MySQLCatalog)item.getData();
                MySQLDatabaseExportInfo info = new MySQLDatabaseExportInfo(catalog, (Collection)this.checkedObjects.get(catalog));
                objects.add(info);
            }
            ++n2;
        }
    }

    protected void updateState() {
        boolean complete = false;
        if (!this.checkedObjects.isEmpty()) {
            complete = true;
        }
        TableItem[] tableItemArray = this.catalogTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                complete = true;
                break;
            }
            ++n2;
        }
        this.setPageComplete(complete);
    }

    protected void updateTableCheckedStatus(@NotNull Table table, boolean check) {
        if (table == this.catalogTable) {
            TableItem[] tableItemArray = this.tablesTable.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem tableItem = tableItemArray[n2];
                tableItem.setChecked(check);
                ++n2;
            }
        }
        this.updateCheckedTables();
    }
}

