/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.ui.controls;

import java.util.Collection;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.dbeaver.ext.mysql.model.MySQLGrant;
import org.jkiss.dbeaver.ext.mysql.model.MySQLPrivilege;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.ArrayUtils;

public class PrivilegeTableControl
extends Composite {
    private Table privTable;
    private boolean isStatic;

    public PrivilegeTableControl(Composite parent, String title, boolean isStatic) {
        super(parent, 0);
        this.isStatic = isStatic;
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        this.setLayout((Layout)gl);
        Group privsGroup = UIUtils.createControlGroup((Composite)this, (String)title, (int)1, (int)1808, (int)0);
        GridData gd = (GridData)privsGroup.getLayoutData();
        gd.horizontalSpan = 2;
        this.privTable = new Table((Composite)privsGroup, 2852);
        this.privTable.setHeaderVisible(true);
        gd = new GridData(1808);
        gd.minimumWidth = 300;
        this.privTable.setLayoutData((Object)gd);
        this.privTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32) {
                    TableItem item = (TableItem)e.item;
                    PrivilegeTableControl.this.notifyPrivilegeCheck((MySQLPrivilege)item.getData(), item.getChecked());
                }
            }
        });
        UIUtils.createTableColumn((Table)this.privTable, (int)16384, (String)"Privilege");
        UIUtils.createTableColumn((Table)this.privTable, (int)16384, (String)"Description");
        UIUtils.packColumns((Table)this.privTable);
        Composite buttonsPanel = UIUtils.createComposite((Composite)privsGroup, (int)3);
        buttonsPanel.setLayoutData((Object)new GridData(768));
        UIUtils.createPushButton((Composite)buttonsPanel, (String)"Check All", null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItemArray = PrivilegeTableControl.this.privTable.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (!item.getChecked()) {
                        item.setChecked(true);
                        PrivilegeTableControl.this.notifyPrivilegeCheck((MySQLPrivilege)item.getData(), true);
                    }
                    ++n2;
                }
            }
        });
        UIUtils.createPushButton((Composite)buttonsPanel, (String)"Clear All", null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItemArray = PrivilegeTableControl.this.privTable.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (item.getChecked()) {
                        item.setChecked(false);
                        PrivilegeTableControl.this.notifyPrivilegeCheck((MySQLPrivilege)item.getData(), false);
                    }
                    ++n2;
                }
            }
        });
    }

    private void notifyPrivilegeCheck(MySQLPrivilege privilege, boolean checked) {
        Event event = new Event();
        event.detail = checked ? 1 : 0;
        event.widget = this;
        event.data = privilege;
        super.notifyListeners(24, event);
    }

    public void fillPrivileges(Collection<MySQLPrivilege> privs) {
        if (this.privTable.isDisposed()) {
            return;
        }
        this.privTable.removeAll();
        for (MySQLPrivilege priv : privs) {
            TableItem item = new TableItem(this.privTable, 0);
            item.setText(0, priv.getName());
            item.setText(1, priv.getDescription());
            item.setData((Object)priv);
        }
        UIUtils.packColumns((Table)this.privTable);
    }

    public void fillGrants(List<MySQLGrant> grants) {
        if (grants == null) {
            return;
        }
        TableItem[] tableItemArray = this.privTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            MySQLPrivilege privilege = (MySQLPrivilege)item.getData();
            boolean checked = false;
            for (MySQLGrant grant : grants) {
                if (this.isStatic && !grant.isStatic() || !grant.isAllPrivileges() && !ArrayUtils.contains((Object[])grant.getPrivileges(), (Object)privilege)) continue;
                checked = true;
                break;
            }
            item.setChecked(checked);
            ++n2;
        }
    }

    public void checkPrivilege(MySQLPrivilege privilege, boolean grant) {
        TableItem[] tableItemArray = this.privTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getData() == privilege) {
                item.setChecked(grant);
                break;
            }
            ++n2;
        }
    }
}

