/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.swt.widgets.Display;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;

public class ModelPropertyTester
extends PropertyTester {
    private static final Log log = Log.getLog(ModelPropertyTester.class);
    public static final String NAMESPACE = "org.jkiss.dbeaver.model";
    public static final String PROP_CHILD_OF_TYPE = "childOfType";
    public static final String PROP_IS_TABLE_CONTAINER = "isTableContainer";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (!(receiver instanceof DBSObject)) {
            return false;
        }
        Display display = Display.getCurrent();
        if (display == null) {
            return false;
        }
        switch (property) {
            case "childOfType": {
                DBSObject object = (DBSObject)receiver;
                if (object instanceof DBSObjectContainer && expectedValue instanceof String) {
                    try {
                        Class<?> expectedChildClass = Class.forName((String)expectedValue);
                        Class childType = ((DBSObjectContainer)object).getPrimaryChildType(null);
                        return expectedChildClass.isAssignableFrom(childType);
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                return false;
            }
            case "isTableContainer": {
                Object valueObject;
                DBSObject object = DBUtils.getPublicObject((DBSObject)((DBSObject)receiver));
                if (object instanceof DBNContainer && (valueObject = ((DBNContainer)object).getValueObject()) instanceof DBSObject) {
                    object = (DBSObject)valueObject;
                }
                if (object instanceof DBSSchema) {
                    return true;
                }
                if (object instanceof DBSObjectContainer) {
                    try {
                        Class primaryChildType = ((DBSObjectContainer)object).getPrimaryChildType(null);
                        if (DBSDataContainer.class.isAssignableFrom(primaryChildType)) {
                            return true;
                        }
                    }
                    catch (DBException e) {
                        log.debug((Object)e);
                    }
                }
                return false;
            }
        }
        return false;
    }
}

