/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;

public class TextWithDropDown
extends Composite {
    private final Text text;
    private final Menu menu;
    private final SelectionListener menuListener;

    public TextWithDropDown(@NotNull Composite parent, int style, int textStyle, @Nullable SelectionListener menuListener) {
        super(parent, style);
        this.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        this.setLayoutData(new GridData(1, 1, false, false));
        this.text = new Text((Composite)this, textStyle);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true));
        this.menu = new Menu((Control)parent.getShell());
        this.menuListener = menuListener;
        new Button((Composite)this, 1028).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Control item = (Control)e.widget;
                Rectangle rect = item.getBounds();
                Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
                TextWithDropDown.this.menu.setLocation(pt.x, pt.y + rect.height);
                TextWithDropDown.this.menu.setVisible(true);
            }
        });
        this.addDisposeListener(event -> this.menu.dispose());
    }

    @NotNull
    public MenuItem addMenuItem(@NotNull String text) {
        return this.addMenuItem(text, null, null, null);
    }

    @NotNull
    public MenuItem addMenuItem(@NotNull String text, @Nullable String toolTipText, @Nullable DBIcon image, @Nullable Object data) {
        MenuItem item = new MenuItem(this.menu, 0);
        item.setText(text);
        item.setToolTipText(toolTipText);
        item.setData(data);
        if (image != null) {
            item.setImage(DBeaverIcons.getImage((DBPImage)image));
        }
        if (this.menuListener != null) {
            item.addSelectionListener(this.menuListener);
        }
        return item;
    }

    public void addMenuSeparator() {
        new MenuItem(this.menu, 2);
    }

    @NotNull
    public Menu getMenuComponent() {
        return this.menu;
    }

    @NotNull
    public Text getTextComponent() {
        return this.text;
    }
}

