/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.bool;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.internal.UIMessages;

public enum BooleanState {
    CHECKED("checked", UIMessages.control_boolean_state_checked, UIIcon.CHECK_ON, new String[]{"\u2611", "[v]", "yes", String.valueOf(true)}),
    UNCHECKED("unchecked", UIMessages.control_boolean_state_unchecked, UIIcon.CHECK_OFF, new String[]{"\u2610", "[\u2000]", "no", String.valueOf(false)}),
    NULL("null", UIMessages.control_boolean_state_null, UIIcon.CHECK_QUEST, new String[]{"\u2612", "[?]", "[NULL]"});

    private final String id;
    private final String label;
    private final DBIcon icon;
    private final String[] predefinedTextStyles;

    private BooleanState(@NotNull String id, @NotNull String label, DBIcon icon, String[] predefinedTextStyles) {
        this.id = id;
        this.label = label;
        this.icon = icon;
        this.predefinedTextStyles = predefinedTextStyles;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getLabel() {
        return this.label;
    }

    @NotNull
    public DBIcon getIcon() {
        return this.icon;
    }

    @NotNull
    public String[] getPredefinedTextStyles() {
        return this.predefinedTextStyles;
    }

    @NotNull
    public <T> T choose(@NotNull T checked, @NotNull T unchecked, @NotNull T none) {
        return this == CHECKED ? checked : (this == UNCHECKED ? unchecked : none);
    }
}

