/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.bool;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIElementAlignment;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.controls.bool.BooleanMode;
import org.jkiss.dbeaver.ui.controls.bool.BooleanState;
import org.jkiss.dbeaver.ui.controls.bool.BooleanStyle;
import org.jkiss.utils.CommonUtils;

public class BooleanStyleSet {
    private static final String PREF_BOOLEAN_STYLE = "ui.render.boolean.style";
    private static final String PROP_LEGACY_STYLE_ICON = "ICON";
    private static final String PROP_LEGACY_STYLE_TEXTBOX = "TEXTBOX";
    private static final String PROP_LEGACY_STYLE_CHECKBOX = "CHECKBOX";
    private static final String PROP_LEGACY_STYLE_TRUE_FALSE = "TRUE_FALSE";
    private static final String PROP_LEGACY_STYLE_YES_NO = "YES_NO";
    private static final String PROP_MODE = "mode";
    private static final String PROP_TEXT = "text";
    private static final String PROP_ALIGN = "align";
    private static final String PROP_COLOR = "color";
    private static final String COLOR_DEFAULT = "default";
    private final BooleanStyle checkedStyle;
    private final BooleanStyle uncheckedStyle;
    private final BooleanStyle nullStyle;
    private final RGB defaultColor;

    public BooleanStyleSet(@NotNull BooleanStyle checkedStyle, @NotNull BooleanStyle uncheckedStyle, @NotNull BooleanStyle nullStyle, @NotNull RGB defaultColor) {
        this.checkedStyle = checkedStyle;
        this.uncheckedStyle = uncheckedStyle;
        this.nullStyle = nullStyle;
        this.defaultColor = defaultColor;
        Assert.isLegal((checkedStyle.getMode() == uncheckedStyle.getMode() && uncheckedStyle.getMode() == nullStyle.getMode() ? 1 : 0) != 0, (String)"Mixed style modes");
    }

    @NotNull
    public BooleanStyle getStyle(@Nullable Boolean value) {
        return value == null ? this.nullStyle : (value != false ? this.checkedStyle : this.uncheckedStyle);
    }

    @NotNull
    public BooleanStyle getCheckedStyle() {
        return this.checkedStyle;
    }

    @NotNull
    public BooleanStyle getUncheckedStyle() {
        return this.uncheckedStyle;
    }

    @NotNull
    public BooleanStyle getNullStyle() {
        return this.nullStyle;
    }

    @NotNull
    public BooleanMode getMode() {
        return this.checkedStyle.getMode();
    }

    @NotNull
    public RGB getDefaultColor() {
        return this.defaultColor;
    }

    public static BooleanStyleSet getDefaultStyles(@NotNull DBPPreferenceStore store) {
        BooleanMode mode = (BooleanMode)CommonUtils.valueOf(BooleanMode.class, (String)store.getString("ui.render.boolean.style.mode"));
        return BooleanStyleSet.getDefaultStyles(store, mode);
    }

    @NotNull
    public static BooleanStyleSet getDefaultStyles(@NotNull DBPPreferenceStore store, @Nullable BooleanMode mode) {
        RGB defaultColor = UIStyles.getDefaultTextForeground().getRGB();
        if (mode != null) {
            return new BooleanStyleSet(BooleanStyleSet.getDefaultStyle(store, mode, BooleanState.CHECKED, defaultColor), BooleanStyleSet.getDefaultStyle(store, mode, BooleanState.UNCHECKED, defaultColor), BooleanStyleSet.getDefaultStyle(store, mode, BooleanState.NULL, defaultColor), defaultColor);
        }
        return new BooleanStyleSet(BooleanStyleSet.getDefaultStyleLegacy(store, BooleanState.CHECKED, defaultColor), BooleanStyleSet.getDefaultStyleLegacy(store, BooleanState.UNCHECKED, defaultColor), BooleanStyleSet.getDefaultStyleLegacy(store, BooleanState.NULL, defaultColor), defaultColor);
    }

    public static void setDefaultStyles(@NotNull DBPPreferenceStore store, @NotNull BooleanStyleSet set) {
        store.setValue("ui.render.boolean.style.mode", set.getMode().name());
        BooleanStyleSet.setDefaultStyle(store, set.getCheckedStyle(), BooleanState.CHECKED, set.getDefaultColor());
        BooleanStyleSet.setDefaultStyle(store, set.getUncheckedStyle(), BooleanState.UNCHECKED, set.getDefaultColor());
        BooleanStyleSet.setDefaultStyle(store, set.getNullStyle(), BooleanState.NULL, set.getDefaultColor());
    }

    public static void installStyleChangeListener(@NotNull Control control, @NotNull IPropertyChangeListener listener) {
        DBPPreferenceListener preferenceListener = e -> listener.propertyChange(new PropertyChangeEvent(e.getSource(), e.getProperty(), e.getOldValue(), e.getNewValue()));
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(listener);
        DBWorkbench.getPlatform().getPreferenceStore().addPropertyChangeListener(preferenceListener);
        DBWorkbench.getPlatform().getDataSourceProviderRegistry().getGlobalDataSourcePreferenceStore().addPropertyChangeListener(preferenceListener);
        control.addDisposeListener(e -> {
            DBWorkbench.getPlatform().getDataSourceProviderRegistry().getGlobalDataSourcePreferenceStore().removePropertyChangeListener(preferenceListener);
            DBWorkbench.getPlatform().getPreferenceStore().removePropertyChangeListener(preferenceListener);
            PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(listener);
        });
    }

    @NotNull
    private static BooleanStyle getDefaultStyle(@NotNull DBPPreferenceStore store, @NotNull BooleanMode mode, @NotNull BooleanState state, @NotNull RGB defaultColor) {
        String namespace = "ui.render.boolean.style." + state.getId() + '.';
        if (mode == BooleanMode.TEXT) {
            String text = store.getString(String.valueOf(namespace) + PROP_TEXT);
            UIElementAlignment alignment = (UIElementAlignment)CommonUtils.valueOf(UIElementAlignment.class, (String)store.getString(String.valueOf(namespace) + PROP_ALIGN), (Enum)UIElementAlignment.CENTER);
            RGB color = BooleanStyleSet.convertStringToColor(store.getString(String.valueOf(namespace) + PROP_COLOR), defaultColor);
            return BooleanStyle.usingText(text.trim(), alignment, color);
        }
        UIElementAlignment alignment = (UIElementAlignment)CommonUtils.valueOf(UIElementAlignment.class, (String)store.getString(String.valueOf(namespace) + PROP_ALIGN), (Enum)UIElementAlignment.CENTER);
        return BooleanStyle.usingIcon(state.getIcon(), alignment);
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private static BooleanStyle getDefaultStyleLegacy(@NotNull DBPPreferenceStore store, @NotNull BooleanState state, @NotNull RGB color) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[7] lbl41 : CaseStatement: default:\u000a, @NONE, blocks:[7] lbl41 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void setDefaultStyle(@NotNull DBPPreferenceStore store, @NotNull BooleanStyle style, @NotNull BooleanState state, @NotNull RGB defaultColor) {
        String namespace = "ui.render.boolean.style." + state.getId() + '.';
        if (style.getMode() == BooleanMode.TEXT) {
            store.setValue(String.valueOf(namespace) + PROP_TEXT, style.getText().trim());
            store.setValue(String.valueOf(namespace) + PROP_ALIGN, style.getAlignment().name());
            store.setValue(String.valueOf(namespace) + PROP_COLOR, BooleanStyleSet.convertColorToString(style.getColor(), defaultColor));
        } else {
            store.setValue(String.valueOf(namespace) + PROP_ALIGN, style.getAlignment().name());
        }
    }

    @NotNull
    private static String convertColorToString(@NotNull RGB color, @NotNull RGB defaultColor) {
        return color == defaultColor ? COLOR_DEFAULT : StringConverter.asString((RGB)color);
    }

    @NotNull
    private static RGB convertStringToColor(@NotNull String color, @NotNull RGB defaultColor) {
        return COLOR_DEFAULT.equals(color) ? defaultColor : StringConverter.asRGB((String)color, (RGB)defaultColor);
    }
}

