/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.connection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DBPConnectionBootstrap {
    private String defaultCatalogName;
    private String defaultSchemaName;
    private Boolean defaultAutoCommit;
    private Integer defaultTransactionIsolation;
    private final List<String> initQueries;
    private boolean ignoreErrors;

    public DBPConnectionBootstrap() {
        this.initQueries = new ArrayList<String>();
        this.ignoreErrors = false;
    }

    public DBPConnectionBootstrap(DBPConnectionBootstrap info) {
        this.defaultCatalogName = info.defaultCatalogName;
        this.defaultSchemaName = info.defaultSchemaName;
        this.defaultAutoCommit = info.defaultAutoCommit;
        this.defaultTransactionIsolation = info.defaultTransactionIsolation;
        this.initQueries = new ArrayList<String>(info.initQueries);
        this.ignoreErrors = info.ignoreErrors;
    }

    public List<String> getInitQueries() {
        return this.initQueries;
    }

    public void setInitQueries(Collection<String> queries) {
        this.initQueries.clear();
        this.initQueries.addAll(queries);
    }

    public String getDefaultCatalogName() {
        return this.defaultCatalogName;
    }

    public void setDefaultCatalogName(String defaultCatalogName) {
        this.defaultCatalogName = defaultCatalogName;
    }

    public String getDefaultSchemaName() {
        return this.defaultSchemaName;
    }

    public void setDefaultSchemaName(String defaultSchemaName) {
        this.defaultSchemaName = defaultSchemaName;
    }

    public Boolean getDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(Boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
    }

    public Integer getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public void setDefaultTransactionIsolation(Integer defaultTransactionIsolation) {
        this.defaultTransactionIsolation = defaultTransactionIsolation;
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    public boolean hasData() {
        return this.defaultAutoCommit != null || this.defaultTransactionIsolation != null || !CommonUtils.isEmpty((String)this.defaultCatalogName) || !CommonUtils.isEmpty((String)this.defaultSchemaName) || this.ignoreErrors || !CommonUtils.isEmpty(this.initQueries);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DBPConnectionBootstrap)) {
            return false;
        }
        DBPConnectionBootstrap source = (DBPConnectionBootstrap)obj;
        return CommonUtils.equalObjects((Object)this.defaultCatalogName, (Object)source.defaultCatalogName) && CommonUtils.equalObjects((Object)this.defaultSchemaName, (Object)source.defaultSchemaName) && CommonUtils.equalObjects((Object)this.defaultAutoCommit, (Object)source.defaultAutoCommit) && CommonUtils.equalObjects((Object)this.defaultTransactionIsolation, (Object)source.defaultTransactionIsolation) && CommonUtils.equalObjects(this.initQueries, source.initQueries) && this.ignoreErrors == source.ignoreErrors;
    }

    void resolveDynamicVariables(IVariableResolver variableResolver) {
        this.defaultCatalogName = GeneralUtils.replaceVariables(this.defaultCatalogName, variableResolver);
        this.defaultSchemaName = GeneralUtils.replaceVariables(this.defaultSchemaName, variableResolver);
        int i = 0;
        while (i < this.initQueries.size()) {
            this.initQueries.set(i, GeneralUtils.replaceVariables(this.initQueries.get(i), variableResolver));
            ++i;
        }
    }
}

