/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.connection;

import java.io.File;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class LocalNativeClientLocation
implements DBPNativeClientLocation {
    private final String id;
    private final File path;

    public LocalNativeClientLocation(String id, String path) {
        this.id = id;
        this.path = new File(path != null ? path : id);
    }

    @Override
    @NotNull
    public String getName() {
        return this.id;
    }

    @Override
    @NotNull
    public File getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.path.getAbsolutePath();
    }

    @Override
    public boolean validateFilesPresence(DBRProgressMonitor progressMonitor) {
        return true;
    }

    public String toString() {
        File path = this.getPath();
        return "Local: " + path.getAbsolutePath();
    }

    public boolean equals(Object obj) {
        return obj instanceof DBPNativeClientLocation && ((DBPNativeClientLocation)obj).getName().equals(this.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

