/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl;

import java.io.PrintWriter;
import java.util.Arrays;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionResult;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.DefaultServerOutputReader;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class AsyncServerOutputReader
extends DefaultServerOutputReader {
    private static final Log log = Log.getLog(AsyncServerOutputReader.class);

    @Override
    public boolean isAsyncOutputReadSupported() {
        return true;
    }

    @Override
    public void readServerOutput(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext context, DBCExecutionResult executionResult, DBCStatement statement, @NotNull PrintWriter output) throws DBCException {
        if (statement == null) {
            super.readServerOutput(monitor, context, executionResult, null, output);
        } else {
            Throwable[] statementWarnings = statement.getStatementWarnings();
            if (statementWarnings != null && statementWarnings.length > 0) {
                this.dumpWarnings(output, Arrays.asList(statementWarnings));
            }
        }
    }
}

