/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.edit;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.edit.GenericTableColumnManager;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableForeignKey;
import org.jkiss.dbeaver.ext.generic.model.GenericTableIndex;
import org.jkiss.dbeaver.ext.generic.model.GenericUniqueKey;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableManager;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeItem;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.utils.CommonUtils;

public class GenericTableManager
extends SQLTableManager<GenericTableBase, GenericStructContainer> {
    private static final Class<?>[] CHILD_TYPES = new Class[]{GenericTableColumn.class, GenericUniqueKey.class, GenericTableForeignKey.class, GenericTableIndex.class};

    @Nullable
    public DBSObjectCache<? extends DBSObject, GenericTableBase> getObjectsCache(GenericTableBase object) {
        return ((GenericStructContainer)object.getContainer()).getTableCache();
    }

    @NotNull
    public Class<?>[] getChildTypes() {
        return CHILD_TYPES;
    }

    public boolean canCreateObject(Object container) {
        return super.canCreateObject(container);
    }

    protected GenericTableBase createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        List folderChildren;
        GenericStructContainer structContainer = (GenericStructContainer)container;
        boolean isView = false;
        Object navContainer = options.get("container");
        if (navContainer instanceof DBNDatabaseFolder && (folderChildren = ((DBNDatabaseFolder)navContainer).getMeta().getChildren((DBNNode)navContainer)).size() == 1 && folderChildren.get(0) instanceof DBXTreeItem && ((DBXTreeItem)folderChildren.get(0)).getPropertyName().equals("views")) {
            isView = true;
        }
        String tableName = this.getNewChildName(monitor, (DBSObject)structContainer, isView ? "NewView" : "NewTable");
        return structContainer.getDataSource().getMetaModel().createTableImpl(structContainer, tableName, isView ? "VIEW" : "TABLE", null);
    }

    protected boolean excludeFromDDL(SQLObjectEditor.NestedObjectCommand command, Collection<SQLObjectEditor.NestedObjectCommand> orderedCommands) {
        DBPObject object = command.getObject();
        if (object instanceof DBSTableIndex) {
            for (SQLObjectEditor.NestedObjectCommand ccom : orderedCommands) {
                if (!(ccom.getObject() instanceof DBSEntityConstraint) || ccom.getObject() == object || !((DBSEntityConstraint)ccom.getObject()).getConstraintType().isUnique() || !CommonUtils.equalObjects((Object)((DBSTableIndex)object).getName(), (Object)((DBSEntityConstraint)ccom.getObject()).getName())) continue;
                return true;
            }
        }
        return false;
    }

    protected void addObjectExtraActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.NestedObjectCommand<GenericTableBase, SQLObjectEditor.PropertyHandler> command, Map<String, Object> options) throws DBException {
        GenericTableBase tableBase = (GenericTableBase)command.getObject();
        if (command.hasProperty((Object)"description")) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment table", "COMMENT ON TABLE " + tableBase.getFullyQualifiedName(DBPEvaluationContext.DDL) + " IS " + SQLUtils.quoteString((DBSObject)tableBase, (String)CommonUtils.notEmpty((String)tableBase.getDescription()))));
        }
        if (!tableBase.isPersisted()) {
            for (GenericTableColumn column : CommonUtils.safeCollection(tableBase.getAttributes(monitor))) {
                if (CommonUtils.isEmpty((String)column.getDescription())) continue;
                GenericTableColumnManager.addColumnCommentAction(actions, (DBSEntityAttribute)column, (DBSEntity)column.getTable());
            }
        }
    }
}

