/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.editors;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.editors.BaseValueEditor;
import org.jkiss.utils.CommonUtils;

public class URLPreviewEditor
extends BaseValueEditor<Browser> {
    private String lastURL;

    public URLPreviewEditor(IValueController controller) {
        super(controller);
    }

    @Override
    protected Browser createControl(Composite editPlaceholder) {
        Browser browser = new Browser(editPlaceholder, 0);
        return browser;
    }

    @Override
    public void primeEditorValue(@Nullable Object value) throws DBException {
        if (this.control != null) {
            String strValue = this.valueController.getValueHandler().getValueDisplayString(this.valueController.getValueType(), value, DBDDisplayFormat.EDIT);
            if (CommonUtils.equalObjects((Object)this.lastURL, (Object)strValue)) {
                return;
            }
            this.lastURL = strValue;
            ((Browser)this.control).setUrl("about:blank");
            ((Browser)this.control).setText("<div>Loading " + strValue + "...</div>");
            ((Browser)this.control).setUrl(strValue);
        }
    }

    @Override
    public Object extractEditorValue() throws DBCException {
        return this.control == null ? null : ((Browser)this.control).getUrl();
    }
}

