/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.exec;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDataFormatterProfile;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCStatementImpl;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.sql.DBSQLException;
import org.jkiss.dbeaver.model.sql.SQLUtils;

public class JDBCPreparedStatementImpl
extends JDBCStatementImpl<PreparedStatement>
implements JDBCPreparedStatement {
    private static final Log log = Log.getLog(JDBCPreparedStatementImpl.class);
    private static final Object NULL_VALUE = new Object();
    private Map<Object, Object> paramMap;

    JDBCPreparedStatementImpl(@NotNull JDBCSession connection, @NotNull PreparedStatement original, String query, boolean disableLogging) {
        super(connection, original, disableLogging);
        this.setQueryString(query);
    }

    @Override
    public PreparedStatement getOriginal() {
        return (PreparedStatement)this.original;
    }

    @Override
    public void close() {
        if (this.paramMap != null) {
            this.paramMap.clear();
            this.paramMap = null;
        }
        super.close();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String getFormattedQuery() {
        if (this.paramMap == null) {
            return this.getQueryString();
        }
        String q = this.getQueryString();
        if (q == null) {
            return "";
        }
        int length = q.length();
        StringBuilder formatted = new StringBuilder(length * 2);
        int paramIndex = 0;
        int i = 0;
        while (i < length) {
            block10: {
                char c = q.charAt(i);
                block0 : switch (c) {
                    case '?': {
                        Object paramValue = this.paramMap.get(++paramIndex);
                        if (paramValue == null) break;
                        formatted.append(this.formatParameterValue(paramValue));
                        break block10;
                    }
                    case ':': {
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        formatted.append(c);
                        int k = i + 1;
                        while (k < length) {
                            char c2 = q.charAt(k);
                            if (c2 == c && q.charAt(k - 1) != '\\') {
                                i = k;
                                c = c2;
                                break block0;
                            }
                            formatted.append(c2);
                            ++k;
                        }
                        break block0;
                    }
                }
                formatted.append(c);
            }
            ++i;
        }
        return formatted.toString();
    }

    @NotNull
    private String formatParameterValue(Object value) {
        if (value instanceof CharSequence) {
            return SQLUtils.quoteString(((JDBCSession)this.connection).getDataSource(), value.toString());
        }
        if (value instanceof Number) {
            return DBValueFormatting.convertNumberToNativeString((Number)value, false);
        }
        if (value instanceof java.util.Date) {
            try {
                DBDDataFormatterProfile formatterProfile = ((JDBCSession)this.getSession()).getDataFormatterProfile();
                if (value instanceof Date) {
                    return SQLUtils.quoteString(((JDBCSession)this.connection).getDataSource(), formatterProfile.createFormatter("date", null).formatValue(value));
                }
                if (value instanceof Time) {
                    return SQLUtils.quoteString(((JDBCSession)this.connection).getDataSource(), formatterProfile.createFormatter("time", null).formatValue(value));
                }
                return SQLUtils.quoteString(((JDBCSession)this.connection).getDataSource(), formatterProfile.createFormatter("timestamptz", null).formatValue(value));
            }
            catch (Exception e) {
                log.debug("Error formatting date [" + value + "]", e);
            }
        } else if (value == NULL_VALUE) {
            return "NULL";
        }
        return value.toString();
    }

    protected void handleStatementBind(Object parameter, @Nullable Object o) {
        if (this.isQMLoggingEnabled()) {
            if (o == null) {
                o = NULL_VALUE;
            } else if (!DBUtils.isAtomicParameter(o)) {
                o = new ContentParameter((JDBCSession)this.connection, o);
            }
            if (this.paramMap == null) {
                this.paramMap = new LinkedHashMap<Object, Object>();
            }
            this.paramMap.put(parameter, o);
            if (((JDBCSession)this.getSession()).isLoggingEnabled()) {
                QMUtils.getDefaultHandler().handleStatementBind(this, parameter, o);
            }
        }
    }

    @Override
    public boolean executeStatement() throws DBCException {
        try {
            return this.execute();
        }
        catch (SQLException e) {
            throw new DBSQLException(this.query, (Throwable)e, ((JDBCSession)this.connection).getExecutionContext());
        }
    }

    @Override
    public void addToBatch() throws DBCException {
        try {
            this.addBatch();
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, ((JDBCSession)this.connection).getExecutionContext());
        }
    }

    @Override
    public JDBCResultSet executeQuery() throws SQLException {
        this.beforeExecute();
        try {
            JDBCResultSet jDBCResultSet = this.createResultSetImpl(this.getOriginal().executeQuery());
            return jDBCResultSet;
        }
        catch (Throwable e) {
            throw super.handleExecuteError(e);
        }
        finally {
            super.afterExecute();
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.beforeExecute();
        try {
            int n = this.getOriginal().executeUpdate();
            return n;
        }
        catch (Throwable e) {
            throw super.handleExecuteError(e);
        }
        finally {
            super.afterExecute();
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.beforeExecute();
        try {
            boolean bl = this.getOriginal().execute();
            return bl;
        }
        catch (Throwable e) {
            throw super.handleExecuteError(e);
        }
        finally {
            super.afterExecute();
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.getOriginal().setNull(parameterIndex, sqlType);
        this.handleStatementBind(parameterIndex, null);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.getOriginal().setBoolean(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.getOriginal().setByte(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.getOriginal().setShort(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.getOriginal().setInt(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.getOriginal().setLong(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.getOriginal().setFloat(parameterIndex, x);
        this.handleStatementBind(parameterIndex, Float.valueOf(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.getOriginal().setDouble(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.getOriginal().setBigDecimal(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.getOriginal().setString(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.getOriginal().setBytes(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.getOriginal().setDate(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.getOriginal().setTime(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.getOriginal().setTimestamp(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.getOriginal().setAsciiStream(parameterIndex, x, length);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.getOriginal().setUnicodeStream(parameterIndex, x, length);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.getOriginal().setBinaryStream(parameterIndex, x, length);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.getOriginal().clearParameters();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.getOriginal().setObject(parameterIndex, x, targetSqlType);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.getOriginal().setObject(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void addBatch() throws SQLException {
        this.getOriginal().addBatch();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.getOriginal().setCharacterStream(parameterIndex, reader, length);
        this.handleStatementBind(parameterIndex, reader);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.getOriginal().setRef(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.getOriginal().setBlob(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.getOriginal().setClob(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.getOriginal().setArray(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.getOriginal().getMetaData();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.getOriginal().setDate(parameterIndex, x, cal);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.getOriginal().setTime(parameterIndex, x, cal);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.getOriginal().setTimestamp(parameterIndex, x, cal);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.getOriginal().setNull(parameterIndex, sqlType, typeName);
        this.handleStatementBind(parameterIndex, null);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.getOriginal().setURL(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.getOriginal().getParameterMetaData();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.getOriginal().setRowId(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setNString(int parameterIndex, String x) throws SQLException {
        this.getOriginal().setNString(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        this.getOriginal().setNCharacterStream(parameterIndex, x, length);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setNClob(int parameterIndex, NClob x) throws SQLException {
        this.getOriginal().setNClob(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setClob(int parameterIndex, Reader x, long length) throws SQLException {
        this.getOriginal().setClob(parameterIndex, x, length);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream x, long length) throws SQLException {
        this.getOriginal().setBlob(parameterIndex, x, length);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setNClob(int parameterIndex, Reader x, long length) throws SQLException {
        this.getOriginal().setNClob(parameterIndex, x, length);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.getOriginal().setSQLXML(parameterIndex, xmlObject);
        this.handleStatementBind(parameterIndex, xmlObject);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.getOriginal().setObject(parameterIndex, x, targetSqlType, scaleOrLength);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.getOriginal().setAsciiStream(parameterIndex, x, length);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.getOriginal().setBinaryStream(parameterIndex, x, length);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        this.getOriginal().setCharacterStream(parameterIndex, x, length);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.getOriginal().setAsciiStream(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.getOriginal().setBinaryStream(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x) throws SQLException {
        this.getOriginal().setCharacterStream(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader x) throws SQLException {
        this.getOriginal().setNCharacterStream(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setClob(int parameterIndex, Reader x) throws SQLException {
        this.getOriginal().setClob(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream x) throws SQLException {
        this.getOriginal().setBlob(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setNClob(int parameterIndex, Reader x) throws SQLException {
        this.getOriginal().setNClob(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    protected static class ContentParameter {
        String displayString;

        ContentParameter(JDBCSession session, Object value) {
            if (value instanceof RowId) {
                this.displayString = SQLUtils.quoteString(session.getDataSource(), new String(((RowId)value).getBytes()));
            } else if (value instanceof byte[]) {
                byte[] bytes = (byte[])value;
                this.displayString = DBValueFormatting.formatBinaryString(session.getDataSource(), bytes, DBDDisplayFormat.NATIVE, true);
            } else {
                this.displayString = "DATA(" + (value == null ? "[NULL]" : value.getClass().getSimpleName()) + ")";
            }
        }

        public String toString() {
            return this.displayString;
        }
    }
}

