/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.object.struct;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeItem;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.struct.rdb.DBSSequence;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.model.virtual.DBVContainer;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraint;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKey;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKeyColumn;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CSmartCombo;
import org.jkiss.dbeaver.ui.controls.ObjectContainerSelectorPanel;
import org.jkiss.dbeaver.ui.editors.internal.EditorsMessages;
import org.jkiss.dbeaver.ui.editors.object.struct.BaseObjectEditPage;
import org.jkiss.dbeaver.ui.editors.object.struct.EditConstraintPage;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class EditForeignKeyPage
extends BaseObjectEditPage {
    private static final String CONTAINER_LOGICAL_FK = "container.logical-fk";
    private static final Log log = Log.getLog(EditForeignKeyPage.class);
    private static final FKType FK_TYPE_PHYSICAL = new FKType("Physical", true);
    public static final FKType FK_TYPE_LOGICAL = new FKType("Logical", false);
    private final DBSForeignKeyModifyRule[] supportedModifyRules;
    private final DBSEntityAssociation foreignKey;
    private DBSEntity curRefTable;
    private List<DBSEntityConstraint> curConstraints;
    private DBNDatabaseNode ownerTableNode;
    private DBNDatabaseNode ownerContainerNode;
    private Table tableList;
    private Combo uniqueKeyCombo;
    private Text fkNameText;
    private Table columnsTable;
    private Button customUKButton;
    private String fkName;
    private DBSEntityConstraint curConstraint;
    private List<? extends DBSEntityAttribute> ownColumns;
    private final List<FKColumnInfo> fkColumns = new ArrayList<FKColumnInfo>();
    private DBSForeignKeyModifyRule onDeleteRule;
    private DBSForeignKeyModifyRule onUpdateRule;
    private boolean enableCustomKeys = false;
    private boolean supportsCustomName = false;
    private FKType[] allowedKeyTypes = new FKType[]{FK_TYPE_PHYSICAL};
    private FKType preferredKeyType = FK_TYPE_PHYSICAL;
    private FKType selectedKeyType = FK_TYPE_PHYSICAL;
    private List<DBSEntityAttribute> sourceAttributes;
    private List<DBSEntityAttribute> refAttributes;
    private final List<Control> physicalKeyComponents = new ArrayList<Control>();

    public EditForeignKeyPage(String title, DBSEntityAssociation foreignKey, DBSForeignKeyModifyRule[] supportedModifyRules) {
        super(title);
        DBSEntityConstraint refConstraint;
        this.foreignKey = foreignKey;
        this.ownerTableNode = DBWorkbench.getPlatform().getNavigatorModel().findNode((DBSObject)foreignKey.getParentObject());
        this.supportedModifyRules = supportedModifyRules;
        if (this.ownerTableNode == null) {
            try {
                DBSEntity realEntity;
                if (foreignKey.getParentObject() instanceof DBVEntity && (realEntity = ((DBVEntity)foreignKey.getParentObject()).getRealEntity((DBRProgressMonitor)new VoidProgressMonitor())) != null) {
                    this.ownerTableNode = DBWorkbench.getPlatform().getNavigatorModel().getNodeByObject((DBSObject)realEntity);
                    if (this.ownerTableNode == null) {
                        try {
                            UIUtils.runInProgressDialog(monitor -> {
                                DBNDatabaseNode dBNDatabaseNode = this.ownerTableNode = DBWorkbench.getPlatform().getNavigatorModel().getNodeByObject(monitor, (DBSObject)realEntity, true);
                            });
                        }
                        catch (InvocationTargetException e) {
                            this.setErrorMessage(e.getTargetException().getMessage());
                            log.error((Object)e.getTargetException());
                        }
                    }
                }
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
        if (this.ownerTableNode != null) {
            this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)this.ownerTableNode.getNodeIcon()));
            this.setTitle(String.valueOf(title) + " | " + NLS.bind((String)EditorsMessages.dialog_struct_edit_fk_title, (Object)title, (Object)this.ownerTableNode.getNodeName()));
        }
        if (!(foreignKey.getParentObject() instanceof DBVEntity) && (refConstraint = foreignKey.getReferencedConstraint()) != null) {
            this.curRefTable = refConstraint.getParentObject();
            this.curConstraint = refConstraint;
        }
    }

    public boolean isEnableCustomKeys() {
        return this.enableCustomKeys;
    }

    private void setEnableCustomKeys(boolean enableCustomKeys) {
        this.enableCustomKeys = enableCustomKeys;
    }

    private void setAllowedKeyTypes(FKType[] allowedKeyTypes) {
        this.allowedKeyTypes = allowedKeyTypes;
        this.setPreferredKeyType(allowedKeyTypes[0]);
    }

    private void setPreferredKeyType(FKType preferredKeyType) {
        this.preferredKeyType = preferredKeyType;
        this.selectedKeyType = preferredKeyType;
    }

    private void setRefTable(DBSEntity curRefTable) {
        this.curRefTable = curRefTable;
    }

    protected void addPhysicalKeyComponent(Control control) {
        this.physicalKeyComponents.add(control);
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        this.updateControlsVisibility();
        if (this.curRefTable != null) {
            this.handleRefTableSelect();
        }
        UIUtils.asyncExec(() -> UIUtils.packColumns((Table)this.columnsTable, (boolean)true));
    }

    protected Composite createPageContents(Composite parent) {
        Composite panel = UIUtils.createComposite((Composite)parent, (int)1);
        panel.setLayoutData((Object)new GridData(1808));
        Composite tableGroup = UIUtils.createComposite((Composite)panel, (int)2);
        tableGroup.setLayoutData((Object)new GridData(768));
        UIUtils.createLabelText((Composite)tableGroup, (String)EditorsMessages.dialog_struct_edit_fk_label_table, (String)DBUtils.getObjectFullName((DBPNamedObject)this.foreignKey.getParentObject(), (DBPEvaluationContext)DBPEvaluationContext.UI), (int)2056);
        if (this.allowedKeyTypes.length > 1) {
            UIUtils.createControlLabel((Composite)tableGroup, (String)"Key type");
            Composite ktPanel = UIUtils.createFormPlaceholder((Composite)tableGroup, (int)this.allowedKeyTypes.length, (int)1);
            FKType[] fKTypeArray = this.allowedKeyTypes;
            int n = this.allowedKeyTypes.length;
            int n2 = 0;
            while (n2 < n) {
                FKType type = fKTypeArray[n2];
                Button keyTypeButton = UIUtils.createRadioButton((Composite)ktPanel, (String)type.getName(), (Object)type, (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        EditForeignKeyPage.this.selectedKeyType = (FKType)e.widget.getData();
                        EditForeignKeyPage.this.updateControlsVisibility();
                    }
                });
                if (type == this.preferredKeyType) {
                    keyTypeButton.setSelection(true);
                }
                ++n2;
            }
        }
        if (this.curRefTable == null) {
            try {
                if (this.foreignKey instanceof DBVEntityForeignKey) {
                    this.createContainerSelector(tableGroup);
                } else if (this.ownerTableNode != null) {
                    this.createSchemaSelector(tableGroup);
                }
            }
            catch (Throwable e2) {
                log.debug((Object)"Can't create schema selector", e2);
            }
        } else {
            UIUtils.createLabelText((Composite)tableGroup, (String)EditorsMessages.dialog_struct_edit_fk_label_ref_table, (String)DBUtils.getObjectFullName((DBPNamedObject)this.curRefTable, (DBPEvaluationContext)DBPEvaluationContext.UI), (int)2056);
        }
        if (this.curRefTable == null) {
            DBNNode containerNode = this.ownerTableNode == null ? null : this.ownerTableNode.getParentNode();
            while (containerNode instanceof DBNDatabaseFolder) {
                containerNode = containerNode.getParentNode();
            }
            DBNNode rootNode = containerNode == null ? DBWorkbench.getPlatform().getNavigatorModel().getRoot() : containerNode;
            UIUtils.createControlLabel((Composite)panel, (String)EditorsMessages.dialog_struct_edit_fk_label_ref_table);
            this.tableList = new Table(panel, 67588);
            this.tableList.setLinesVisible(true);
            GridData gd = new GridData(1808);
            gd.widthHint = 500;
            gd.heightHint = 150;
            this.tableList.setLayoutData((Object)gd);
            this.tableList.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditForeignKeyPage.this.handleRefTableSelect((DBNDatabaseNode)e.item.getData());
                }
            });
            if (rootNode instanceof DBNDatabaseNode) {
                this.loadTableList((DBNDatabaseNode)rootNode);
            }
        }
        Composite pkGroup = UIUtils.createComposite((Composite)panel, (int)(this.enableCustomKeys ? 3 : 2));
        pkGroup.setLayoutData((Object)new GridData(768));
        this.uniqueKeyCombo = UIUtils.createLabelCombo((Composite)pkGroup, (String)EditorsMessages.dialog_struct_edit_fk_combo_unik, (int)12);
        this.uniqueKeyCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditForeignKeyPage.this.handleUniqueKeySelect();
                EditForeignKeyPage.this.updatePageState();
            }
        });
        if (this.enableCustomKeys) {
            this.customUKButton = UIUtils.createDialogButton((Composite)pkGroup, (String)"Create", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditForeignKeyPage.this.defineRefTableConstraint();
                }
            });
            this.customUKButton.setEnabled(false);
        }
        if (this.supportsCustomName()) {
            this.fkNameText = UIUtils.createLabelText((Composite)pkGroup, (String)EditorsMessages.dialog_struct_edit_fk_name, (String)"");
            this.fkNameText.addModifyListener(e -> {
                String string = this.fkName = this.fkNameText.getText();
            });
        }
        UIUtils.createControlLabel((Composite)panel, (String)EditorsMessages.dialog_struct_edit_fk_label_columns);
        this.columnsTable = new Table(panel, 67588);
        this.columnsTable.setHeaderVisible(true);
        this.columnsTable.setLinesVisible(true);
        GridData gd = new GridData(1808);
        gd.widthHint = 500;
        gd.heightHint = 100;
        this.columnsTable.setLayoutData((Object)gd);
        UIUtils.createTableColumn((Table)this.columnsTable, (int)16384, (String)EditorsMessages.dialog_struct_edit_fk_column_column);
        UIUtils.createTableColumn((Table)this.columnsTable, (int)16384, (String)EditorsMessages.dialog_struct_edit_fk_column_col_type);
        UIUtils.createTableColumn((Table)this.columnsTable, (int)16384, (String)EditorsMessages.dialog_struct_edit_fk_column_ref_col);
        UIUtils.createTableColumn((Table)this.columnsTable, (int)16384, (String)EditorsMessages.dialog_struct_edit_fk_column_ref_col_type);
        TableEditor tableEditor = new TableEditor(this.columnsTable);
        tableEditor.horizontalAlignment = 0x1000000;
        tableEditor.verticalAlignment = 128;
        tableEditor.grabHorizontal = true;
        tableEditor.minimumWidth = 50;
        this.columnsTable.addMouseListener((MouseListener)new ColumnsMouseListener(tableEditor, this.columnsTable));
        if (!ArrayUtils.isEmpty((Object[])this.supportedModifyRules)) {
            Composite cascadeGroup = UIUtils.createPlaceholder((Composite)panel, (int)4, (int)5);
            cascadeGroup.setLayoutData((Object)new GridData(768));
            final Combo onDeleteCombo = UIUtils.createLabelCombo((Composite)cascadeGroup, (String)EditorsMessages.dialog_struct_edit_fk_combo_on_delete, (int)12);
            onDeleteCombo.setLayoutData((Object)new GridData(768));
            final Combo onUpdateCombo = UIUtils.createLabelCombo((Composite)cascadeGroup, (String)EditorsMessages.dialog_struct_edit_fk_combo_on_update, (int)12);
            onUpdateCombo.setLayoutData((Object)new GridData(768));
            DBSForeignKeyModifyRule[] dBSForeignKeyModifyRuleArray = this.supportedModifyRules;
            int n = this.supportedModifyRules.length;
            int n3 = 0;
            while (n3 < n) {
                DBSForeignKeyModifyRule modifyRule = dBSForeignKeyModifyRuleArray[n3];
                onDeleteCombo.add(modifyRule.getName());
                onUpdateCombo.add(modifyRule.getName());
                ++n3;
            }
            onDeleteCombo.select(0);
            onUpdateCombo.select(0);
            this.onDeleteRule = this.onUpdateRule = this.supportedModifyRules[0];
            onDeleteCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditForeignKeyPage.this.onDeleteRule = EditForeignKeyPage.this.supportedModifyRules[onDeleteCombo.getSelectionIndex()];
                }
            });
            onUpdateCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditForeignKeyPage.this.onUpdateRule = EditForeignKeyPage.this.supportedModifyRules[onUpdateCombo.getSelectionIndex()];
                }
            });
            this.addPhysicalKeyComponent((Control)cascadeGroup);
        }
        if (this.tableList != null) {
            this.tableList.setFocus();
        }
        return panel;
    }

    private void updateControlsVisibility() {
        boolean pkVisible = this.selectedKeyType.isPhysical();
        for (Control pkc : this.physicalKeyComponents) {
            pkc.setVisible(pkVisible);
            if (!(pkc.getLayoutData() instanceof GridData)) continue;
            boolean bl = ((GridData)pkc.getLayoutData()).exclude = !pkVisible;
        }
        ((Composite)this.getControl()).layout(true, true);
    }

    private void defineRefTableConstraint() {
        if (this.curRefTable == null) {
            log.error((Object)"No reference table");
            return;
        }
        DBVEntity vRefEntity = DBVUtils.getVirtualEntity((DBSEntity)this.curRefTable, (boolean)true);
        assert (vRefEntity != null);
        DBVEntityConstraint constraint = vRefEntity.getBestIdentifier();
        EditConstraintPage page = new EditConstraintPage("Define unique key", (DBSEntityReferrer)constraint);
        if (page.edit()) {
            constraint.setAttributes(page.getSelectedAttributes());
            this.handleRefTableSelect(DBWorkbench.getPlatform().getNavigatorModel().getNodeByObject((DBSObject)this.curRefTable));
            int constraintIndex = this.curConstraints.indexOf(constraint);
            this.uniqueKeyCombo.select(constraintIndex);
            this.handleUniqueKeySelect();
        }
    }

    private void createSchemaSelector(Composite tableGroup) throws DBException {
        DBNDatabaseNode schemaContainerNode = null;
        DBNNode node = this.ownerTableNode.getParentNode();
        while (node != null) {
            DBSObject nodeObject;
            if (node instanceof DBNDatabaseNode && ((nodeObject = ((DBNDatabaseNode)node).getObject()) instanceof DBSSchema || nodeObject instanceof DBSCatalog) && node.getParentNode() instanceof DBNDatabaseNode) {
                schemaContainerNode = (DBNDatabaseNode)node.getParentNode();
                break;
            }
            node = node.getParentNode();
        }
        if (schemaContainerNode != null) {
            LabelProvider labelProvider = new LabelProvider(){

                public Image getImage(Object element) {
                    return DBeaverIcons.getImage((DBPImage)((DBNDatabaseNode)element).getNodeIcon());
                }

                public String getText(Object element) {
                    return ((DBNDatabaseNode)element).getNodeName();
                }
            };
            boolean cfr_ignored_0 = this.foreignKey.getParentObject().getParentObject() instanceof DBSSchema;
            this.foreignKey.getDataSource().getInfo();
            UIUtils.createControlLabel((Composite)tableGroup, (String)"Container");
            final CSmartCombo schemaCombo = new CSmartCombo(tableGroup, 2048, (ILabelProvider)labelProvider);
            schemaCombo.setLayoutData((Object)new GridData(32));
            DBNDatabaseNode selectedNode = null;
            DBNDatabaseNode[] dBNDatabaseNodeArray = schemaContainerNode.getChildren((DBRProgressMonitor)new VoidProgressMonitor());
            int n = dBNDatabaseNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBNDatabaseNode node2 = dBNDatabaseNodeArray[n2];
                if (node2 instanceof DBNDatabaseNode && node2.getObject() instanceof DBSObjectContainer) {
                    schemaCombo.addItem((Object)node2);
                    if (node2.getObject() == this.foreignKey.getParentObject().getParentObject()) {
                        selectedNode = node2;
                    }
                }
                ++n2;
            }
            if (selectedNode != null) {
                schemaCombo.select(selectedNode);
            }
            schemaCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DBNDatabaseNode newContainerNode = null;
                    DBXTreeNode tableContainerMeta = ((DBNDatabaseNode)EditForeignKeyPage.this.ownerTableNode.getParentNode()).getMeta();
                    DBNDatabaseNode schemaNode = (DBNDatabaseNode)schemaCombo.getSelectedItem();
                    if (schemaNode.getMeta() == tableContainerMeta) {
                        newContainerNode = schemaNode;
                    } else {
                        try {
                            DBNDatabaseNode[] dBNDatabaseNodeArray = schemaNode.getChildren((DBRProgressMonitor)new VoidProgressMonitor());
                            int n = dBNDatabaseNodeArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                DBNDatabaseNode child = dBNDatabaseNodeArray[n2];
                                if (child instanceof DBNDatabaseNode && child.getMeta() == tableContainerMeta) {
                                    newContainerNode = child;
                                    break;
                                }
                                ++n2;
                            }
                        }
                        catch (DBException e1) {
                            log.debug((Object)e1);
                        }
                    }
                    if (newContainerNode != null) {
                        EditForeignKeyPage.this.loadTableList(newContainerNode);
                    }
                }
            });
        }
    }

    private void createContainerSelector(Composite tableGroup) throws DBException {
        ObjectContainerSelectorPanel containerPanel = new ObjectContainerSelectorPanel(tableGroup, this.foreignKey.getDataSource().getContainer().getRegistry().getProject(), CONTAINER_LOGICAL_FK, "Reference table container", "Select reference table catalog/schema"){

            @Nullable
            protected DBNNode getSelectedNode() {
                Object containerObject;
                if (EditForeignKeyPage.this.ownerContainerNode != null) {
                    return EditForeignKeyPage.this.ownerContainerNode;
                }
                if (EditForeignKeyPage.this.ownerTableNode != null) {
                    DBNNode containerNode = EditForeignKeyPage.this.ownerTableNode.getParentNode();
                    while (containerNode instanceof DBNDatabaseFolder) {
                        containerNode = containerNode.getParentNode();
                    }
                    containerObject = containerNode instanceof DBNDatabaseNode ? ((DBNDatabaseNode)containerNode).getObject() : null;
                } else {
                    containerObject = EditForeignKeyPage.this.foreignKey.getParentObject();
                }
                if (containerObject != null && containerObject.getParentObject() instanceof DBSObjectContainer) {
                    containerObject = containerObject.getParentObject();
                }
                if (containerObject instanceof DBVContainer) {
                    try {
                        containerObject = ((DBVContainer)containerObject).getRealContainer((DBRProgressMonitor)new VoidProgressMonitor());
                    }
                    catch (DBException e) {
                        log.error((Object)"Error getting real object container", (Throwable)e);
                    }
                }
                EditForeignKeyPage.this.ownerContainerNode = DBWorkbench.getPlatform().getNavigatorModel().getNodeByObject((DBSObject)containerObject);
                return EditForeignKeyPage.this.ownerContainerNode;
            }

            protected void setSelectedNode(DBNDatabaseNode node) {
                EditForeignKeyPage.this.ownerContainerNode = node;
                if (EditForeignKeyPage.this.ownerContainerNode == null) {
                    this.setContainerInfo(null);
                } else {
                    this.setContainerInfo(node);
                    EditForeignKeyPage.this.loadTableList(EditForeignKeyPage.this.ownerContainerNode);
                }
            }
        };
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        containerPanel.setLayoutData((Object)gd);
        if (this.ownerTableNode != null) {
            DBNNode containerNode = this.ownerTableNode.getParentNode();
            while (containerNode instanceof DBNDatabaseFolder) {
                containerNode = containerNode.getParentNode();
            }
            if (containerNode instanceof DBNDatabaseNode) {
                containerPanel.setContainerInfo((DBNDatabaseNode)containerNode);
            }
        }
    }

    private void loadTableList(DBNDatabaseNode newContainerNode) {
        this.tableList.removeAll();
        ArrayList entities = new ArrayList();
        try {
            UIUtils.runInProgressService(monitor -> {
                try {
                    this.loadEntities(monitor, entities, newContainerNode);
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Error loading tables", "Error during table load", (Throwable)e);
        }
        catch (InterruptedException interruptedException) {}
        for (DBNDatabaseNode entityNode : entities) {
            TableItem tableItem = new TableItem(this.tableList, 16384);
            tableItem.setText(entityNode.getNodeName());
            tableItem.setImage(DBeaverIcons.getImage((DBPImage)entityNode.getNodeIconDefault()));
            tableItem.setData((Object)entityNode);
        }
    }

    private void loadEntities(DBRProgressMonitor monitor, List<DBNDatabaseNode> entities, DBNDatabaseNode container) throws DBException {
        DBNDatabaseNode[] dBNDatabaseNodeArray = container.getChildren(monitor);
        int n = dBNDatabaseNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBSObject object;
            DBNDatabaseNode childNode = dBNDatabaseNodeArray[n2];
            if (monitor.isCanceled()) break;
            if (childNode instanceof DBNDatabaseFolder) {
                Class childrenClass;
                DBXTreeItem itemsMeta = ((DBNDatabaseFolder)childNode).getItemsMeta();
                if (itemsMeta != null && (childrenClass = ((DBNDatabaseFolder)childNode).getChildrenClass(itemsMeta)) != null && DBSEntity.class.isAssignableFrom(childrenClass)) {
                    this.loadEntities(monitor, entities, (DBNDatabaseNode)((DBNDatabaseFolder)childNode));
                }
            } else if (childNode instanceof DBNDatabaseNode && (object = childNode.getObject()) instanceof DBSEntity && !(object instanceof DBSSequence) && !(object instanceof DBSDataType)) {
                entities.add(childNode);
            }
            ++n2;
        }
    }

    private void handleRefTableSelect(DBNDatabaseNode refTableNode) {
        if (refTableNode != null) {
            DBSObject object = refTableNode.getObject();
            if (object instanceof DBSEntity) {
                this.curRefTable = (DBSEntity)refTableNode.getObject();
            }
            if (this.fkNameText != null) {
                this.fkNameText.setText("FK_" + refTableNode.getObject().getName());
            }
        } else {
            this.curRefTable = null;
        }
        this.handleRefTableSelect();
    }

    private void handleRefTableSelect() {
        this.uniqueKeyCombo.removeAll();
        try {
            this.curConstraints = new ArrayList<DBSEntityConstraint>();
            this.curConstraint = null;
            if (this.curRefTable != null) {
                DBSEntity refTable = this.curRefTable;
                UIUtils.runInProgressService(monitor -> {
                    try {
                        Collection indexes;
                        this.foreignKey.getParentObject().getAttributes(monitor);
                        refTable.getAttributes(monitor);
                        List constraints = DBVUtils.getAllConstraints((DBRProgressMonitor)monitor, (DBSEntity)refTable);
                        if (!CommonUtils.isEmpty((Collection)constraints)) {
                            for (DBSEntityConstraint constraint : constraints) {
                                if (!constraint.getConstraintType().isUnique() || !(constraint instanceof DBSEntityReferrer) || !this.isValidRefConstraint(monitor, (DBSEntityReferrer)constraint)) continue;
                                this.curConstraints.add(constraint);
                            }
                        }
                        if (refTable instanceof DBSTable && !CommonUtils.isEmpty((Collection)(indexes = ((DBSTable)refTable).getIndexes(monitor)))) {
                            for (DBSTableIndex constraint : indexes) {
                                if (!constraint.isUnique() || !this.isConstraintIndex(monitor, this.curConstraints, constraint) || !this.isValidRefConstraint(monitor, (DBSEntityReferrer)constraint)) continue;
                                this.curConstraints.add((DBSEntityConstraint)constraint);
                            }
                        }
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                });
                if (CommonUtils.isEmpty(this.curConstraints) && this.enableCustomKeys && !CommonUtils.isEmpty(this.refAttributes)) {
                    DBVEntity vRefEntity = DBVUtils.getVirtualEntity((DBSEntity)this.curRefTable, (boolean)true);
                    assert (vRefEntity != null);
                    DBVEntityConstraint vUniqueKey = new DBVEntityConstraint(vRefEntity, DBSEntityConstraintType.VIRTUAL_KEY, String.valueOf(vRefEntity.getName()) + "_VK");
                    for (DBSEntityAttribute refAttr : this.refAttributes) {
                        vUniqueKey.addAttribute(refAttr.getName());
                    }
                    vRefEntity.addConstraint(vUniqueKey, true);
                    this.curConstraints.add((DBSEntityConstraint)vUniqueKey);
                }
            }
            for (DBSEntityConstraint constraint : this.curConstraints) {
                this.uniqueKeyCombo.add(String.valueOf(constraint.getName()) + " (" + constraint.getConstraintType().getLocalizedName() + ")");
            }
            if (this.uniqueKeyCombo.getItemCount() == 0) {
                if (this.curRefTable == null) {
                    this.uniqueKeyCombo.add("<No reference table selected>");
                } else {
                    this.uniqueKeyCombo.add("<No unique keys in table '" + DBUtils.getObjectFullName((DBPNamedObject)this.curRefTable, (DBPEvaluationContext)DBPEvaluationContext.UI) + "'>");
                }
                this.uniqueKeyCombo.select(0);
                this.curConstraint = null;
            } else {
                this.uniqueKeyCombo.select(0);
                this.curConstraint = this.curConstraints.get(0);
            }
            if (this.enableCustomKeys) {
                this.enableCurConstraintEdit();
            }
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError(EditorsMessages.dialog_struct_edit_fk_error_load_constraints_title, EditorsMessages.dialog_struct_edit_fk_error_load_constraints_message, e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
        this.handleUniqueKeySelect();
        this.updatePageState();
    }

    private void enableCurConstraintEdit() {
        if (this.curConstraint instanceof DBVEntityConstraint) {
            this.customUKButton.setEnabled(true);
            this.customUKButton.setText("Edit");
        } else {
            boolean hasLogicalConstraint = false;
            for (DBSEntityConstraint constraint : this.curConstraints) {
                if (!(constraint instanceof DBVEntityConstraint)) continue;
                hasLogicalConstraint = true;
                break;
            }
            this.customUKButton.setText("Create");
            this.customUKButton.setEnabled(!hasLogicalConstraint);
        }
    }

    private boolean isConstraintIndex(DBRProgressMonitor monitor, List<DBSEntityConstraint> constraints, DBSTableIndex index) throws DBException {
        List iAttrs = index.getAttributeReferences(monitor);
        for (DBSEntityConstraint constraint : constraints) {
            List cAttrs;
            if (!(constraint instanceof DBSEntityReferrer) || !CommonUtils.equalObjects((Object)iAttrs, (Object)(cAttrs = ((DBSEntityReferrer)constraint).getAttributeReferences(monitor)))) continue;
            return true;
        }
        return false;
    }

    private boolean isValidRefConstraint(DBRProgressMonitor monitor, DBSEntityReferrer constraint) throws DBException {
        if (!CommonUtils.isEmpty(this.refAttributes)) {
            for (DBSEntityAttribute refAttr : this.refAttributes) {
                if (DBUtils.getConstraintAttribute((DBRProgressMonitor)monitor, (DBSEntityReferrer)constraint, (DBSEntityAttribute)refAttr) != null) continue;
                return false;
            }
        }
        return true;
    }

    private void handleUniqueKeySelect() {
        this.fkColumns.clear();
        this.ownColumns = null;
        this.columnsTable.removeAll();
        int ukSelectionIndex = this.uniqueKeyCombo.getSelectionIndex();
        if ((this.curConstraints.isEmpty() || ukSelectionIndex < 0) && !this.enableCustomKeys) {
            return;
        }
        if (ukSelectionIndex >= 0) {
            this.curConstraint = this.curConstraints.isEmpty() ? null : this.curConstraints.get(ukSelectionIndex);
        }
        DBSEntity curEntity = this.foreignKey.getParentObject();
        VoidProgressMonitor monitor = new VoidProgressMonitor();
        try {
            List tmpColumns = curEntity.getAttributes((DBRProgressMonitor)monitor);
            ArrayList<DBSEntityAttribute> arrayList = this.ownColumns = tmpColumns == null ? Collections.emptyList() : new ArrayList<DBSEntityAttribute>(EditForeignKeyPage.getValidAttributes(curEntity));
            if (this.curConstraint instanceof DBSEntityReferrer) {
                for (DBSEntityAttributeRef pkColumn : ((DBSEntityReferrer)this.curConstraint).getAttributeReferences((DBRProgressMonitor)monitor)) {
                    DBSEntityAttribute pkAttribute = pkColumn.getAttribute();
                    if (pkAttribute == null) {
                        log.debug((Object)("Constraint " + this.curConstraint.getName() + " column attribute not found"));
                        continue;
                    }
                    FKColumnInfo fkColumnInfo = new FKColumnInfo(pkAttribute);
                    if (!CommonUtils.isEmpty(this.ownColumns)) {
                        for (DBSEntityAttribute dBSEntityAttribute : this.ownColumns) {
                            if (!dBSEntityAttribute.getName().equals(pkAttribute.getName()) || curEntity == pkAttribute.getParentObject()) continue;
                            fkColumnInfo.ownColumn = dBSEntityAttribute;
                            break;
                        }
                    }
                    this.fkColumns.add(fkColumnInfo);
                    TableItem tableItem = new TableItem(this.columnsTable, 0);
                    if (fkColumnInfo.ownColumn != null) {
                        tableItem.setText(0, fkColumnInfo.ownColumn.getName());
                        tableItem.setImage(0, this.getColumnIcon(fkColumnInfo.ownColumn));
                        tableItem.setText(1, fkColumnInfo.ownColumn.getFullTypeName());
                    }
                    tableItem.setText(2, pkAttribute.getName());
                    tableItem.setImage(2, this.getColumnIcon(pkAttribute));
                    tableItem.setText(3, pkAttribute.getFullTypeName());
                    tableItem.setData((Object)fkColumnInfo);
                }
            } else if (this.enableCustomKeys) {
                // empty if block
            }
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError(EditorsMessages.dialog_struct_edit_fk_error_load_constraint_columns_title, EditorsMessages.dialog_struct_edit_fk_error_load_constraint_columns_message, (Throwable)e);
        }
        if (this.enableCustomKeys) {
            this.enableCurConstraintEdit();
        }
        UIUtils.packColumns((Table)this.columnsTable, (boolean)true);
    }

    private static List<DBSEntityAttribute> getValidAttributes(DBSEntity table) throws DBException {
        ArrayList<DBSEntityAttribute> result = new ArrayList<DBSEntityAttribute>();
        for (DBSEntityAttribute attr : table.getAttributes((DBRProgressMonitor)new VoidProgressMonitor())) {
            if (DBUtils.isHiddenObject((Object)attr) || DBUtils.isPseudoAttribute((DBSAttributeBase)attr)) continue;
            result.add(attr);
        }
        return result;
    }

    private Image getColumnIcon(DBSEntityAttribute column) {
        return DBeaverIcons.getImage((DBPImage)DBValueFormatting.getObjectImage((DBPObject)column));
    }

    @Override
    public boolean isPageComplete() {
        if (this.fkColumns.isEmpty()) {
            return false;
        }
        for (FKColumnInfo col : this.fkColumns) {
            if (col.ownColumn != null && col.refColumn != null) continue;
            return false;
        }
        return true;
    }

    public List<FKColumnInfo> getColumns() {
        return this.fkColumns;
    }

    public DBSForeignKeyModifyRule getOnDeleteRule() {
        return this.onDeleteRule;
    }

    public DBSForeignKeyModifyRule getOnUpdateRule() {
        return this.onUpdateRule;
    }

    public DBSEntityConstraint getUniqueConstraint() {
        return this.curConstraint;
    }

    private void assignForeignKeyRefConstraint(FKColumnInfo fkInfo, CCombo columnsCombo, TableItem item) {
        fkInfo.ownColumn = this.ownColumns.get(columnsCombo.getSelectionIndex());
        item.setText(0, fkInfo.ownColumn.getName());
        item.setImage(0, this.getColumnIcon(fkInfo.ownColumn));
        item.setText(1, fkInfo.ownColumn.getFullTypeName());
        this.updatePageState();
    }

    public boolean isEnabled() {
        return true;
    }

    public String getName() {
        return this.fkName;
    }

    protected boolean supportsCustomName() {
        return this.supportsCustomName;
    }

    public void setSupportsCustomName(boolean supportsCustomName) {
        this.supportsCustomName = supportsCustomName;
    }

    private void setSourceAttributes(Collection<? extends DBSEntityAttribute> srcAttributes) {
        this.sourceAttributes = CommonUtils.isEmpty(srcAttributes) ? null : new ArrayList<DBSEntityAttribute>(srcAttributes);
    }

    private void setReferenceAttributes(Collection<? extends DBSEntityAttribute> refAttributes) {
        this.refAttributes = CommonUtils.isEmpty(refAttributes) ? null : new ArrayList<DBSEntityAttribute>(refAttributes);
    }

    @Nullable
    public static DBVEntityForeignKey createVirtualForeignKey(@NotNull DBVEntity vEntity) {
        return EditForeignKeyPage.createVirtualForeignKey(vEntity, null, new FKType[]{FK_TYPE_LOGICAL}, null, null);
    }

    @Nullable
    public static DBVEntityForeignKey createVirtualForeignKey(@NotNull DBVEntity vEntity, @Nullable DBSEntity refEntity, @Nullable FKType[] allowedKeyTypes, @Nullable Collection<? extends DBSEntityAttribute> srcAttributes, @Nullable Collection<? extends DBSEntityAttribute> refAttributes) {
        DBVEntityForeignKey virtualFK = new DBVEntityForeignKey(vEntity);
        EditForeignKeyPage editDialog = new EditForeignKeyPage("Define virtual foreign keys", (DBSEntityAssociation)virtualFK, new DBSForeignKeyModifyRule[]{DBSForeignKeyModifyRule.NO_ACTION});
        editDialog.setEnableCustomKeys(true);
        if (allowedKeyTypes != null) {
            editDialog.setAllowedKeyTypes(allowedKeyTypes);
        }
        if (refEntity != null) {
            editDialog.setRefTable(refEntity);
        }
        if (srcAttributes != null) {
            editDialog.setSourceAttributes(srcAttributes);
        }
        if (refAttributes != null) {
            editDialog.setReferenceAttributes(refAttributes);
        }
        if (!editDialog.edit()) {
            return null;
        }
        try {
            virtualFK.setReferencedConstraint((DBRProgressMonitor)new VoidProgressMonitor(), editDialog.getUniqueConstraint());
        }
        catch (DBException e1) {
            log.error((Object)e1);
            return null;
        }
        ArrayList<DBVEntityForeignKeyColumn> columns = new ArrayList<DBVEntityForeignKeyColumn>();
        for (FKColumnInfo tableColumn : editDialog.getColumns()) {
            columns.add(new DBVEntityForeignKeyColumn(virtualFK, tableColumn.getOwnColumn().getName(), tableColumn.getRefColumn().getName()));
        }
        virtualFK.setAttributes(columns);
        vEntity.addForeignKey(virtualFK);
        return virtualFK;
    }

    private class ColumnsMouseListener
    extends MouseAdapter {
        private final TableEditor tableEditor;
        private final Table columnsTable;

        ColumnsMouseListener(TableEditor tableEditor, Table columnsTable) {
            this.tableEditor = tableEditor;
            this.columnsTable = columnsTable;
        }

        private void disposeOldEditor() {
            Control oldEditor = this.tableEditor.getEditor();
            if (oldEditor != null) {
                oldEditor.dispose();
            }
        }

        public void mouseUp(MouseEvent e) {
            this.handleColumnClick(e);
        }

        private void handleColumnClick(MouseEvent e) {
            this.disposeOldEditor();
            final TableItem item = this.columnsTable.getItem(new Point(e.x, e.y));
            if (item == null) {
                return;
            }
            final FKColumnInfo fkInfo = (FKColumnInfo)item.getData();
            int columnIndex = UIUtils.getColumnAtPos((TableItem)item, (int)e.x, (int)e.y);
            if (fkInfo.ownColumn == null && columnIndex != 0) {
                return;
            }
            if (fkInfo.refColumn == null && columnIndex != 2) {
                return;
            }
            final CCombo columnsCombo = new CCombo((Composite)this.columnsTable, 12);
            if (!CommonUtils.isEmpty(EditForeignKeyPage.this.ownColumns)) {
                for (DBSEntityAttribute dBSEntityAttribute : EditForeignKeyPage.this.ownColumns) {
                    columnsCombo.add(dBSEntityAttribute.getName());
                    if (fkInfo.ownColumn != dBSEntityAttribute) continue;
                    columnsCombo.select(columnsCombo.getItemCount() - 1);
                }
                if (columnsCombo.getSelectionIndex() < 0) {
                    columnsCombo.select(0);
                }
            }
            columnsCombo.setFocus();
            columnsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (columnsCombo.getSelectionIndex() >= 0) {
                        EditForeignKeyPage.this.assignForeignKeyRefConstraint(fkInfo, columnsCombo, item);
                    }
                }
            });
            columnsCombo.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    if (columnsCombo.getSelectionIndex() >= 0) {
                        EditForeignKeyPage.this.assignForeignKeyRefConstraint(fkInfo, columnsCombo, item);
                    }
                    ColumnsMouseListener.this.disposeOldEditor();
                }
            });
            this.tableEditor.setEditor((Control)columnsCombo, item, 0);
        }
    }

    public static class FKColumnInfo {
        final DBSEntityAttribute refColumn;
        DBSEntityAttribute ownColumn;

        FKColumnInfo(DBSEntityAttribute refColumn) {
            this.refColumn = refColumn;
        }

        public DBSEntityAttribute getRefColumn() {
            return this.refColumn;
        }

        public DBSEntityAttribute getOwnColumn() {
            return this.ownColumn;
        }
    }

    public static class FKType
    implements DBPNamedObject {
        private final String name;
        private final boolean physical;

        FKType(String name, boolean physical) {
            this.name = name;
            this.physical = physical;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        public boolean isPhysical() {
            return this.physical;
        }
    }
}

