/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.sql.ResultSet;
import java.util.Date;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDatabase;
import org.jkiss.dbeaver.model.DBPStatefulObject;
import org.jkiss.dbeaver.model.access.DBAUser;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.utils.CommonUtils;

public class SQLServerLogin
implements DBAUser,
DBPStatefulObject {
    private final SQLServerDataSource dataSource;
    @NotNull
    private String loginName;
    private long loginId;
    private LoginType loginType;
    private Date createDate;
    private Date modifyDate;
    @Nullable
    private SQLServerDatabase defaultDatabase;
    @Nullable
    private String defaultLanguageName;
    private boolean isDisabled;
    private boolean isFixedRole;
    private String password;

    public SQLServerLogin(@NotNull SQLServerDataSource dataSource, @NotNull String loginName, @NotNull JDBCResultSet resultSet) {
        SQLServerDatabase database;
        this.dataSource = dataSource;
        this.loginName = loginName;
        this.loginId = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"principal_id");
        String loginTypeChar = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"type");
        if (CommonUtils.isNotEmpty((String)loginTypeChar)) {
            this.loginType = (LoginType)CommonUtils.valueOf(LoginType.class, (String)loginTypeChar);
        }
        this.createDate = JDBCUtils.safeGetDate((ResultSet)resultSet, (String)"create_date");
        this.modifyDate = JDBCUtils.safeGetDate((ResultSet)resultSet, (String)"modify_date");
        String defaultDatabaseName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"default_database_name");
        if (CommonUtils.isNotEmpty((String)defaultDatabaseName) && (database = dataSource.getDatabase(defaultDatabaseName)) != null) {
            this.defaultDatabase = database;
        }
        this.defaultLanguageName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"default_language_name");
        this.isDisabled = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"is_disabled");
        this.isFixedRole = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"is_fixed_role");
    }

    public SQLServerLogin(SQLServerDataSource dataSource, @NotNull String loginName) {
        this.dataSource = dataSource;
        this.loginName = loginName;
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    @NotNull
    public SQLServerDataSource getDataSource() {
        return this.dataSource;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.loginName;
    }

    public void setLoginName(@NotNull String loginName) {
        this.loginName = loginName;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public boolean isPersisted() {
        return true;
    }

    @Property(viewable=true, order=2)
    public long getLoginId() {
        return this.loginId;
    }

    @Property(viewable=true, order=3)
    public String getLoginTypeName() {
        return this.loginType.getLoginType();
    }

    @Property(viewable=true, order=4)
    public Date getCreateDate() {
        return this.createDate;
    }

    @Property(viewable=true, order=5)
    public Date getModifyDate() {
        return this.modifyDate;
    }

    @Property(viewable=true, order=6)
    @Nullable
    public SQLServerDatabase getDefaultDatabase() {
        return this.defaultDatabase;
    }

    @Property(viewable=true, order=7)
    @Nullable
    public String getDefaultLanguageName() {
        return this.defaultLanguageName;
    }

    @Property(viewable=true, updatable=true, order=8)
    public boolean isDisabled() {
        return this.isDisabled;
    }

    public void setDisabled(boolean disabled) {
        this.isDisabled = disabled;
    }

    @Property(viewable=true, order=9)
    public boolean isFixedRole() {
        return this.isFixedRole;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @NotNull
    public DBSObjectState getObjectState() {
        if (this.isDisabled) {
            return DBSObjectState.INVALID;
        }
        return DBSObjectState.NORMAL;
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) {
    }

    public static enum LoginType {
        S("SQL Server login"),
        U("Windows login"),
        G("Windows group"),
        R("Server role"),
        C("Login mapped to a certificate"),
        E("External Login"),
        X("External group"),
        K("Login mapped to an asymmetric key");

        private final String loginType;

        private LoginType(String loginType) {
            this.loginType = loginType;
        }

        public String getLoginType() {
            return this.loginType;
        }
    }
}

